/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.content;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.ForgeI18n;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3956;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.TextComponentData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.TextComponentElement;
import slimeknights.mantle.client.screen.book.element.TextElement;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.client.book.elements.TinkerItemElement;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.item.RepairKitItem;

public abstract class AbstractMaterialContent
extends PageContent {
    private static final class_2561 PART_BUILDER = TConstruct.makeTranslation("book", "material.part_builder");
    private static final String CAST_FROM = TConstruct.makeTranslationKey("book", "material.cast_from");
    private static final String COMPOSITE_FROM = TConstruct.makeTranslationKey("book", "material.composite_from");
    private transient MaterialVariantId materialVariant;
    private transient List<class_1799> repairStacks;
    private transient IMaterial material;
    @SerializedName(value="material")
    public String materialName;
    public boolean detailed;

    public AbstractMaterialContent(MaterialVariantId materialVariant, boolean detailed) {
        this.materialName = materialVariant.toString();
        this.materialVariant = materialVariant;
        this.detailed = detailed;
    }

    public abstract class_2960 getId();

    @Nullable
    protected abstract MaterialStatsId getStatType(int var1);

    protected abstract String getTextKey(MaterialId var1);

    protected abstract boolean supportsStatType(MaterialStatsId var1);

    protected MaterialVariantId getMaterialVariant() {
        if (this.materialVariant == null) {
            this.materialVariant = MaterialVariantId.parse(this.materialName);
        }
        return this.materialVariant;
    }

    protected IMaterial getMaterial() {
        if (this.material == null) {
            this.material = MaterialRegistry.getMaterial(this.getMaterialVariant().getId());
        }
        return this.material;
    }

    protected List<class_1799> getRepairStacks() {
        if (this.repairStacks == null) {
            class_638 world = class_310.method_1551().field_1687;
            if (world == null) {
                return Collections.emptyList();
            }
            MaterialVariantId material = this.getMaterialVariant();
            this.repairStacks = RecipeHelper.getUIRecipes((class_1863)world.method_8433(), (class_3956)((class_3956)TinkerRecipeTypes.MATERIAL.get()), MaterialRecipe.class, recipe -> material.matchesVariant(recipe.getMaterial())).stream().flatMap(recipe -> Arrays.stream(recipe.getIngredient().method_8105())).collect(Collectors.toList());
            if (this.repairStacks.isEmpty()) {
                TConstruct.LOG.debug("Material with id " + material + " has no representation items associated with it, using repair kit");
                this.repairStacks = Collections.singletonList(((RepairKitItem)TinkerToolParts.repairKit.get()).withMaterialForDisplay(material));
            }
        }
        return this.repairStacks;
    }

    public List<class_1799> getDisplayStacks() {
        return this.getRepairStacks();
    }

    @Nonnull
    public String getTitle() {
        return this.getTitleComponent().getString();
    }

    public class_2561 getTitleComponent() {
        return MaterialTooltipCache.getDisplayName(this.getMaterialVariant());
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        MaterialVariantId materialVariant = this.getMaterialVariant();
        this.addTitle(list, this.getTitle(), true, MaterialTooltipCache.getColor(materialVariant).method_27716());
        this.addDisplayItems(list, rightSide ? 164 : 0, materialVariant);
        int col_margin = 22;
        int top = this.getTitleHeight();
        int left = rightSide ? 0 : col_margin;
        int y = top;
        int x = left + 5;
        int w = 86;
        MaterialId material = materialVariant.getId();
        y = Math.max(this.addStatsDisplay(x - 3, y, w, list, material, this.getStatType(0)), this.addStatsDisplay(x + w - 3, y, w, list, material, this.getStatType(1)));
        y = Math.max(this.addStatsDisplay(x - 3, y, w, list, material, this.getStatType(2)), this.addStatsDisplay(x + w - 3, y, w, list, material, this.getStatType(3)));
        String textKey = this.getTextKey(material);
        if (class_1074.method_4663((String)textKey)) {
            Object translated = ForgeI18n.getPattern((String)textKey);
            if (!this.detailed) {
                translated = "\"" + (String)translated + "\"";
            }
            TextData flavourData = new TextData((String)translated);
            flavourData.italic = !this.detailed;
            list.add((BookElement)new TextElement(x - 3, y + 5, 182 - col_margin - 5, 60, new TextData[]{flavourData}));
        }
    }

    protected int addStatsDisplay(int x, int y, int w, ArrayList<BookElement> list, MaterialId material, @Nullable MaterialStatsId statsId) {
        if (statsId == null) {
            return y;
        }
        Optional stats = MaterialRegistry.getInstance().getMaterialStats(material, statsId);
        if (stats.isEmpty()) {
            return y;
        }
        List<ModifierEntry> traits = MaterialRegistry.getInstance().getTraits(material, statsId);
        LinkedList parts = Lists.newLinkedList();
        for (IToolPart part : this.getToolParts()) {
            if (part.getStatType() != statsId) continue;
            parts.add(part.withMaterial(material));
        }
        int textOffset = 0;
        if (!parts.isEmpty()) {
            TinkerItemElement display = new TinkerItemElement(x, y + 1, 0.5f, parts);
            list.add((BookElement)display);
            textOffset = 10;
        }
        TextElement name = new TextElement(x + textOffset, y, w - textOffset, 10, ((IMaterialStats)stats.get()).getLocalizedName().getString());
        name.text[0].bold = true;
        name.text[0].underlined = true;
        list.add((BookElement)name);
        y += 12;
        ArrayList lineData = Lists.newArrayList();
        List<class_2561> localizedDescription = ((IMaterialStats)stats.get()).getLocalizedDescriptions();
        if (!(localizedDescription.isEmpty() || localizedDescription.size() <= 1 && localizedDescription.get(0) == class_2561.method_43473())) {
            lineData.addAll(AbstractMaterialContent.getStatLines((IMaterialStats)stats.get()));
        }
        lineData.addAll(AbstractMaterialContent.getTraitLines(traits));
        list.add((BookElement)new TextComponentElement(x, y, w, 176, (Collection)lineData));
        return y + lineData.size() * 5 + 3;
    }

    private static List<TextComponentData> getStatLines(IMaterialStats stats) {
        ArrayList<TextComponentData> lineData = new ArrayList<TextComponentData>();
        List<class_2561> localizedDescription = stats.getLocalizedDescriptions();
        for (int i = 0; i < stats.getLocalizedInfo().size(); ++i) {
            TextComponentData text = new TextComponentData(stats.getLocalizedInfo().get(i));
            text.tooltips = localizedDescription.get(i).getString().isEmpty() ? null : new class_2561[]{localizedDescription.get(i)};
            lineData.add(text);
            lineData.add(new TextComponentData("\n"));
        }
        return lineData;
    }

    private static List<TextComponentData> getTraitLines(List<ModifierEntry> traits) {
        ArrayList<TextComponentData> lineData = new ArrayList<TextComponentData>();
        for (ModifierEntry trait : traits) {
            Modifier mod = trait.getModifier();
            TextComponentData textComponentData = new TextComponentData(mod.getDisplayName());
            List<class_2561> textComponents = mod.getDescriptionList(trait.getLevel());
            textComponentData.tooltips = textComponents.toArray(new class_2561[0]);
            textComponentData.text = textComponentData.text.method_27661().method_27695(new class_124[]{class_124.field_1063, class_124.field_1073});
            lineData.add(textComponentData);
            lineData.add(new TextComponentData("\n"));
        }
        return lineData;
    }

    private static boolean hasStatType(MaterialId materialId, MaterialStatsId statsId) {
        return MaterialRegistry.getInstance().getMaterialStats(materialId, statsId).isPresent();
    }

    protected void addPrimaryDisplayItems(List<ItemElement> displayTools, MaterialVariantId materialId) {
        List<MaterialFluidRecipe> fluids;
        TinkerItemElement elementItem;
        if (this.getMaterial().isCraftable()) {
            class_1799 partBuilder = new class_1799((class_1935)TinkerTables.partBuilder.method_8389());
            elementItem = new TinkerItemElement(partBuilder);
            elementItem.tooltip = ImmutableList.of((Object)PART_BUILDER);
            displayTools.add(elementItem);
        }
        if (!(fluids = MaterialCastingLookup.getCastingFluids(materialId)).isEmpty()) {
            elementItem = new TinkerItemElement(0, 0, 1.0f, fluids.stream().flatMap(recipe -> recipe.getFluids().stream()).map(fluid -> new class_1799((class_1935)fluid.getFluid().method_15774())).collect(Collectors.toList()));
            FluidStack firstFluid = fluids.stream().flatMap(recipe -> recipe.getFluids().stream()).findFirst().orElse(FluidStack.EMPTY);
            elementItem.tooltip = ImmutableList.of((Object)class_2561.method_43469((String)CAST_FROM, (Object[])new Object[]{FluidVariantAttributes.getName((FluidVariant)firstFluid.getType())}));
            displayTools.add(elementItem);
        }
        List<MaterialFluidRecipe> composites = MaterialCastingLookup.getCompositeFluids(materialId);
        for (MaterialFluidRecipe composite : composites) {
            MaterialVariant input = composite.getInput();
            if (input == null) continue;
            MaterialVariantId inputId = input.getVariant();
            TinkerItemElement elementItem2 = new TinkerItemElement(0, 0, 1.0f, MaterialCastingLookup.getAllItemCosts().stream().map(Map.Entry::getKey).filter(part -> part.canUseMaterial(inputId.getId()) && part.canUseMaterial(this.material)).map(part -> part.withMaterial(inputId)).collect(Collectors.toList()));
            FluidStack firstFluid = composite.getFluids().stream().findFirst().orElse(FluidStack.EMPTY);
            elementItem2.tooltip = ImmutableList.of((Object)class_2561.method_43469((String)COMPOSITE_FROM, (Object[])new Object[]{FluidVariantAttributes.getName((FluidVariant)firstFluid.getType()), MaterialTooltipCache.getDisplayName(inputId)}));
            displayTools.add(elementItem2);
        }
    }

    protected void addDisplayItems(ArrayList<BookElement> list, int x, MaterialVariantId materialVariant) {
        ArrayList displayTools = Lists.newArrayList();
        displayTools.add(new TinkerItemElement(0, 0, 1.0f, this.getRepairStacks()));
        this.addPrimaryDisplayItems(displayTools, materialVariant);
        if (displayTools.size() < 9) {
            MaterialId materialId = materialVariant.getId();
            block0: for (class_6880 item : class_7923.field_41178.method_40286(TinkerTags.Items.MULTIPART_TOOL)) {
                Object object = item.comp_349();
                if (!(object instanceof IModifiable)) continue;
                IModifiable tool = (IModifiable)object;
                List<PartRequirement> requirements = tool.getToolDefinition().getData().getParts();
                MaterialNBT.Builder materials = MaterialNBT.builder();
                boolean usedMaterial = false;
                for (PartRequirement part : requirements) {
                    if (!this.supportsStatType(part.getStatType())) continue block0;
                    if (AbstractMaterialContent.hasStatType(materialId, part.getStatType())) {
                        materials.add(materialVariant);
                        usedMaterial = true;
                        continue;
                    }
                    materials.add(MaterialRegistry.firstWithStatType(part.getStatType()));
                }
                if (!usedMaterial) continue;
                class_1799 display = ToolBuildHandler.buildItemFromMaterials(tool, materials.build());
                displayTools.add(new TinkerItemElement(display));
                if (displayTools.size() != 9) continue;
                break;
            }
        }
        if (!displayTools.isEmpty()) {
            int y = this.getTitleHeight() - 5;
            for (ItemElement element : displayTools) {
                element.x = x;
                element.y = y;
                element.scale = 1.0f;
                y += 16;
                list.add((BookElement)element);
            }
        }
    }

    private List<IToolPart> getToolParts() {
        return RegistryHelper.getTagValueStream((class_2378)class_7923.field_41178, TinkerTags.Items.TOOL_PARTS).filter(item -> item instanceof IToolPart).map(item -> (IToolPart)item).collect(Collectors.toList());
    }
}

