/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.content;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.RecipeManagerAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.ImageElement;
import slimeknights.mantle.client.screen.book.element.TextElement;
import slimeknights.mantle.util.ItemStackList;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.book.content.ContentModifier;
import slimeknights.tconstruct.library.client.book.elements.TinkerItemElement;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.part.IToolPart;

public class ContentTool
extends PageContent {
    public static final transient class_2960 ID = TConstruct.getResource("tool");
    private static final transient String KEY_PROPERTIES = TConstruct.makeTranslationKey("book", "tool.properties");
    private static final transient ImageData IMG_SLOT_1x1 = ContentModifier.IMG_SLOT_1;
    private static final transient ImageData IMG_SLOT_1x2 = new ImageData(ContentModifier.BOOK_MODIFY, 40, 75, 22, 40, 256, 256);
    private static final transient ImageData IMG_SLOT_1x3 = new ImageData(ContentModifier.BOOK_MODIFY, 62, 75, 22, 58, 256, 256);
    private static final transient ImageData IMG_SLOT_2x1 = ContentModifier.IMG_SLOT_2;
    private static final transient ImageData IMG_SLOT_2x2 = ContentModifier.IMG_SLOT_4;
    private static final transient ImageData IMG_SLOT_2x3 = new ImageData(ContentModifier.BOOK_MODIFY, 84, 75, 40, 58, 256, 256);
    private static final transient ImageData IMG_SLOT_3x1 = ContentModifier.IMG_SLOT_3;
    private static final transient ImageData IMG_SLOT_3x2 = new ImageData(ContentModifier.BOOK_MODIFY, 58, 133, 58, 40, 256, 256);
    private static final transient ImageData IMG_SLOT_3x3 = new ImageData(ContentModifier.BOOK_MODIFY, 58, 173, 58, 58, 256, 256);
    private static final transient ImageData[] IMG_SLOTS_SHAPELESS = new ImageData[]{IMG_SLOT_1x1, IMG_SLOT_2x1, IMG_SLOT_3x1, IMG_SLOT_2x2, ContentModifier.IMG_SLOT_5, IMG_SLOT_3x2, IMG_SLOT_3x3, IMG_SLOT_3x3, IMG_SLOT_3x3};
    private static final transient ImageData[][] IMG_SLOTS_SHAPED = new ImageData[][]{{IMG_SLOT_1x1, IMG_SLOT_2x1, IMG_SLOT_3x1}, {IMG_SLOT_1x2, IMG_SLOT_2x2, IMG_SLOT_3x2}, {IMG_SLOT_1x3, IMG_SLOT_2x3, IMG_SLOT_3x3}};
    private static final transient SlotPos[] SLOTS_WIDTH_3 = new SlotPos[]{new SlotPos(3, 3), new SlotPos(21, 3), new SlotPos(39, 3), new SlotPos(3, 22), new SlotPos(21, 22), new SlotPos(39, 22), new SlotPos(3, 40), new SlotPos(21, 40), new SlotPos(39, 40)};
    private static final transient SlotPos[] SLOTS_WIDTH_2 = new SlotPos[]{SLOTS_WIDTH_3[0], SLOTS_WIDTH_3[1], SLOTS_WIDTH_3[3], SLOTS_WIDTH_3[4], SLOTS_WIDTH_3[6], SLOTS_WIDTH_3[7]};
    private static final transient SlotPos[] SLOTS_WIDTH_1 = new SlotPos[]{SLOTS_WIDTH_3[0], SLOTS_WIDTH_3[3], SLOTS_WIDTH_3[6]};
    private static final transient SlotPos[][] SLOTS_WIDTH = new SlotPos[][]{SLOTS_WIDTH_1, SLOTS_WIDTH_2, SLOTS_WIDTH_3};
    private static final transient SlotPos[] SLOTS_5 = new SlotPos[]{SLOTS_WIDTH_3[0], SLOTS_WIDTH_3[1], SLOTS_WIDTH_3[2], new SlotPos(12, 22), new SlotPos(30, 22)};
    @Nullable
    private transient IModifiableDisplay tool;
    private transient List<ItemStackList> parts;
    private transient ImageData imgSlots;
    private transient SlotPos[] slotPos;
    public TextData[] text = new TextData[0];
    public String[] properties = new String[0];
    @SerializedName(value="tool")
    public String toolName;

    public ContentTool() {
    }

    public ContentTool(IModifiableDisplay tool) {
        this.tool = tool;
        this.toolName = Objects.requireNonNull(class_7923.field_41178.method_10221((Object)tool.method_8389())).toString();
    }

    public IModifiableDisplay getTool() {
        if (this.tool == null) {
            class_1792 tool;
            if (this.toolName == null) {
                this.toolName = this.parent.name;
            }
            this.tool = (tool = (class_1792)class_7923.field_41178.method_10223(new class_2960(this.toolName))) instanceof IModifiableDisplay ? (IModifiableDisplay)tool : new Fallback((class_1935)(tool == null ? class_1802.field_8077 : tool));
        }
        return this.tool;
    }

    public String getTitle() {
        if (this.tool != null) {
            return this.tool.getLocalizedName().getString();
        }
        return "";
    }

    public void load() {
        if (this.parts == null || this.slotPos == null) {
            List<PartRequirement> required = this.getTool().getToolDefinition().getData().getParts();
            if (required.isEmpty()) {
                class_1860 recipe = Optional.ofNullable(class_310.method_1551().field_1687).flatMap(world -> ((RecipeManagerAccessor)world.method_8433()).port_lib$byType(class_3956.field_17545).values().stream().filter(r -> r.method_8110(world.method_30349()).method_7909() == this.getTool().method_8389()).findFirst()).orElse(null);
                if (recipe != null) {
                    this.parts = recipe.method_8117().stream().map(ingredient -> ItemStackList.of((class_1799[])ingredient.method_8105())).collect(Collectors.toList());
                    if (recipe instanceof class_1869) {
                        class_1869 shaped = (class_1869)recipe;
                        int width = class_3532.method_15340((int)(shaped.method_8150() - 1), (int)0, (int)2);
                        this.imgSlots = IMG_SLOTS_SHAPED[class_3532.method_15340((int)(shaped.method_8158() - 1), (int)0, (int)2)][width];
                        this.slotPos = SLOTS_WIDTH[width];
                    }
                } else {
                    this.parts = Collections.emptyList();
                }
            } else {
                ImmutableList.Builder partBuilder = ImmutableList.builder();
                for (int i = 0; i < required.size(); ++i) {
                    IToolPart part = required.get(i).getPart();
                    if (part == null) continue;
                    class_1799 stack = part.withMaterialForDisplay(ToolBuildHandler.getRenderMaterial(i));
                    stack.method_7948().method_10556("tic_display", true);
                    partBuilder.add((Object)ItemStackList.of((class_1799[])new class_1799[]{stack}));
                }
                this.parts = partBuilder.build();
            }
            if (this.slotPos == null) {
                int size = this.parts.size();
                switch (size) {
                    case 4: {
                        this.slotPos = SLOTS_WIDTH_2;
                        break;
                    }
                    case 5: {
                        this.slotPos = SLOTS_5;
                        break;
                    }
                    default: {
                        this.slotPos = SLOTS_WIDTH_3;
                    }
                }
                if (size > 0) {
                    this.imgSlots = IMG_SLOTS_SHAPELESS[Math.min(size - 1, 9)];
                }
            }
        }
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean brightSide) {
        this.addTitle(list, this.getTitle());
        int padding = 5;
        int h = 50;
        int y = this.getTitleHeight();
        list.add((BookElement)new TextElement(padding, y, 182 - padding * 2, h, this.text));
        int imgWidth = 0;
        int imgHeight = 0;
        int partsSize = this.parts.size();
        if (partsSize > 0 && this.imgSlots != null) {
            imgWidth = this.imgSlots.width;
            imgHeight = this.imgSlots.height;
        }
        int imgX = 111;
        int imgY = 118;
        imgX = imgX + 29 - imgWidth / 2;
        imgY = imgY + 20 - imgHeight / 2;
        if (this.properties.length > 0) {
            TextData head = new TextData(class_1074.method_4662((String)KEY_PROPERTIES, (Object[])new Object[0]));
            head.underlined = true;
            list.add((BookElement)new TextElement(padding, 30 + h, 86 - padding, 176 - h - 20, new TextData[]{head}));
            ArrayList effectData = Lists.newArrayList();
            for (String e : this.properties) {
                effectData.add(new TextData("\u25cf "));
                effectData.add(new TextData(e));
                effectData.add(new TextData("\n"));
            }
            list.add((BookElement)new TextElement(padding, 44 + h, 96, 176 - h - 20, (Collection)effectData));
        }
        list.add((BookElement)new ImageElement(imgX + (imgWidth - ContentModifier.IMG_TABLE.width) / 2, imgY + 28, -1, -1, ContentModifier.IMG_TABLE));
        if (this.imgSlots != null) {
            list.add((BookElement)new ImageElement(imgX, imgY, -1, -1, this.imgSlots, book.appearance.slotColor));
        }
        class_1799 demo = this.getTool().getRenderTool();
        TinkerItemElement toolItem = new TinkerItemElement(imgX + (imgWidth - 16) / 2, imgY - 24, 1.0f, demo);
        list.add((BookElement)toolItem);
        list.add((BookElement)new ImageElement(imgX + (imgWidth - 22) / 2, imgY - 27, -1, -1, IMG_SLOT_1x1, 0xFFFFFF));
        for (int i = 0; i < partsSize; ++i) {
            SlotPos pos = this.slotPos[i];
            TinkerItemElement partItem = new TinkerItemElement(imgX + pos.x(), imgY + pos.y(), 1.0f, (Collection)this.parts.get(i));
            list.add((BookElement)partItem);
        }
    }

    private static class Fallback
    implements IModifiableDisplay {
        private final class_1792 item;
        private final class_1799 renderTool;

        private Fallback(class_1935 item) {
            this.item = item.method_8389();
            this.renderTool = new class_1799(item);
        }

        public class_1792 method_8389() {
            return this.item;
        }

        @Override
        public ToolDefinition getToolDefinition() {
            return ToolDefinition.EMPTY;
        }

        @Override
        public class_1799 getRenderTool() {
            return this.renderTool;
        }
    }

    private record SlotPos(int x, int y) {
    }
}

