/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.material;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import slimeknights.tconstruct.library.client.data.spritetransformer.IColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.client.data.spritetransformer.RecolorSpriteTransformer;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoJson;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;
import slimeknights.tconstruct.tools.stats.RepairKitStats;

public abstract class AbstractMaterialSpriteProvider {
    private final Map<class_2960, MaterialSpriteInfoBuilder> materialBuilders = new HashMap<class_2960, MaterialSpriteInfoBuilder>();
    private Map<class_2960, MaterialSpriteInfo> builtMaterials = null;

    public abstract String getName();

    protected abstract void addAllMaterials();

    public Map<class_2960, MaterialSpriteInfo> getMaterials() {
        if (this.builtMaterials == null) {
            this.addAllMaterials();
            this.builtMaterials = this.materialBuilders.values().stream().map(MaterialSpriteInfoBuilder::build).collect(Collectors.toMap(MaterialSpriteInfo::getTexture, Function.identity()));
            this.materialBuilders.clear();
        }
        return this.builtMaterials;
    }

    @Nullable
    public MaterialSpriteInfo getMaterialInfo(class_2960 name) {
        return this.getMaterials().get(name);
    }

    protected MaterialSpriteInfoBuilder buildMaterial(class_2960 name) {
        if (this.builtMaterials != null) {
            throw new IllegalStateException("Attempted to add a material when materials already built");
        }
        return this.materialBuilders.computeIfAbsent(name, MaterialSpriteInfoBuilder::new);
    }

    protected MaterialSpriteInfoBuilder buildMaterial(MaterialId name) {
        return this.buildMaterial((class_2960)name);
    }

    protected MaterialSpriteInfoBuilder buildMaterial(MaterialVariantId name) {
        return this.buildMaterial(name.getLocation('_'));
    }

    public static class MaterialSpriteInfo
    extends MaterialRenderInfoJson.MaterialGeneratorJson {
        private final transient class_2960 texture;
        private final transient String[] fallbacks;

        public MaterialSpriteInfo(class_2960 texture, String[] fallbacks, MaterialRenderInfoJson.MaterialGeneratorJson generatorJson) {
            super(generatorJson);
            this.texture = texture;
            this.fallbacks = fallbacks;
        }

        public MaterialSpriteInfo(class_2960 texture, String[] fallbacks, ISpriteTransformer transformer, Set<MaterialStatsId> supportedStats) {
            super(transformer, supportedStats, false);
            this.texture = texture;
            this.fallbacks = fallbacks;
        }

        @Override
        public boolean supportStatType(MaterialStatsId statType) {
            if (super.supportStatType(statType)) {
                return true;
            }
            if (!this.ignoreMaterialStats && MaterialRegistry.isFullyLoaded()) {
                return MaterialRegistry.getInstance().getMaterialStats(new MaterialId(this.texture), statType).isPresent();
            }
            return super.supportStatType(statType);
        }

        public class_2960 getTexture() {
            return this.texture;
        }

        public String[] getFallbacks() {
            return this.fallbacks;
        }
    }

    protected static class MaterialSpriteInfoBuilder {
        private static final String[] EMPTY_STRING_ARRAY = new String[0];
        private final class_2960 texture;
        private String[] fallbacks = EMPTY_STRING_ARRAY;
        private final ImmutableSet.Builder<MaterialStatsId> statTypes = ImmutableSet.builder();
        private ISpriteTransformer transformer;

        public MaterialSpriteInfoBuilder fallbacks(String ... fallbacks) {
            this.fallbacks = fallbacks;
            return this;
        }

        public MaterialSpriteInfoBuilder colorMapper(IColorMapping mapping) {
            return this.transformer(new RecolorSpriteTransformer(mapping));
        }

        public MaterialSpriteInfoBuilder statType(MaterialStatsId statsId) {
            this.statTypes.add((Object)statsId);
            return this;
        }

        public MaterialSpriteInfoBuilder statType(MaterialStatsId ... statsId) {
            this.statTypes.add((Object[])statsId);
            return this;
        }

        public MaterialSpriteInfoBuilder meleeHarvest() {
            this.statType(HeadMaterialStats.ID);
            this.statType(HandleMaterialStats.ID);
            this.statType(ExtraMaterialStats.ID);
            this.statType(RepairKitStats.ID);
            return this;
        }

        public MaterialSpriteInfoBuilder ranged() {
            this.statType(LimbMaterialStats.ID);
            this.statType(GripMaterialStats.ID);
            this.statType(RepairKitStats.ID);
            return this;
        }

        private MaterialSpriteInfo build() {
            if (this.transformer == null) {
                throw new IllegalStateException("Material must have a transformer for a sprite provider");
            }
            ImmutableSet supportedStats = this.statTypes.build();
            if (supportedStats.isEmpty()) {
                throw new IllegalStateException("Material must support at least one stat type");
            }
            return new MaterialSpriteInfo(this.texture, this.fallbacks, this.transformer, (Set<MaterialStatsId>)supportedStats);
        }

        private MaterialSpriteInfoBuilder(class_2960 texture) {
            this.texture = texture;
        }

        public MaterialSpriteInfoBuilder transformer(ISpriteTransformer transformer) {
            this.transformer = transformer;
            return this;
        }
    }
}

