/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7403;
import net.minecraft.class_7923;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionDataBuilder;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionLoader;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public abstract class AbstractToolDefinitionDataProvider
extends GenericDataProvider {
    private static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    private final Map<class_2960, ToolDefinitionDataBuilder> allTools = new HashMap<class_2960, ToolDefinitionDataBuilder>();
    private final String modId;

    public AbstractToolDefinitionDataProvider(FabricDataOutput output, String modId) {
        super(output, class_3264.field_14190, "tinkering/tool_definitions", ToolDefinitionLoader.GSON);
        this.modId = modId;
    }

    protected abstract void addToolDefinitions();

    protected ToolDefinitionDataBuilder define(class_2960 id) {
        return this.allTools.computeIfAbsent(id, i -> ToolDefinitionDataBuilder.builder());
    }

    protected ToolDefinitionDataBuilder define(class_1935 item) {
        return this.define(class_7923.field_41178.method_10221((Object)item.method_8389()));
    }

    protected ToolDefinitionDataBuilder define(ToolDefinition definition) {
        return this.define(definition.getId());
    }

    protected ArmorDataBuilder defineArmor(ModifiableArmorMaterial armorMaterial) {
        return new ArmorDataBuilder(armorMaterial);
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        this.addToolDefinitions();
        Map relevantDefinitions = ToolDefinitionLoader.getInstance().getRegisteredToolDefinitions().stream().filter(def -> def.getId().method_12836().equals(this.modId)).collect(Collectors.toMap(ToolDefinition::getId, Function.identity()));
        for (ToolDefinition definition : relevantDefinitions.values()) {
            class_2960 name = definition.getId();
            if (this.allTools.containsKey(name)) continue;
            throw new IllegalStateException(String.format("Missing tool definition for '%s'", name));
        }
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (Map.Entry<class_2960, ToolDefinitionDataBuilder> entry : this.allTools.entrySet()) {
            class_2960 id = entry.getKey();
            ToolDefinition definition = (ToolDefinition)relevantDefinitions.get(id);
            if (definition == null) {
                throw new IllegalStateException("Unknown tool definition with ID " + id);
            }
            ToolDefinitionData data = entry.getValue().build();
            definition.validate(data);
            futures.add(this.saveThing(cache, id, data));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    protected class ArmorDataBuilder {
        private final class_2960 name;
        private final ToolDefinitionDataBuilder[] builders;
        private final List<ArmorSlotType> slotTypes;

        private ArmorDataBuilder(ModifiableArmorMaterial armorMaterial) {
            this.name = new class_2960(armorMaterial.method_7694());
            this.builders = new ToolDefinitionDataBuilder[4];
            ImmutableList.Builder slotTypes = ImmutableList.builder();
            for (ArmorSlotType slotType : ArmorSlotType.values()) {
                ToolDefinition definition = armorMaterial.getArmorDefinition(slotType);
                if (definition == null) continue;
                this.builders[slotType.getIndex()] = AbstractToolDefinitionDataProvider.this.define(definition);
                slotTypes.add((Object)slotType);
            }
            this.slotTypes = slotTypes.build();
        }

        protected ToolDefinitionDataBuilder getBuilder(ArmorSlotType slotType) {
            ToolDefinitionDataBuilder builder = this.builders[slotType.getIndex()];
            if (builder == null) {
                throw new IllegalArgumentException("Unsupported slot type " + slotType + " for material " + this.name);
            }
            return builder;
        }

        public ArmorDataBuilder part(ArmorSlotType slotType, IToolPart part, int weight) {
            this.getBuilder(slotType).part(part, weight);
            return this;
        }

        public ArmorDataBuilder part(ArmorSlotType slotType, MaterialStatsId statsId, int weight) {
            this.getBuilder(slotType).part(statsId, weight);
            return this;
        }

        public <T> ArmorDataBuilder stat(ArmorSlotType slotType, IToolStat<T> stat, T value) {
            this.getBuilder(slotType).stat(stat, value);
            return this;
        }

        public ArmorDataBuilder stat(ArmorSlotType slotType, IToolStat<Float> stat, float value) {
            return this.stat(slotType, (IToolStat)stat, (Object)Float.valueOf(value));
        }

        public <T> ArmorDataBuilder statAll(IToolStat<T> stat, T value) {
            for (ArmorSlotType slotType : this.slotTypes) {
                this.stat(slotType, stat, value);
            }
            return this;
        }

        public ArmorDataBuilder statAll(IToolStat<Float> stat, float value) {
            return this.statAll((IToolStat)stat, (Object)Float.valueOf(value));
        }

        @SafeVarargs
        public final <T> ArmorDataBuilder statEach(IToolStat<T> stat, T ... values) {
            if (values.length != this.slotTypes.size()) {
                throw new IllegalStateException("Wrong number of stats set");
            }
            for (int i = 0; i < values.length; ++i) {
                this.stat(this.slotTypes.get(i), stat, values[i]);
            }
            return this;
        }

        public final ArmorDataBuilder statEach(IToolStat<Float> stat, float ... values) {
            if (values.length != this.slotTypes.size()) {
                throw new IllegalStateException("Wrong number of stats set");
            }
            for (int i = 0; i < values.length; ++i) {
                this.stat(this.slotTypes.get(i), stat, values[i]);
            }
            return this;
        }

        public ArmorDataBuilder durabilityFactor(float maxDamageFactor) {
            for (ArmorSlotType slotType : this.slotTypes) {
                this.stat(slotType, ToolStats.DURABILITY, (float)MAX_DAMAGE_ARRAY[slotType.getIndex()] * maxDamageFactor);
            }
            return this;
        }

        public ArmorDataBuilder multiplier(ArmorSlotType slotType, FloatToolStat stat, float value) {
            this.getBuilder(slotType).multiplier(stat, value);
            return this;
        }

        public ArmorDataBuilder multiplier(FloatToolStat stat, float value) {
            for (ArmorSlotType slotType : this.slotTypes) {
                this.multiplier(slotType, stat, value);
            }
            return this;
        }

        public ArmorDataBuilder startingSlots(ArmorSlotType armorSlot, SlotType slotType, int value) {
            this.getBuilder(armorSlot).startingSlots(slotType, value);
            return this;
        }

        public ArmorDataBuilder startingSlots(SlotType slotType, int value) {
            for (ArmorSlotType armorSlot : this.slotTypes) {
                this.startingSlots(armorSlot, slotType, value);
            }
            return this;
        }

        public ArmorDataBuilder startingSlots(SlotType slotType, int ... values) {
            if (values.length != this.slotTypes.size()) {
                throw new IllegalStateException("Wrong number of stats set");
            }
            for (int i = 0; i < values.length; ++i) {
                this.startingSlots(this.slotTypes.get(i), slotType, values[i]);
            }
            return this;
        }

        public ArmorDataBuilder trait(ModifierId modifier, int level) {
            for (ArmorSlotType armorSlot : this.slotTypes) {
                this.trait(armorSlot, modifier, level);
            }
            return this;
        }

        public ArmorDataBuilder trait(LazyModifier modifier, int level) {
            return this.trait(modifier.getId(), level);
        }

        public ArmorDataBuilder trait(ModifierId modifier) {
            return this.trait(modifier, 1);
        }

        public ArmorDataBuilder trait(LazyModifier modifier) {
            return this.trait(modifier, 1);
        }

        public ArmorDataBuilder trait(ArmorSlotType slotType, ModifierId modifier, int level) {
            this.getBuilder(slotType).trait(modifier, level);
            return this;
        }

        public ArmorDataBuilder trait(ArmorSlotType slotType, LazyModifier modifier, int level) {
            return this.trait(slotType, modifier.getId(), level);
        }

        public ArmorDataBuilder trait(ArmorSlotType slotType, ModifierId modifier) {
            return this.trait(slotType, modifier, 1);
        }

        public ArmorDataBuilder trait(ArmorSlotType slotType, LazyModifier modifier) {
            return this.trait(slotType, modifier, 1);
        }
    }
}

