/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.definition;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.Material;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.utils.GenericTagUtil;

public class UpdateMaterialsPacket
implements IThreadsafePacket {
    private final Map<MaterialId, IMaterial> materials;
    private final Map<MaterialId, MaterialId> redirects;
    private final Map<class_2960, Collection<IMaterial>> tags;

    public UpdateMaterialsPacket(class_2540 buffer) {
        int materialCount = buffer.readInt();
        ImmutableMap.Builder materials = ImmutableMap.builder();
        for (int i = 0; i < materialCount; ++i) {
            MaterialId id2 = new MaterialId(buffer.method_10810());
            int tier = buffer.method_10816();
            int sortOrder = buffer.method_10816();
            boolean craftable = buffer.readBoolean();
            boolean hidden = buffer.readBoolean();
            materials.put((Object)id2, (Object)new Material(id2, tier, sortOrder, craftable, hidden));
        }
        this.materials = materials.build();
        int redirectCount = buffer.method_10816();
        if (redirectCount == 0) {
            this.redirects = Collections.emptyMap();
        } else {
            this.redirects = new HashMap<MaterialId, MaterialId>(redirectCount);
            for (int i = 0; i < redirectCount; ++i) {
                this.redirects.put(new MaterialId(buffer.method_19772()), new MaterialId(buffer.method_19772()));
            }
        }
        this.tags = GenericTagUtil.decodeTags(buffer, id -> this.materials.get(new MaterialId((class_2960)id)));
    }

    public void encode(class_2540 buffer) {
        buffer.writeInt(this.materials.size());
        this.materials.values().forEach(material -> {
            buffer.method_10812((class_2960)material.getIdentifier());
            buffer.method_10804(material.getTier());
            buffer.method_10804(material.getSortOrder());
            buffer.writeBoolean(material.isCraftable());
            buffer.writeBoolean(material.isHidden());
        });
        buffer.method_10804(this.redirects.size());
        this.redirects.forEach((key, value) -> {
            buffer.method_10814(key.toString());
            buffer.method_10814(value.toString());
        });
        GenericTagUtil.encodeTags(buffer, IMaterial::getIdentifier, this.tags);
    }

    public void handleThreadsafe(ISimplePacket.Context context) {
        MaterialRegistry.updateMaterialsFromServer(this);
    }

    public Map<MaterialId, IMaterial> getMaterials() {
        return this.materials;
    }

    public Map<MaterialId, MaterialId> getRedirects() {
        return this.redirects;
    }

    public Map<class_2960, Collection<IMaterial>> getTags() {
        return this.tags;
    }

    public UpdateMaterialsPacket(Map<MaterialId, IMaterial> materials, Map<MaterialId, MaterialId> redirects, Map<class_2960, Collection<IMaterial>> tags) {
        this.materials = materials;
        this.redirects = redirects;
        this.tags = tags;
    }
}

