/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;

public class FloatMultiplier {
    private final Map<class_2960, Float> values = new HashMap<class_2960, Float>();
    private float calculatedValue = 1.0f;

    private void recalculate() {
        float newValue = 1.0f;
        for (float value : this.values.values()) {
            newValue *= value;
        }
        this.calculatedValue = newValue;
    }

    public void set(class_2960 key, float value) {
        if (value == 1.0f) {
            this.remove(key);
            return;
        }
        Float original = this.values.put(key, Float.valueOf(value));
        if (original != null) {
            if (original.floatValue() == 0.0f) {
                this.recalculate();
            } else {
                this.calculatedValue *= value / original.floatValue();
            }
        } else {
            this.calculatedValue *= value;
        }
    }

    public void remove(class_2960 key) {
        Float value = this.values.remove(key);
        if (value != null) {
            if (value.floatValue() == 0.0f) {
                this.recalculate();
            } else {
                this.calculatedValue /= value.floatValue();
            }
        }
    }

    public float getValue() {
        return this.calculatedValue;
    }
}

