/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.item.ModifierCrystalItem;

public abstract class AbstractModifierRecipe
implements ITinkerStationRecipe,
IDisplayModifierRecipe {
    protected static final String KEY_MAX_LEVEL = TConstruct.makeTranslationKey("recipe", "modifier.max_level");
    protected static final String KEY_NOT_ENOUGH_SLOTS = TConstruct.makeTranslationKey("recipe", "modifier.not_enough_slots");
    protected static final String KEY_NOT_ENOUGH_SLOT = TConstruct.makeTranslationKey("recipe", "modifier.not_enough_slot");
    protected static final ValidatedResult REQUIREMENTS_ERROR = ModifierRecipeLookup.DEFAULT_ERROR;
    private final class_2960 id;
    protected final class_1856 toolRequirement;
    protected final int maxToolSize;
    protected final ModifierMatch requirements;
    protected final String requirementsError;
    protected final ModifierEntry result;
    private final int maxLevel;
    @Nullable
    private final SlotType.SlotCount slots;
    protected final boolean allowCrystal;
    @Nullable
    private List<class_1799> toolInputs = null;
    private List<class_1799> displayInputs = null;
    List<class_1799> toolWithModifier = null;
    private ModifierEntry displayResult;

    protected AbstractModifierRecipe(class_2960 id, class_1856 toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots, boolean allowCrystal) {
        this.id = id;
        this.toolRequirement = toolRequirement;
        this.maxToolSize = maxToolSize;
        this.requirements = requirements;
        this.requirementsError = requirementsError;
        this.result = result;
        this.maxLevel = maxLevel;
        this.slots = slots;
        this.allowCrystal = allowCrystal;
        ModifierRecipeLookup.addRecipeModifier(SlotType.SlotCount.getType(slots), result.getLazyModifier());
        ModifierRecipeLookup.addRequirements(toolRequirement, result, requirements, requirementsError);
    }

    @Deprecated
    protected AbstractModifierRecipe(class_2960 id, class_1856 toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
        this(id, toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots, true);
    }

    @Override
    public abstract ValidatedResult getValidatedResult(ITinkerStationContainer var1, class_5455 var2);

    @Deprecated
    public class_1799 method_8110(class_5455 access) {
        return class_1799.field_8037;
    }

    @Override
    public int shrinkToolSlotBy() {
        return this.maxToolSize;
    }

    List<class_1799> getToolInputs() {
        if (this.toolInputs == null) {
            this.toolInputs = Arrays.stream(this.toolRequirement.method_8105()).map(stack -> {
                if (stack.method_7909() instanceof IModifiableDisplay) {
                    return ((IModifiableDisplay)stack.method_7909()).getRenderTool();
                }
                return stack;
            }).collect(Collectors.toList());
        }
        return this.toolInputs;
    }

    @Override
    public ModifierEntry getDisplayResult() {
        if (this.displayResult == null) {
            int min = this.requirements.getMinLevel(this.result.getId());
            this.displayResult = min > 0 ? new ModifierEntry(this.result.getId(), this.result.getLevel() + min) : this.result;
        }
        return this.displayResult;
    }

    @Override
    public List<class_1799> getToolWithoutModifier() {
        if (this.displayInputs == null) {
            this.displayInputs = this.getToolInputs().stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, this.requirements, null)).collect(Collectors.toList());
        }
        return this.displayInputs;
    }

    @Override
    public List<class_1799> getToolWithModifier() {
        if (this.toolWithModifier == null) {
            this.toolWithModifier = this.getToolInputs().stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, this.requirements, this.result)).collect(Collectors.toList());
        }
        return this.toolWithModifier;
    }

    @Override
    public boolean hasRequirements() {
        return this.requirements != ModifierMatch.ALWAYS;
    }

    @Override
    public String getRequirementsError() {
        if (this.requirementsError.isEmpty()) {
            return ModifierRecipeLookup.DEFAULT_ERROR_KEY;
        }
        return this.requirementsError;
    }

    public static boolean matchesCrystal(ITinkerStationContainer container, ModifierEntry match) {
        boolean found = false;
        for (int i = 0; i < container.getInputCount(); ++i) {
            class_1799 stack = container.getInput(i);
            if (stack.method_7960()) continue;
            if (found || !stack.method_31574(TinkerModifiers.modifierCrystal.method_8389())) {
                return false;
            }
            ModifierId modifier = ModifierCrystalItem.getModifier(stack);
            if (!match.getId().equals((Object)modifier) || stack.method_7947() < match.getLevel()) {
                return found;
            }
            found = true;
        }
        return found;
    }

    protected boolean matchesCrystal(ITinkerStationContainer container) {
        return this.allowCrystal && AbstractModifierRecipe.matchesCrystal(container, this.result);
    }

    public static List<ModifierEntry> getModifiersIgnoringPartial(ToolStack toolStack) {
        ImmutableList.Builder finalList = ImmutableList.builder();
        ModDataNBT persistentData = toolStack.getPersistentData();
        for (ModifierEntry entry : toolStack.getModifierList()) {
            ModifierId modifier = entry.getId();
            int needed = ModifierRecipeLookup.getNeededPerLevel(modifier);
            if (needed == 0 || !persistentData.contains(modifier, 99)) {
                finalList.add((Object)entry);
                continue;
            }
            int has = persistentData.getInt(modifier);
            if (has >= needed) {
                finalList.add((Object)entry);
                continue;
            }
            if (entry.getLevel() <= 1) continue;
            finalList.add((Object)new ModifierEntry(modifier, entry.getLevel() - 1));
        }
        return finalList.build();
    }

    protected ValidatedResult validateRequirements(ToolStack tool) {
        if (this.requirements != ModifierMatch.ALWAYS && !this.requirements.test(AbstractModifierRecipe.getModifiersIgnoringPartial(tool))) {
            return this.requirementsError.isEmpty() ? REQUIREMENTS_ERROR : ValidatedResult.failure(this.requirementsError, new Object[0]);
        }
        return ValidatedResult.PASS;
    }

    protected static ValidatedResult checkSlots(IToolStackView tool, @Nullable SlotType.SlotCount slots) {
        if (slots != null) {
            int count = slots.getCount();
            if (tool.getFreeSlots(slots.getType()) < count) {
                if (count == 1) {
                    return ValidatedResult.failure(KEY_NOT_ENOUGH_SLOT, slots.getType().getDisplayName());
                }
                return ValidatedResult.failure(KEY_NOT_ENOUGH_SLOTS, count, slots.getType().getDisplayName());
            }
        }
        return ValidatedResult.PASS;
    }

    protected ValidatedResult validatePrerequisites(ToolStack tool) {
        ValidatedResult requirements = this.validateRequirements(tool);
        if (requirements.hasError()) {
            return requirements;
        }
        if (this.maxLevel != 0 && tool.getUpgrades().getLevel(this.result.getId()) + this.result.getLevel() > this.maxLevel) {
            return ValidatedResult.failure(KEY_MAX_LEVEL, this.result.getModifier().getDisplayName(), this.maxLevel);
        }
        return AbstractModifierRecipe.checkSlots(tool, this.slots);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.id + "}";
    }

    public class_2960 method_8114() {
        return this.id;
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    @Nullable
    public SlotType.SlotCount getSlots() {
        return this.slots;
    }

    public static abstract class Serializer<T extends AbstractModifierRecipe>
    extends LoggingRecipeSerializer<T> {
        public abstract T fromJson(class_2960 var1, JsonObject var2, class_1856 var3, int var4, ModifierMatch var5, String var6, ModifierEntry var7, int var8, @Nullable SlotType.SlotCount var9);

        public abstract T fromNetwork(class_2960 var1, class_2540 var2, class_1856 var3, int var4, ModifierMatch var5, String var6, ModifierEntry var7, int var8, @Nullable SlotType.SlotCount var9);

        protected ModifierEntry readResult(JsonObject json) {
            return ModifierEntry.fromJson(class_3518.method_15296((JsonObject)json, (String)"result"));
        }

        public final T fromJson(class_2960 id, JsonObject json) {
            class_1856 toolRequirement = class_1856.method_52177((JsonElement)json.get("tools"));
            int maxToolSize = class_3518.method_15282((JsonObject)json, (String)"max_tool_size", (int)16);
            ModifierMatch requirements = ModifierMatch.ALWAYS;
            String requirementsError = "";
            if (json.has("requirements")) {
                JsonObject reqJson = class_3518.method_15296((JsonObject)json, (String)"requirements");
                requirements = ModifierMatch.deserialize(reqJson);
                requirementsError = class_3518.method_15253((JsonObject)reqJson, (String)"error", (String)"");
            }
            ModifierEntry result = this.readResult(json);
            int maxLevel = class_3518.method_15282((JsonObject)json, (String)"max_level", (int)0);
            if (maxLevel < 0) {
                throw new JsonSyntaxException("max must be non-negative");
            }
            SlotType.SlotCount slots = null;
            if (json.has("slots")) {
                slots = SlotType.SlotCount.fromJson(class_3518.method_15296((JsonObject)json, (String)"slots"));
            } else {
                if (json.has("upgrade_slots") && json.has("ability_slots")) {
                    throw new JsonSyntaxException("Cannot set both upgrade_slots and ability_slots");
                }
                if (json.has("upgrade_slots")) {
                    slots = new SlotType.SlotCount(SlotType.UPGRADE, JsonUtils.getIntMin(json, "upgrade_slots", 0));
                    TConstruct.LOG.warn("Using deprecated modifier recipe key upgrade_slots for recipe " + id);
                } else if (json.has("ability_slots")) {
                    slots = new SlotType.SlotCount(SlotType.ABILITY, JsonUtils.getIntMin(json, "ability_slots", 0));
                    TConstruct.LOG.warn("Using deprecated modifier recipe key ability_slots for recipe " + id);
                }
            }
            return this.fromJson(id, json, toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots);
        }

        protected final T fromNetworkSafe(class_2960 id, class_2540 buffer) {
            class_1856 toolRequirement = class_1856.method_8086((class_2540)buffer);
            int maxToolSize = buffer.method_10816();
            ModifierMatch requirements = ModifierMatch.read(buffer);
            String requirementsError = buffer.method_10800(Short.MAX_VALUE);
            ModifierEntry result = ModifierEntry.read(buffer);
            int maxLevel = buffer.method_10816();
            SlotType.SlotCount slots = SlotType.SlotCount.read(buffer);
            return this.fromNetwork(id, buffer, toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots);
        }

        protected void toNetworkSafe(class_2540 buffer, T recipe) {
            ((AbstractModifierRecipe)recipe).toolRequirement.method_8088(buffer);
            buffer.method_10804(((AbstractModifierRecipe)recipe).maxToolSize);
            ((AbstractModifierRecipe)recipe).requirements.write(buffer);
            buffer.method_10814(((AbstractModifierRecipe)recipe).requirementsError);
            ((AbstractModifierRecipe)recipe).result.write(buffer);
            buffer.method_10804(((AbstractModifierRecipe)recipe).getMaxLevel());
            SlotType.SlotCount.write(((AbstractModifierRecipe)recipe).getSlots(), buffer);
        }
    }
}

