/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.LootingModifierHook;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.DummyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ModifierLootingHandler {
    private static final Map<UUID, class_1304> LOOTING_OFFHAND = new HashMap<UUID, class_1304>();
    private static boolean init = false;

    public static void init() {
        if (init) {
            return;
        }
        init = true;
        LivingEntityEvents.LOOTING_LEVEL.register(ModifierLootingHandler::onLooting);
        ServerPlayConnectionEvents.DISCONNECT.register(ModifierLootingHandler::onLeaveServer);
    }

    public static void setLootingSlot(class_1309 entity, class_1304 slotType) {
        if (slotType == class_1304.field_6173) {
            LOOTING_OFFHAND.remove(entity.method_5667());
        } else {
            LOOTING_OFFHAND.put(entity.method_5667(), slotType);
        }
    }

    public static class_1304 getLootingSlot(@Nullable class_1309 entity) {
        return entity != null ? LOOTING_OFFHAND.getOrDefault(entity.method_5667(), class_1304.field_6173) : class_1304.field_6173;
    }

    private static int onLooting(class_1282 damageSource, class_1309 target, int level, boolean recentlyHit) {
        if (damageSource == null) {
            return 0;
        }
        class_1297 source = damageSource.method_5529();
        if (source instanceof class_1309) {
            class_1309 holder = (class_1309)source;
            class_1297 direct = damageSource.method_5526();
            if (direct instanceof class_1665) {
                ModifierNBT modifiers = EntityModifierCapability.getOrEmpty(direct);
                if (!modifiers.isEmpty()) {
                    ModDataNBT persistentData = PersistentDataCapability.CAPABILITY.maybeGet((Object)direct).map(ModDataNBT::new).orElseGet(ModDataNBT::new);
                    DummyToolStack tool = new DummyToolStack(class_1802.field_8162, modifiers, persistentData);
                    level = LootingModifierHook.getLootingValue(TinkerHooks.PROJECTILE_LOOTING, tool, holder, (class_1297)target, damageSource, 0);
                }
            } else {
                class_1304 slotType = ModifierLootingHandler.getLootingSlot(holder);
                class_1799 held = holder.method_6118(slotType);
                if (held.method_31573(TinkerTags.Items.MODIFIABLE)) {
                    ToolStack tool = ToolStack.from(held);
                    level = ModifierUtil.getLootingLevel(tool, holder, (class_1297)target, damageSource);
                } else if (slotType != class_1304.field_6173) {
                    level = 0;
                }
            }
            level = ModifierUtil.getLeggingsLootingLevel(holder, (class_1297)target, damageSource, level);
            return level;
        }
        return 0;
    }

    private static void onLeaveServer(class_3244 handler, MinecraftServer server) {
        LOOTING_OFFHAND.remove(handler.method_32311().method_5667());
    }
}

