/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.module;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3913;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.smeltery.block.entity.module.MeltingModule;
import slimeknights.tconstruct.smeltery.block.entity.module.SnapshotData;

public class MeltingModuleInventory
implements SlottedStackStorage,
TransactionContext.CloseCallback {
    private static final String TAG_SLOT = "slot";
    private static final String TAG_ITEMS = "items";
    private static final String TAG_SIZE = "size";
    private final MantleBlockEntity parent;
    protected final SlottedStorage<FluidVariant> fluidHandler;
    private MeltingModule[] modules;
    private final boolean strictSize;
    private final IMeltingContainer.IOreRate oreRate;
    private final List<SnapshotData> snapshots = new ArrayList<SnapshotData>();

    public MeltingModuleInventory(MantleBlockEntity parent, SlottedStorage<FluidVariant> fluidHandler, IMeltingContainer.IOreRate oreRate, int size) {
        this.parent = parent;
        this.fluidHandler = fluidHandler;
        this.modules = new MeltingModule[size];
        this.oreRate = oreRate;
        this.strictSize = size != 0;
    }

    public MeltingModuleInventory(MantleBlockEntity parent, SlottedStorage<FluidVariant> fluidHandler, IMeltingContainer.IOreRate oreRate) {
        this(parent, fluidHandler, oreRate, 0);
    }

    public int getSlotCount() {
        return this.modules.length;
    }

    public boolean validSlot(int slot) {
        return slot >= 0 && slot < this.getSlotCount();
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemVariant stack, int count) {
        return true;
    }

    private boolean hasModule(int slot) {
        return this.validSlot(slot) && this.modules[slot] != null;
    }

    public int getCurrentTime(int slot) {
        return this.hasModule(slot) ? this.modules[slot].getCurrentTime() : 0;
    }

    public int getRequiredTime(int slot) {
        return this.hasModule(slot) ? this.modules[slot].getRequiredTime() : 0;
    }

    public int getRequiredTemp(int slot) {
        return this.hasModule(slot) ? this.modules[slot].getRequiredTemp() : 0;
    }

    public MeltingModule getModule(int slot) {
        if (!this.validSlot(slot)) {
            throw new IndexOutOfBoundsException();
        }
        if (this.modules[slot] == null) {
            this.modules[slot] = new MeltingModule(this.parent, recipe -> this.tryFillTank(slot, (IMeltingRecipe)recipe), this.oreRate, slot);
        }
        return this.modules[slot];
    }

    public void resize(int newSize, Consumer<class_1799> stackConsumer) {
        if (this.strictSize) {
            throw new IllegalStateException("Cannot resize this melting module inventory");
        }
        if (newSize == this.modules.length) {
            return;
        }
        if (newSize < this.modules.length) {
            for (int i = newSize; i < this.modules.length; ++i) {
                if (this.modules[i] == null || this.modules[i].getStack().method_7960()) continue;
                stackConsumer.accept(this.modules[i].getStack());
            }
        }
        this.modules = Arrays.copyOf(this.modules, newSize);
        this.parent.setChangedFast();
    }

    @Nonnull
    public class_1799 getStackInSlot(int slot) {
        if (this.validSlot(slot) && this.modules[slot] != null) {
            return this.modules[slot].getStack();
        }
        return class_1799.field_8037;
    }

    public void setStackInSlot(int slot, class_1799 stack) {
        if (this.validSlot(slot)) {
            if (stack.method_7960()) {
                if (this.modules[slot] != null) {
                    this.modules[slot].setStack(class_1799.field_8037);
                }
            } else {
                if (stack.method_7947() > 1) {
                    stack.method_7939(1);
                }
                this.getModule(slot).setStack(stack);
            }
        }
    }

    public long insertSlot(int slot, ItemVariant resource, long amount, TransactionContext transaction) {
        if (resource.isBlank()) {
            return 0L;
        }
        if (slot < 0 || slot >= this.getSlotCount()) {
            return 0L;
        }
        MeltingModule module = this.getModule(slot);
        boolean canInsert = module.getStack().method_7960();
        if (canInsert) {
            this.updateSnapshots(slot, transaction);
            this.setStackInSlot(slot, resource.toStack((int)amount));
        }
        return canInsert ? amount : 0L;
    }

    public long extractSlot(int slot, ItemVariant resource, long amount, TransactionContext transaction) {
        if (amount == 0L) {
            return 0L;
        }
        if (!this.validSlot(slot)) {
            return 0L;
        }
        class_1799 existing = this.getStackInSlot(slot);
        if (existing.method_7960()) {
            return 0L;
        }
        this.updateSnapshots(slot, transaction);
        this.setStackInSlot(slot, class_1799.field_8037);
        return existing.method_7947();
    }

    public SingleSlotStorage<ItemVariant> getSlot(int slot) {
        return this.getModule(slot);
    }

    public boolean canHeat(int temperature) {
        for (MeltingModule module : this.modules) {
            if (module == null || !module.canHeatItem(temperature)) continue;
            return true;
        }
        return false;
    }

    protected boolean tryFillTank(int index, IMeltingRecipe recipe) {
        FluidStack fluid = recipe.getOutput(this.getModule(index));
        if (StorageUtil.simulateInsert(this.fluidHandler, (Object)fluid.getType(), (long)fluid.getAmount(), null) == fluid.getAmount()) {
            try (Transaction tx = TransferUtil.getTransaction();){
                this.fluidHandler.insert((Object)fluid.getType(), fluid.getAmount(), (TransactionContext)tx);
                tx.commit();
            }
            return true;
        }
        return false;
    }

    public void heatItems(int temperature) {
        for (MeltingModule module : this.modules) {
            if (module == null) continue;
            module.heatItem(temperature);
        }
    }

    public void coolItems() {
        for (MeltingModule module : this.modules) {
            if (module == null) continue;
            module.coolItem();
        }
    }

    public class_2487 writeToTag() {
        class_2487 nbt = new class_2487();
        class_2499 list = new class_2499();
        for (int i = 0; i < this.modules.length; ++i) {
            if (this.modules[i] == null || this.modules[i].getStack().method_7960()) continue;
            class_2487 moduleTag = this.modules[i].writeToTag();
            moduleTag.method_10567(TAG_SLOT, (byte)i);
            list.add((Object)moduleTag);
        }
        if (!list.isEmpty()) {
            nbt.method_10566(TAG_ITEMS, (class_2520)list);
        }
        nbt.method_10567(TAG_SIZE, (byte)this.modules.length);
        return nbt;
    }

    public void readFromTag(class_2487 nbt) {
        int newSize;
        if (!this.strictSize && (newSize = nbt.method_10571(TAG_SIZE) & 0xFF) != this.modules.length) {
            this.modules = Arrays.copyOf(this.modules, newSize);
        }
        for (MeltingModule module : this.modules) {
            if (module == null) continue;
            module.setStack(class_1799.field_8037);
        }
        class_2499 list = nbt.method_10554(TAG_ITEMS, 10);
        for (int i = 0; i < list.size(); ++i) {
            int slot;
            class_2487 item = list.method_10602(i);
            if (!item.method_10573(TAG_SLOT, 1) || !this.validSlot(slot = item.method_10571(TAG_SLOT) & 0xFF)) continue;
            this.getModule(slot).readFromTag(item);
        }
    }

    public void trackInts(Consumer<class_3913> consumer) {
        for (int i = 0; i < this.getSlotCount(); ++i) {
            consumer.accept(this.getModule(i));
        }
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        long totalInserted = 0L;
        for (int i = 0; i < this.getSlotCount(); ++i) {
            long inserted = this.insertSlot(i, resource, maxAmount, transaction);
            totalInserted += inserted;
            maxAmount -= inserted;
        }
        return totalInserted;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        long totalExtracted = 0L;
        for (int i = 0; i < this.getSlotCount(); ++i) {
            long extracted = this.extractSlot(i, resource, maxAmount, transaction);
            totalExtracted += extracted;
            maxAmount -= extracted;
        }
        return totalExtracted;
    }

    protected SnapshotData createSnapshot(int slot) {
        return new SnapshotData(slot, this.getStackInSlot(slot));
    }

    protected void readSnapshot(SnapshotData snapshot) {
        this.setStackInSlot(snapshot.slot(), snapshot.stack());
    }

    public void updateSnapshots(int slot, TransactionContext transaction) {
        while (this.snapshots.size() <= transaction.nestingDepth()) {
            this.snapshots.add(null);
        }
        if (this.snapshots.get(transaction.nestingDepth()) == null) {
            SnapshotData snapshot = this.createSnapshot(slot);
            Objects.requireNonNull(snapshot, "Snapshot may not be null!");
            this.snapshots.set(transaction.nestingDepth(), snapshot);
            transaction.addCloseCallback((TransactionContext.CloseCallback)this);
        }
    }

    public void onClose(TransactionContext transaction, TransactionContext.Result result) {
        SnapshotData snapshot = this.snapshots.set(transaction.nestingDepth(), null);
        if (result.wasAborted()) {
            this.readSnapshot(snapshot);
        } else if (transaction.nestingDepth() > 0 && this.snapshots.get(transaction.nestingDepth() - 1) == null) {
            this.snapshots.set(transaction.nestingDepth() - 1, snapshot);
            transaction.getOpenTransaction(transaction.nestingDepth() - 1).addCloseCallback((TransactionContext.CloseCallback)this);
        }
    }
}

