/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.render;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import slimeknights.mantle.client.render.FluidRenderer;
import slimeknights.tconstruct.library.client.TinkerRenderTypes;
import slimeknights.tconstruct.smeltery.block.entity.tank.SmelteryTank;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiSmelteryTank;

public class SmelteryTankRenderer {
    private static final float FLUID_OFFSET = 0.005f;
    private static final int HEIGHT_OFFSET = 9;

    private static float[] getBlockBounds(int delta) {
        return SmelteryTankRenderer.getBlockBounds(delta, 0.005f, (float)delta + 1.0f - 0.005f);
    }

    private static float[] getBlockBounds(int delta, float start, float end) {
        float[] bounds = new float[2 + delta];
        bounds[0] = start;
        int offset = (int)start;
        for (int i = 1; i <= delta; ++i) {
            bounds[i] = i + offset;
        }
        bounds[delta + 1] = end;
        return bounds;
    }

    public static void renderFluids(class_4587 matrices, class_4597 buffer, SmelteryTank<?> tank, class_2338 tankMinPos, class_2338 tankMaxPos, int brightness) {
        List<FluidStack> fluids = tank.getFluids();
        if (!fluids.isEmpty()) {
            int xd = tankMaxPos.method_10263() - tankMinPos.method_10263();
            int zd = tankMaxPos.method_10260() - tankMinPos.method_10260();
            if (xd < 0 || zd < 0) {
                return;
            }
            float[] xBounds = SmelteryTankRenderer.getBlockBounds(xd);
            float[] zBounds = SmelteryTankRenderer.getBlockBounds(zd);
            int yd = 1 + Math.max(0, tankMaxPos.method_10264() - tankMinPos.method_10264());
            int[] heights = GuiSmelteryTank.calcLiquidHeights(fluids, tank.getCapacity(), yd * 1000 - 9, 100);
            class_4588 builder = buffer.getBuffer(TinkerRenderTypes.SMELTERY_FLUID);
            float curY = 0.005f;
            for (int i = 0; i < fluids.size(); ++i) {
                float h = (float)heights[i] / 1000.0f;
                SmelteryTankRenderer.renderLargeFluidCuboid(matrices, builder, fluids.get(i), brightness, xd, xBounds, zd, zBounds, curY, curY + h);
                curY += h;
            }
        }
    }

    private static void renderLargeFluidCuboid(class_4587 matrices, class_4588 builder, FluidStack fluid, int brightness, int xd, float[] xBounds, int zd, float[] zBounds, float yMin, float yMax) {
        if (yMin >= yMax || fluid.isEmpty()) {
            return;
        }
        class_1058 still = FluidVariantRendering.getSprite((FluidVariant)fluid.getType());
        int color = FluidVariantRendering.getColor((FluidVariant)fluid.getType());
        brightness = FluidRenderer.withBlockLight((int)brightness, (int)FluidVariantAttributes.getLuminance((FluidVariant)fluid.getType()));
        boolean upsideDown = FluidVariantAttributes.isLighterThanAir((FluidVariant)fluid.getType());
        int yd = (int)(yMax - (float)((int)yMin));
        if ((double)yMax % 1.0 == 0.0) {
            --yd;
        }
        float[] yBounds = SmelteryTankRenderer.getBlockBounds(yd, yMin, yMax);
        Matrix4f matrix = matrices.method_23760().method_23761();
        Vector3f from = new Vector3f();
        Vector3f to = new Vector3f();
        int rotation = upsideDown ? 180 : 0;
        for (int y = 0; y <= yd; ++y) {
            for (int z = 0; z <= zd; ++z) {
                for (int x = 0; x <= xd; ++x) {
                    from.set(xBounds[x], yBounds[y], zBounds[z]);
                    to.set(xBounds[x + 1], yBounds[y + 1], zBounds[z + 1]);
                    if (x == 0) {
                        FluidRenderer.putTexturedQuad((class_4588)builder, (Matrix4f)matrix, (class_1058)still, (Vector3f)from, (Vector3f)to, (class_2350)class_2350.field_11039, (int)color, (int)brightness, (int)rotation, (boolean)false);
                    }
                    if (x == xd) {
                        FluidRenderer.putTexturedQuad((class_4588)builder, (Matrix4f)matrix, (class_1058)still, (Vector3f)from, (Vector3f)to, (class_2350)class_2350.field_11034, (int)color, (int)brightness, (int)rotation, (boolean)false);
                    }
                    if (z == 0) {
                        FluidRenderer.putTexturedQuad((class_4588)builder, (Matrix4f)matrix, (class_1058)still, (Vector3f)from, (Vector3f)to, (class_2350)class_2350.field_11043, (int)color, (int)brightness, (int)rotation, (boolean)false);
                    }
                    if (z == zd) {
                        FluidRenderer.putTexturedQuad((class_4588)builder, (Matrix4f)matrix, (class_1058)still, (Vector3f)from, (Vector3f)to, (class_2350)class_2350.field_11035, (int)color, (int)brightness, (int)rotation, (boolean)false);
                    }
                    if (y == yd) {
                        FluidRenderer.putTexturedQuad((class_4588)builder, (Matrix4f)matrix, (class_1058)still, (Vector3f)from, (Vector3f)to, (class_2350)class_2350.field_11036, (int)color, (int)brightness, (int)rotation, (boolean)false);
                    }
                    if (y != 0) continue;
                    from.y = from.y() + 0.001f;
                    FluidRenderer.putTexturedQuad((class_4588)builder, (Matrix4f)matrix, (class_1058)still, (Vector3f)from, (Vector3f)to, (class_2350)class_2350.field_11033, (int)color, (int)brightness, (int)rotation, (boolean)false);
                }
            }
        }
    }
}

