/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.screen.module;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiSmelteryTank;

public class GuiTankModule {
    private static final class_2561 NO_CAPACITY = class_2561.method_43469((String)Mantle.makeDescriptionId((String)"gui", (String)"fluid.millibucket"), (Object[])new Object[]{0}).method_27692(class_124.field_1080);
    private static final int TANK_INDEX = 0;
    private final class_465<?> screen;
    private final SlottedStorage<FluidVariant> tank;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final BiConsumer<Long, List<class_2561>> formatter;

    public GuiTankModule(class_465<?> screen, SlottedStorage<FluidVariant> tank, int x, int y, int width, int height, class_2960 tooltipId) {
        this.screen = screen;
        this.tank = tank;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.formatter = (amount, tooltip) -> FluidTooltipHandler.appendNamedList((class_2960)tooltipId, (long)amount, (List)tooltip);
    }

    private boolean isHovered(int checkX, int checkY) {
        return GuiUtil.isHovered(checkX, checkY, this.x - 1, this.y - 1, this.width + 2, this.height + 2);
    }

    private long getFluidHeight() {
        long capacity = this.tank.getSlot(0).getCapacity();
        if (capacity == 0L) {
            return this.height;
        }
        return (long)this.height * this.tank.getSlot(0).getAmount() / capacity;
    }

    public void draw(class_332 graphics) {
        GuiUtil.renderFluidTank(graphics.method_51448(), this.screen, new FluidStack((StorageView)this.tank.getSlot(0)), this.tank.getSlot(0).getCapacity(), this.x, this.y, this.width, this.height, 100);
    }

    public void highlightHoveredFluid(class_332 graphics, int checkX, int checkY) {
        if (this.isHovered(checkX, checkY)) {
            long fluidHeight = this.getFluidHeight();
            long middle = (long)(this.y + this.height) - fluidHeight;
            if ((long)checkY > middle) {
                GuiUtil.renderHighlight(graphics, this.x, (int)middle, this.width, (int)fluidHeight);
            } else {
                GuiUtil.renderHighlight(graphics, this.x, this.y, this.width, (int)((long)this.height - fluidHeight));
            }
        }
    }

    public void renderTooltip(class_332 graphics, int mouseX, int mouseY) {
        int checkX = mouseX - this.screen.field_2776;
        int checkY = mouseY - this.screen.field_2800;
        if (this.isHovered(checkX, checkY)) {
            List<class_2561> tooltip;
            FluidStack fluid = new FluidStack((StorageView)this.tank.getSlot(0));
            long amount = fluid.getAmount();
            long capacity = this.tank.getSlot(0).getCapacity();
            if (capacity > 0L && (long)checkY > (long)(this.y + this.height) - this.getFluidHeight()) {
                tooltip = FluidTooltipHandler.getFluidTooltip((FluidStack)fluid);
            } else {
                BiConsumer<Long, List<class_2561>> formatter = class_437.method_25442() ? FluidTooltipHandler.BUCKET_FORMATTER : this.formatter;
                tooltip = new ArrayList<class_2561>();
                tooltip.add(GuiSmelteryTank.TOOLTIP_CAPACITY);
                if (capacity == 0L) {
                    tooltip.add(NO_CAPACITY);
                } else {
                    formatter.accept(capacity, tooltip);
                    if (capacity != amount) {
                        tooltip.add(GuiSmelteryTank.TOOLTIP_AVAILABLE);
                        formatter.accept(capacity - amount, tooltip);
                    }
                    FluidTooltipHandler.appendShift(tooltip);
                }
            }
            graphics.method_51434(Screens.getTextRenderer(this.screen), tooltip, mouseX, mouseY);
        }
    }

    @Nullable
    public FluidStack getIngreientUnderMouse(int checkX, int checkY) {
        if (this.isHovered(checkX, checkY) && (long)checkY > (long)(this.y + this.height) - this.getFluidHeight()) {
            return new FluidStack((StorageView)this.tank.getSlot(0));
        }
        return null;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

