/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import io.github.fabricators_of_create.porting_lib.item.ArmorTextureItem;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableArmorItem;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public class SlimesuitItem
extends ModifiableArmorItem
implements ArmorTextureItem {
    private static final Map<String, String> ARMOR_TEXTURE_CACHE = new HashMap<String, String>();
    private static final Map<String, String> LEG_TEXTURE_CACHE = new HashMap<String, String>();
    private static final Function<String, String> ARMOR_GETTER = mat -> SlimesuitItem.makeArmorTexture(mat, "layer_1");
    private static final Function<String, String> LEG_GETTER = mat -> SlimesuitItem.makeArmorTexture(mat, "layer_2");

    public SlimesuitItem(ModifiableArmorMaterial material, ArmorSlotType slotType, class_1792.class_1793 properties, class_5321<class_1761> tab) {
        super(material, slotType, properties, tab);
    }

    public static String getMaterial(class_1799 stack) {
        if (ModifierUtil.getModifierLevel(stack, TinkerModifiers.golden.getId()) > 0) {
            return MaterialIds.gold.toString();
        }
        String key = ModifierUtil.getPersistentString(stack, TinkerModifiers.embellishment.getId());
        if (key.isEmpty()) {
            return MaterialIds.enderslime.toString();
        }
        return key;
    }

    public static String makeArmorTexture(String material, String texture) {
        class_2960 location = class_2960.method_12829((String)material);
        if (location == null) {
            location = MaterialIds.enderslime;
        }
        return String.format("%s:textures/models/armor/slime/%s_%s_%s.png", "tconstruct", texture, location.method_12836(), location.method_12832());
    }

    @Nullable
    public String getArmorTexture(class_1799 stack, class_1297 entity, class_1304 slot, String type) {
        String material = SlimesuitItem.getMaterial(stack);
        if (slot == class_1304.field_6172) {
            return LEG_TEXTURE_CACHE.computeIfAbsent(material, LEG_GETTER);
        }
        return ARMOR_TEXTURE_CACHE.computeIfAbsent(material, ARMOR_GETTER);
    }
}

