/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits;

import io.github.fabricators_of_create.porting_lib.common.util.Lazy;
import io.github.fabricators_of_create.porting_lib.entity.events.PlayerEvents;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1836;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;

public class DamageSpeedTradeModifier
extends Modifier {
    private static final class_2561 MINING_SPEED = TConstruct.makeTranslation("modifier", "fake_attribute.mining_speed");
    private final float multiplier;
    private final Lazy<UUID> uuid = Lazy.of(() -> UUID.nameUUIDFromBytes(this.getId().toString().getBytes()));
    private final Lazy<String> attributeName = Lazy.of(() -> {
        ModifierId id = this.getId();
        return id.method_12832() + "." + id.method_12836() + ".attack_damage";
    });

    public DamageSpeedTradeModifier(float multiplier) {
        this.multiplier = multiplier;
    }

    private double getMultiplier(IToolStackView tool, int level) {
        return Math.sqrt((float)(tool.getDamage() * level) / tool.getMultiplier(ToolStats.DURABILITY)) * (double)this.multiplier;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey tooltipKey, class_1836 tooltipFlag) {
        double boost = this.getMultiplier(tool, level);
        if (boost != 0.0 && tool.hasTag(TinkerTags.Items.HARVEST)) {
            tooltip.add((class_2561)this.applyStyle(class_2561.method_43470((String)Util.PERCENT_BOOST_FORMAT.format(-boost)).method_27693(" ").method_10852(MINING_SPEED)));
        }
    }

    @Override
    public void addAttributes(IToolStackView tool, int level, class_1304 slot, BiConsumer<class_1320, class_1322> consumer) {
        double boost;
        if (slot == class_1304.field_6173 && (boost = this.getMultiplier(tool, level)) != 0.0) {
            consumer.accept(class_5134.field_23721, new class_1322((UUID)this.uuid.get(), (String)this.attributeName.get(), boost / 2.0, class_1322.class_1323.field_6331));
        }
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvents.BreakSpeed event, class_2350 sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            event.setNewSpeed((float)((double)event.getNewSpeed() * (1.0 - this.getMultiplier(tool, level))));
        }
    }
}

