/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class RagingModifier
extends Modifier
implements ConditionalStatModifierHook {
    private static final float LOWEST_HEALTH = 2.0f;
    private static final float HIGHEST_HEALTH = 10.0f;
    private static final float DAMAGE_PER_LEVEL = 4.0f;
    private static final float DRAWSPEED_PER_LEVEL = 0.25f;

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, TinkerHooks.CONDITIONAL_STAT);
    }

    private static float getBonus(class_1309 attacker, int level) {
        float health = attacker.method_6032();
        float max = attacker.method_6063();
        if (max < 10.0f) {
            health += 10.0f - max;
        }
        if (health <= 2.0f) {
            return level;
        }
        if (health < 10.0f) {
            return (float)level * (10.0f - health) / 8.0f;
        }
        return 0.0f;
    }

    @Override
    public float getEntityDamage(IToolStackView tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        return damage + RagingModifier.getBonus(context.getAttacker(), level) * 4.0f * tool.getMultiplier(ToolStats.ATTACK_DAMAGE);
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, class_1309 living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.DRAW_SPEED) {
            return baseValue + RagingModifier.getBonus(living, modifier.getLevel()) * 0.25f * multiplier;
        }
        return baseValue;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey key, class_1836 flag) {
        float bonus = level;
        if (player != null && key == TooltipKey.SHIFT) {
            bonus = RagingModifier.getBonus((class_1309)player, level);
        }
        if (bonus > 0.0f) {
            this.addDamageTooltip(tool, bonus * 4.0f, tooltip);
            this.addStatTooltip(tool, ToolStats.DRAW_SPEED, TinkerTags.Items.RANGED, bonus * 0.25f, tooltip);
        }
    }
}

