/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3966;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalModifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.shared.TinkerDamageTypes;

public class PiercingModifier
extends IncrementalModifier
implements ProjectileHitModifierHook,
ProjectileLaunchModifierHook {
    private static final class_2960 PIERCING_DEBUFF = TConstruct.getResource("piercing_debuff");

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, TinkerHooks.PROJECTILE_HIT, TinkerHooks.PROJECTILE_LAUNCH);
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        float toRemove = 0.5f * this.getScaledLevel(context, level);
        float baseDamage = context.getBaseStats().get(ToolStats.ATTACK_DAMAGE).floatValue();
        if (baseDamage < toRemove) {
            volatileData.putFloat(PIERCING_DEBUFF, toRemove - baseDamage);
        }
    }

    @Override
    public void addToolStats(ToolRebuildContext context, int level, ModifierStatsBuilder builder) {
        float toRemove = 0.5f * this.getScaledLevel(context, level) - context.getVolatileData().getFloat(PIERCING_DEBUFF);
        ToolStats.ATTACK_DAMAGE.add(builder, -toRemove);
    }

    @Override
    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        class_1657 player = context.getPlayerAttacker();
        class_1282 source = player != null ? player.method_48923().method_48796(TinkerDamageTypes.PLAYER_ATTACK_BYPASS_ARMOR, (class_1297)player) : context.getAttacker().method_48923().method_48796(TinkerDamageTypes.MOB_ATTACK_BYPASS_ARMOR, (class_1297)context.getAttacker());
        float secondaryDamage = (this.getScaledLevel(tool, level) * tool.getMultiplier(ToolStats.ATTACK_DAMAGE) - tool.getVolatileData().getFloat(PIERCING_DEBUFF)) * context.getCooldown();
        if (context.isCritical()) {
            secondaryDamage *= 1.5f;
        }
        ToolAttackUtil.attackEntitySecondary(source, secondaryDamage, context.getTarget(), context.getLivingTarget(), true);
        return 0;
    }

    @Override
    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, class_1309 shooter, class_1676 projectile, @Nullable class_1665 arrow, NamespacedNBT persistentData, boolean primary) {
        persistentData.putFloat(this.getId(), modifier.getEffectiveLevel(tool));
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, class_1676 projectile, class_3966 hit, @Nullable class_1309 attacker, @Nullable class_1309 target) {
        class_1282 source;
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            source = projectile.method_48923().method_48796(TinkerDamageTypes.PLAYER_ATTACK_BYPASS_ARMOR, (class_1297)player);
        } else {
            source = attacker != null ? projectile.method_48923().method_48796(TinkerDamageTypes.MOB_ATTACK_BYPASS_ARMOR, (class_1297)attacker) : projectile.method_48923().method_48830();
        }
        ToolAttackUtil.attackEntitySecondary(source, persistentData.getFloat(this.getId()), hit.method_17782(), target, true);
        return false;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey tooltipKey, class_1836 tooltipFlag) {
        this.addDamageTooltip(tool, this.getScaledLevel(tool, level) - tool.getVolatileData().getFloat(PIERCING_DEBUFF), tooltip);
    }
}

