/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import com.google.common.collect.Lists;
import io.github.fabricators_of_create.porting_lib.config.ConfigEvents;
import io.github.fabricators_of_create.porting_lib.config.ConfigType;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.tags.Tags;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.loot.v2.LootTableSource;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.class_117;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_141;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1972;
import net.minecraft.class_2484;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3611;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_60;
import net.minecraft.class_6880;
import net.minecraft.class_77;
import net.minecraft.class_79;
import slimeknights.mantle.loot.function.SetFluidLootFunction;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.json.AddToolDataFunction;
import slimeknights.tconstruct.library.json.RandomMaterial;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerWorld;

public class WorldEvents {
    public static void init() {
        LootTableEvents.MODIFY.register(WorldEvents::onLootTableLoad);
        LivingEntityEvents.LivingVisibilityEvent.VISIBILITY.register(WorldEvents::livingVisibility);
        LivingEntityEvents.DROPS.register(WorldEvents::creeperKill);
        ConfigEvents.LOADING.register(config -> {
            if (config.getModId().equals("tconstruct") && config.getType() == ConfigType.COMMON) {
                WorldEvents.onBiomeLoad();
            }
        });
    }

    static void onBiomeLoad() {
        if (((Boolean)Config.COMMON.generateCobalt.get()).booleanValue()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInTheNether(), (class_2893.class_2895)class_2893.class_2895.field_13177, TinkerWorld.placedSmallCobaltOreKey);
            BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInTheNether(), (class_2893.class_2895)class_2893.class_2895.field_13177, TinkerWorld.placedLargeCobaltOreKey);
        }
        if (((Boolean)Config.COMMON.ichorGeodes.get()).booleanValue()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInTheNether(), (class_2893.class_2895)class_2893.class_2895.field_13171, TinkerWorld.placedIchorGeodeKey);
        }
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.foundInTheEnd(), (class_1311)class_1311.field_6302, (class_1299)((class_1299)TinkerWorld.enderSlimeEntity.get()), (int)10, (int)2, (int)4);
        if (((Boolean)Config.COMMON.enderGeodes.get()).booleanValue()) {
            BiomeModifications.addFeature(context -> context.canGenerateIn(class_5363.field_25414) && context.getBiomeKey() != class_1972.field_9411, (class_2893.class_2895)class_2893.class_2895.field_13171, TinkerWorld.placedEnderGeodeKey);
        }
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.foundInOverworld(), (class_1311)class_1311.field_6302, (class_1299)((class_1299)TinkerWorld.earthSlimeEntity.get()), (int)100, (int)2, (int)4);
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.foundInOverworld(), (class_1311)class_1311.field_6302, (class_1299)((class_1299)TinkerWorld.skySlimeEntity.get()), (int)100, (int)2, (int)4);
        if (((Boolean)Config.COMMON.earthGeodes.get()).booleanValue()) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInOverworld(), (class_2893.class_2895)class_2893.class_2895.field_13171, TinkerWorld.placedEarthGeodeKey);
        }
        if (((Boolean)Config.COMMON.skyGeodes.get()).booleanValue()) {
            Predicate<BiomeSelectionContext> context2 = biomeSelectionContext -> {
                boolean hasNoTypes;
                if (!biomeSelectionContext.canGenerateIn(class_5363.field_25412)) {
                    return false;
                }
                class_6880 biomeHolder = biomeSelectionContext.getBiomeRegistryEntry();
                class_5321 key = biomeSelectionContext.getBiomeKey();
                boolean bl = hasNoTypes = key == null;
                boolean add = hasNoTypes ? !biomeHolder.method_40220(ConventionalBiomeTags.OCEAN) && !biomeHolder.method_40220(ConventionalBiomeTags.BEACH) && !biomeHolder.method_40220(ConventionalBiomeTags.RIVER) : !biomeHolder.method_40220(Tags.Biomes.IS_WATER) && !biomeHolder.method_40220(ConventionalBiomeTags.BEACH);
                return add;
            };
            BiomeModifications.addFeature(context2, (class_2893.class_2895)class_2893.class_2895.field_13171, TinkerWorld.placedSkyGeodeKey);
        }
    }

    private static void injectInto(class_52 lootTable, String poolName, class_79 ... entries) {
        class_55 pool = WorldEvents.getPool(lootTable, poolName);
        if (pool != null) {
            int oldLength = pool.field_953.length;
            pool.field_953 = Arrays.copyOf(pool.field_953, oldLength + entries.length);
            System.arraycopy(entries, 0, pool.field_953, oldLength, entries.length);
        }
    }

    public static class_55 getPool(class_52 table, String name) {
        return Lists.newArrayList((Object[])table.field_943).stream().filter(e -> name.equals(e.getName())).findFirst().orElse(null);
    }

    private static class_79 makeSeed(SlimeType type, int weight) {
        return class_77.method_411((class_1935)((class_1935)TinkerWorld.slimeGrassSeeds.get((Enum)type))).method_437(weight).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)2.0f, (float)4.0f))).method_419();
    }

    private static class_79 makeSapling(SlimeType type, int weight) {
        return class_77.method_411((class_1935)((class_1935)TinkerWorld.slimeSapling.get((Enum)type))).method_437(weight).method_419();
    }

    static void onLootTableLoad(class_3300 resourceManager, class_60 manager, class_2960 name, class_52.class_53 tableBuilder, LootTableSource source) {
        if ("minecraft".equals(name.method_12836())) {
            switch (name.method_12832()) {
                case "chests/simple_dungeon": {
                    if (!((Boolean)Config.COMMON.slimyLootChests.get()).booleanValue()) break;
                    WorldEvents.injectInto(manager.getLootTable(name), "pool1", WorldEvents.makeSeed(SlimeType.EARTH, 3), WorldEvents.makeSeed(SlimeType.SKY, 7));
                    WorldEvents.injectInto(manager.getLootTable(name), "main", WorldEvents.makeSapling(SlimeType.EARTH, 3), WorldEvents.makeSapling(SlimeType.SKY, 7));
                    break;
                }
                case "chests/nether_bridge": {
                    if (!((Boolean)Config.COMMON.slimyLootChests.get()).booleanValue()) break;
                    WorldEvents.injectInto(manager.getLootTable(name), "main", WorldEvents.makeSeed(SlimeType.BLOOD, 5));
                    break;
                }
                case "chests/bastion_bridge": {
                    if (!((Boolean)Config.COMMON.slimyLootChests.get()).booleanValue()) break;
                    WorldEvents.injectInto(manager.getLootTable(name), "pool2", WorldEvents.makeSapling(SlimeType.BLOOD, 1));
                    break;
                }
                case "chests/end_city_treasure": {
                    if (!((Boolean)Config.COMMON.slimyLootChests.get()).booleanValue()) break;
                    WorldEvents.injectInto(manager.getLootTable(name), "main", WorldEvents.makeSeed(SlimeType.ENDER, 5), WorldEvents.makeSapling(SlimeType.ENDER, 3));
                    break;
                }
                case "gameplay/piglin_bartering": {
                    int weight = (Integer)Config.COMMON.barterBlazingBlood.get();
                    if (weight <= 0) break;
                    WorldEvents.injectInto(manager.getLootTable(name), "main", class_77.method_411(TinkerSmeltery.scorchedLantern).method_437(weight).method_438((class_117.class_118)SetFluidLootFunction.builder((FluidStack)new FluidStack((class_3611)TinkerFluids.blazingBlood.get(), 4050L))).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)4.0f))).method_419());
                    break;
                }
                case "chests/spawn_bonus_chest": {
                    int weight = (Integer)Config.COMMON.tinkerToolBonusChest.get();
                    if (weight <= 0) break;
                    RandomMaterial randomHead = RandomMaterial.random(HeadMaterialStats.ID).tier(1).build();
                    RandomMaterial firstHandle = RandomMaterial.firstWithStat(HandleMaterialStats.ID);
                    RandomMaterial randomBinding = RandomMaterial.random(ExtraMaterialStats.ID).tier(1).build();
                    WorldEvents.injectInto(manager.getLootTable(name), "main", class_77.method_411((class_1935)TinkerTools.handAxe.get()).method_437(weight).method_438((class_117.class_118)AddToolDataFunction.builder().addMaterial(randomHead).addMaterial(firstHandle).addMaterial(randomBinding)).method_419());
                    WorldEvents.injectInto(manager.getLootTable(name), "pool1", class_77.method_411((class_1935)TinkerTools.pickaxe.get()).method_437(weight).method_438((class_117.class_118)AddToolDataFunction.builder().addMaterial(randomHead).addMaterial(firstHandle).addMaterial(randomBinding)).method_419());
                    break;
                }
            }
        }
    }

    static void livingVisibility(LivingEntityEvents.LivingVisibilityEvent event) {
        class_1297 lookingEntity = event.getLookingEntity();
        if (lookingEntity == null) {
            return;
        }
        class_1309 entity = event.getEntity();
        class_1799 helmet = entity.method_6118(class_1304.field_6169);
        class_1792 item = helmet.method_7909();
        if (item != class_1802.field_8162 && TinkerWorld.headItems.contains((Object)item) && lookingEntity.method_5864() == ((TinkerHeadType)((class_2484)((class_1747)item).method_7711()).method_9327()).getType()) {
            event.modifyVisibility(0.5);
        }
    }

    static boolean creeperKill(class_1309 target, class_1282 source, Collection<class_1542> drops, int lootingLevel, boolean recentlyHit) {
        class_1309 dying;
        TinkerHeadType headType;
        class_1548 creeper;
        class_1297 entity;
        if (source != null && (entity = source.method_5529()) instanceof class_1548 && (creeper = (class_1548)entity).method_7008() && (headType = TinkerHeadType.fromEntityType((dying = target).method_5864())) != null && ((Boolean)Config.COMMON.headDrops.get((Object)headType).get()).booleanValue()) {
            creeper.method_7002();
            drops.add(dying.method_5706((class_1935)TinkerWorld.heads.get((Enum)headType)));
        }
        return false;
    }
}

