/*
 * Decompiled with CFR 0.152.
 */
package net.mcs3.basicnetherores.data;

import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.mcs3.basicnetherores.Constants;
import net.mcs3.basicnetherores.data.loottables.LootTableGenerator;
import net.mcs3.basicnetherores.data.models.BlockStateGenerator;
import net.mcs3.basicnetherores.data.recipes.CraftingRecipeBuilder;
import net.mcs3.basicnetherores.data.tags.FabricBlockTagGenerator;
import net.mcs3.basicnetherores.data.tags.FabricItemTagGenerator;
import net.mcs3.basicnetherores.data.tags.VanillaBlockTagGenerator;
import net.mcs3.basicnetherores.data.tags.VanillaItemTagGenerator;
import net.mcs3.basicnetherores.data.worldgen.FabricWorldDataGenerator;
import net.mcs3.basicnetherores.init.BNOConfiguredFeatures;
import net.mcs3.basicnetherores.init.BNOPlacedFeatures;
import net.minecraft.class_7784;
import net.minecraft.class_7877;
import net.minecraft.class_7924;

public class FabricDataGenerators
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator generator) {
        if (System.getProperty("bno.common_datagen") != null) {
            FabricDataGenerators.configureCommonDatagen(generator.createPack());
        } else {
            FabricDataGenerators.configureFabricDatagen(generator.createPack());
        }
    }

    public void buildRegistry(class_7877 registryBuilder) {
        if (System.getProperty("bno.common_datagen") == null) {
            registryBuilder.method_46777(class_7924.field_41239, BNOConfiguredFeatures::bootstrap);
            registryBuilder.method_46777(class_7924.field_41245, BNOPlacedFeatures::bootstrap);
        }
        super.buildRegistry(registryBuilder);
    }

    private static void configureFabricDatagen(FabricDataGenerator.Pack pack) {
        Constants.LOGGER.info("Fabric Data Gen");
        FabricBlockTagGenerator blockTagGenerator = (FabricBlockTagGenerator)pack.addProvider(FabricBlockTagGenerator::new);
        pack.addProvider((output, registriesFuture) -> new FabricItemTagGenerator((class_7784)output, registriesFuture, blockTagGenerator.method_49662()));
        pack.addProvider(FabricWorldDataGenerator::new);
    }

    private static void configureCommonDatagen(FabricDataGenerator.Pack pack) {
        Constants.LOGGER.info("Common Data Gen");
        VanillaBlockTagGenerator blockTagProvider = (VanillaBlockTagGenerator)pack.addProvider(VanillaBlockTagGenerator::new);
        pack.addProvider((output, registriesFuture) -> new VanillaItemTagGenerator((class_7784)output, registriesFuture, blockTagProvider.method_49662()));
        pack.addProvider(BlockStateGenerator::new);
        pack.addProvider(LootTableGenerator::new);
        pack.addProvider(CraftingRecipeBuilder::new);
    }
}

