/*
 * Decompiled with CFR 0.152.
 */
package net.mcs3.basicnetherores.platform;

import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.mcs3.basicnetherores.Constants;
import net.mcs3.basicnetherores.platform.services.IPlatformHelper;

public class Services {
    public static final IPlatformHelper PLATFORM = Services.loadService(IPlatformHelper.class, null);

    public static <T> T loadService(Class<T> clazz, @Nullable Supplier<T> defaultImpl) {
        List<ServiceLoader.Provider<T>> providers = ServiceLoader.load(clazz).stream().toList();
        if (providers.isEmpty() && defaultImpl != null) {
            return defaultImpl.get();
        }
        if (providers.size() != 1) {
            String names = providers.stream().map(p -> p.type().getName()).collect(Collectors.joining(",", "[", "]"));
            String msg = "There should be exactly one implementation of %s on the classpath. Found: %s".formatted(clazz.getName(), names);
            throw new IllegalStateException(msg);
        }
        ServiceLoader.Provider<T> provider = providers.get(0);
        Constants.LOGGER.debug("Instantiating {} for service {}", (Object)provider.type().getName(), (Object)clazz.getName());
        return provider.get();
    }
}

