/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.compat;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.api.event.HeartRenderEvent;

public class OverflowingBarsCommonCompat {
    protected Supplier<Boolean> allowCount;
    protected Method drawBarRowCount;
    private boolean firstRun = true;

    public OverflowingBarsCommonCompat() {
        try {
            Class<?> clazz = Class.forName("fuzs.overflowingbars.client.handler.RowCountRenderer");
            this.drawBarRowCount = clazz.getMethod("drawBarRowCount", class_332.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, class_327.class);
        }
        catch (ClassNotFoundException e) {
            CColorfulHearts.LOGGER.error("Could not initialize OverflowingBarsCompat as class RowCountRenderer has been moved. PLEASE REPORT TO COLORFUL HEARTS GITHUB!!!", (Throwable)e);
            return;
        }
        catch (NoSuchMethodException e) {
            CColorfulHearts.LOGGER.error("Could not initialize OverflowingBarsCompat as field RowCountRenderer#drawBarRowCount has been moved. PLEASE REPORT TO COLORFUL HEARTS GITHUB!!!", (Throwable)e);
            return;
        }
    }

    public void render(HeartRenderEvent.Post event) {
        if (this.firstRun) {
            this.initializeConfigReflection();
            this.firstRun = false;
        }
        if (this.allowCount == null) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && this.allowCount.get().booleanValue()) {
            int health = class_3532.method_15386((float)player.method_6032());
            this.drawBarRowCount(event.getGuiGraphics(), event.getX() - 2, event.getY(), health, 20);
            int maxAbsorption = (20 - class_3532.method_15386((float)((float)Math.min(20, health) / 2.0f))) * 2;
            this.drawBarRowCount(event.getGuiGraphics(), event.getX() - 2, event.getY() - 10, class_3532.method_15386((float)player.method_6067()), maxAbsorption);
        }
    }

    private void drawBarRowCount(class_332 guiGraphics, int posX, int posY, int barValue, int maxRowCount) {
        try {
            this.drawBarRowCount.invoke(null, guiGraphics, posX, posY, barValue, true, maxRowCount, class_310.method_1551().field_1772);
        }
        catch (IllegalAccessException e) {
            CColorfulHearts.LOGGER.error("Failed to access method RowCountRenderer#drawBarRowCount. Heart row counter will not behave as expected. PLEASE REPORT TO COLORFUL HEARTS GITHUB!!!", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            CColorfulHearts.LOGGER.error("Failed to invoke method RowCountRenderer#drawBarRowCount. Heart row counter will not behave as expected. PLEASE REPORT TO COLORFUL HEARTS GITHUB!!!", (Throwable)e);
        }
    }

    public void initializeConfigReflection() {
        Field field;
        Class<?> iconRowConfigClass;
        Object healthConfigInstance;
        Object configInstance;
        Class<?> clientConfigClass;
        Object configHolderInstance;
        try {
            Class<?> clazz = Class.forName("fuzs.overflowingbars.OverflowingBars");
            Field field2 = clazz.getField("CONFIG");
            configHolderInstance = field2.get(null);
        }
        catch (ClassNotFoundException e) {
            CColorfulHearts.LOGGER.error("Could not initialize OverflowingBarsCompat as class BarOverlayRenderer has been moved. PLEASE REPORT TO COLORFUL HEARTS GITHUB!!!", (Throwable)e);
            return;
        }
        catch (NoSuchFieldException e) {
            CColorfulHearts.LOGGER.error("Could not initialize OverflowingBarsCompat as field BarOverlayRenderer.CONFIG has been moved. PLEASE REPORT TO COLORFUL HEARTS GITHUB!!!", (Throwable)e);
            return;
        }
        catch (IllegalAccessException e) {
            CColorfulHearts.LOGGER.error("Could not initialize OverflowingBarsCompat as field BarOverlayRenderer.CONFIG could not be accessed. PLEASE REPORT TO COLORFUL HEARTS GITHUB!!!", (Throwable)e);
            return;
        }
        try {
            clientConfigClass = Class.forName("fuzs.overflowingbars.config.ClientConfig");
        }
        catch (ClassNotFoundException e) {
            CColorfulHearts.LOGGER.error("Could not initialize OverflowingBarsCompat as class ClientConfig has been moved. PLEASE REPORT TO COLORFUL HEARTS GITHUB!!!", (Throwable)e);
            return;
        }
        try {
            Class<?> clazz = Class.forName("fuzs.puzzleslib.api.config.v3.ConfigHolder");
            Method method = clazz.getMethod("get", Class.class);
            configInstance = method.invoke(configHolderInstance, clientConfigClass);
        }
        catch (ClassNotFoundException e) {
            CColorfulHearts.LOGGER.error("Could not initialize OverflowingBarsCompat as class BarOverlayRenderer has been moved. PLEASE REPORT TO COLORFUL HEARTS GITHUB!!!", (Throwable)e);
            return;
        }
        catch (NoSuchMethodException e) {
            CColorfulHearts.LOGGER.error("Could not initialize OverflowingBarsCompat as method BarOverlayRenderer#get has been moved. PLEASE REPORT TO COLORFUL HEARTS GITHUB!!!", (Throwable)e);
            return;
        }
        catch (IllegalAccessException e) {
            CColorfulHearts.LOGGER.error("Could not initialize OverflowingBarsCompat as method BarOverlayRenderer#get could not be accessed. PLEASE REPORT TO COLORFUL HEARTS GITHUB!!!", (Throwable)e);
            return;
        }
        catch (InvocationTargetException e) {
            CColorfulHearts.LOGGER.error("Could not initialize OverflowingBarsCompat as method BarOverlayRenderer#get could not be invoked. PLEASE REPORT TO COLORFUL HEARTS GITHUB!!!", (Throwable)e);
            return;
        }
        try {
            Field field3 = clientConfigClass.getField("health");
            healthConfigInstance = field3.get(configInstance);
        }
        catch (NoSuchFieldException e) {
            CColorfulHearts.LOGGER.error("Could not initialize OverflowingBarsCompat as field ClientConfig.health has been moved. PLEASE REPORT TO COLORFUL HEARTS GITHUB!!!", (Throwable)e);
            return;
        }
        catch (IllegalAccessException e) {
            CColorfulHearts.LOGGER.error("Could not initialize OverflowingBarsCompat as field ClientConfig.health could not be accessed. PLEASE REPORT TO COLORFUL HEARTS GITHUB!!!", (Throwable)e);
            return;
        }
        try {
            iconRowConfigClass = Class.forName("fuzs.overflowingbars.config.ClientConfig$IconRowConfig");
        }
        catch (ClassNotFoundException e) {
            CColorfulHearts.LOGGER.error("Could not initialize OverflowingBarsCompat as class ClientConfig$IconRowConfig has been moved. PLEASE REPORT TO COLORFUL HEARTS GITHUB!!!", (Throwable)e);
            return;
        }
        try {
            field = iconRowConfigClass.getField("allowLayers");
            if (field.getBoolean(healthConfigInstance)) {
                CColorfulHearts.LOGGER.warn("Overflowing Bars allowLayers config option is enabled and could possibly conflict with Colorful Hearts by forcing its own heart rendering");
            }
        }
        catch (NoSuchFieldException e) {
            CColorfulHearts.LOGGER.error("Could not initialize OverflowingBarsCompat as field ClientConfig$IconRowConfig.allowLayers has been moved. PLEASE REPORT TO COLORFUL HEARTS GITHUB!!!", (Throwable)e);
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            CColorfulHearts.LOGGER.error("Failed to fetch ClientConfig$IconRowConfig.allowLayers config value. Heart row counter will be disabled. PLEASE REPORT TO COLORFUL HEARTS GITHUB!!!", (Throwable)e);
            return;
        }
        try {
            field = iconRowConfigClass.getField("allowCount");
            this.allowCount = () -> {
                try {
                    return field.getBoolean(healthConfigInstance);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    CColorfulHearts.LOGGER.error("Failed to fetch ClientConfig$IconRowConfig.allowCount config value. Heart row counter will be disabled. PLEASE REPORT TO COLORFUL HEARTS GITHUB!!!", (Throwable)e);
                    return false;
                }
            };
        }
        catch (NoSuchFieldException e) {
            CColorfulHearts.LOGGER.error("Could not initialize OverflowingBarsCompat as field ClientConfig$IconRowConfig.allowCount has been moved. PLEASE REPORT TO COLORFUL HEARTS GITHUB!!!", (Throwable)e);
            return;
        }
    }
}

