/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.config;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_332;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.api.event.HeartRegistry;
import terrails.colorfulhearts.api.heart.Hearts;
import terrails.colorfulhearts.api.heart.drawing.HeartDrawing;
import terrails.colorfulhearts.api.heart.drawing.OverlayHeart;
import terrails.colorfulhearts.config.Configuration;
import terrails.colorfulhearts.render.RenderUtils;

public class ConfigUtils {
    public static void loadColoredHearts() {
        class_2960 id;
        Integer color;
        ArrayList<HeartDrawing> hearts = new ArrayList<HeartDrawing>();
        if (Configuration.HEALTH.vanillaHearts.get().booleanValue()) {
            hearts.add(new HeartDrawing(){
                private static final class_2960 ID = new class_2960("vanilla");

                @Override
                public void draw(class_332 guiGraphics, int x, int y, boolean half, boolean hardcore, boolean highlight) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)CColorfulHearts.GUI_ICONS_LOCATION);
                    int texX = class_329.class_6411.field_33945.method_37302(half, highlight);
                    RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, hardcore ? 45 : 0);
                }

                @Override
                public class_2960 getId() {
                    return ID;
                }
            });
        }
        Iterator colors = Configuration.HEALTH.colors.get().stream().map(s -> Integer.decode(s) & 0xFFFFFF).iterator();
        while (colors.hasNext()) {
            color = (Integer)colors.next();
            id = new class_2960("colorfulhearts", "health_" + color);
            hearts.add(new HeartDrawing(){

                @Override
                public void draw(class_332 guiGraphics, int x, int y, boolean half, boolean hardcore, boolean highlight) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)CColorfulHearts.HEALTH_ICONS_LOCATION);
                    RenderSystem.enableBlend();
                    int texX = 0;
                    if (half) {
                        texX += 9;
                    }
                    int texY = hardcore ? 36 : 0;
                    RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, texY, color, 255);
                    RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, texY += 9, 255);
                    RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, texY += 9, 255);
                    if (highlight) {
                        RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, texY -= 18, 127);
                    }
                    RenderSystem.disableBlend();
                    RenderSystem.setShaderTexture((int)0, (class_2960)CColorfulHearts.GUI_ICONS_LOCATION);
                }

                @Override
                public class_2960 getId() {
                    return id;
                }
            });
        }
        Hearts.COLORED_HEALTH_HEARTS = List.copyOf(hearts);
        hearts = new ArrayList();
        if (Configuration.ABSORPTION.vanillaHearts.get().booleanValue()) {
            hearts.add(new HeartDrawing(){
                private static final class_2960 ID = new class_2960("absorbing");

                @Override
                public void draw(class_332 guiGraphics, int x, int y, boolean half, boolean hardcore, boolean highlight) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)CColorfulHearts.GUI_ICONS_LOCATION);
                    int texX = class_329.class_6411.field_33948.method_37302(half, highlight);
                    RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, hardcore ? 45 : 0);
                }

                @Override
                public class_2960 getId() {
                    return ID;
                }
            });
        }
        colors = Configuration.ABSORPTION.colors.get().stream().map(s -> Integer.decode(s) & 0xFFFFFF).iterator();
        while (colors.hasNext()) {
            color = (Integer)colors.next();
            id = new class_2960("colorfulhearts", "absorbing_" + color);
            hearts.add(new HeartDrawing(){

                @Override
                public void draw(class_332 guiGraphics, int x, int y, boolean half, boolean hardcore, boolean highlight) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)CColorfulHearts.ABSORPTION_ICONS_LOCATION);
                    RenderSystem.enableBlend();
                    int texX = 0;
                    if (half) {
                        texX += 9;
                    }
                    int texY = hardcore ? 36 : 0;
                    RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, texY, color, 255);
                    RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, texY += 9, 255);
                    RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, texY += 9, 255);
                    if (highlight) {
                        RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, texY -= 18, 127);
                    }
                    RenderSystem.disableBlend();
                    RenderSystem.setShaderTexture((int)0, (class_2960)CColorfulHearts.GUI_ICONS_LOCATION);
                }

                @Override
                public class_2960 getId() {
                    return id;
                }
            });
        }
        Hearts.COLORED_ABSORPTION_HEARTS = List.copyOf(hearts);
    }

    public static void loadStatusEffectHearts() {
        HeartRegistry registry = new HeartRegistry();
        registry.registerOverlayHeart(ConfigUtils.buildEffectHeart(Configuration.HEALTH.poisonedColors.get(), Configuration.ABSORPTION.poisonedColors.get(), class_329.class_6411.field_33946));
        registry.registerOverlayHeart(ConfigUtils.buildEffectHeart(Configuration.HEALTH.witheredColors.get(), Configuration.ABSORPTION.witheredColors.get(), class_329.class_6411.field_33947));
        registry.registerOverlayHeart(ConfigUtils.buildEffectHeart(Configuration.HEALTH.frozenColors.get(), Configuration.ABSORPTION.frozenColors.get(), class_329.class_6411.field_33949));
        CColorfulHearts.PROXY.heartRegistryEvent(registry);
    }

    private static OverlayHeart buildEffectHeart(List<String> healthColors, List<String> absorptionColors, final class_329.class_6411 type) {
        class_2960 id;
        Integer color;
        Predicate<class_1657> predicate;
        String effectName;
        ArrayList<HeartDrawing> drawings = new ArrayList<HeartDrawing>();
        final int textureX = switch (type) {
            case class_329.class_6411.field_33946 -> {
                effectName = "poison";
                predicate = player -> player.method_6059(class_1294.field_5899);
                yield 18;
            }
            case class_329.class_6411.field_33947 -> {
                effectName = "wither";
                predicate = player -> player.method_6059(class_1294.field_5920);
                yield 36;
            }
            case class_329.class_6411.field_33949 -> {
                effectName = "frozen";
                predicate = class_1297::method_32314;
                yield 54;
            }
            default -> throw new IllegalArgumentException("Tried to build a StatusEffectHeart for invalid type: " + String.valueOf(type));
        };
        Iterator colors = healthColors.stream().map(s -> Integer.decode(s) & 0xFFFFFF).iterator();
        while (colors.hasNext()) {
            color = (Integer)colors.next();
            id = new class_2960("colorfulhearts", effectName + "_" + color);
            drawings.add(new HeartDrawing(){

                @Override
                public void draw(class_332 guiGraphics, int x, int y, boolean half, boolean hardcore, boolean highlight) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)CColorfulHearts.HEALTH_ICONS_LOCATION);
                    int texX = textureX;
                    if (half) {
                        texX += 9;
                    }
                    int texY = hardcore ? 36 : 0;
                    RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, texY, color, 255);
                    RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, texY += 9, 255);
                    RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, texY += 9, 255);
                    if (highlight) {
                        RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, texY -= 18, 127);
                    }
                    RenderSystem.setShaderTexture((int)0, (class_2960)CColorfulHearts.GUI_ICONS_LOCATION);
                }

                @Override
                public class_2960 getId() {
                    return id;
                }
            });
        }
        if (drawings.size() == 1) {
            final class_2960 id2 = new class_2960("colorfulhearts", effectName + "_vanilla");
            drawings.add(0, new HeartDrawing(){

                @Override
                public void draw(class_332 guiGraphics, int x, int y, boolean half, boolean hardcore, boolean highlight) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)CColorfulHearts.GUI_ICONS_LOCATION);
                    int texX = type.method_37302(half, highlight);
                    RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, hardcore ? 45 : 0);
                }

                @Override
                public class_2960 getId() {
                    return id2;
                }
            });
        }
        colors = absorptionColors.stream().map(s -> Integer.decode(s) & 0xFFFFFF).iterator();
        while (colors.hasNext()) {
            color = (Integer)colors.next();
            id = new class_2960("colorfulhearts", effectName + "_absorbing_" + color);
            drawings.add(new HeartDrawing(){

                @Override
                public void draw(class_332 guiGraphics, int x, int y, boolean half, boolean hardcore, boolean highlight) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)CColorfulHearts.ABSORPTION_ICONS_LOCATION);
                    int texX = textureX;
                    if (half) {
                        texX += 9;
                    }
                    int texY = hardcore ? 36 : 0;
                    RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, texY, color, 255);
                    RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, texY += 9, 255);
                    RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, texY += 9, 255);
                    if (highlight) {
                        RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, texY -= 18, 127);
                    }
                    RenderSystem.setShaderTexture((int)0, (class_2960)CColorfulHearts.GUI_ICONS_LOCATION);
                }

                @Override
                public class_2960 getId() {
                    return id;
                }
            });
        }
        return OverlayHeart.build(new class_2960(effectName), predicate).addHealth((HeartDrawing)drawings.get(0), (HeartDrawing)drawings.get(1)).addAbsorption((HeartDrawing)drawings.get(2), (HeartDrawing)drawings.get(3)).finish();
    }
}

