/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.config.screen.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.config.screen.HeartType;
import terrails.colorfulhearts.render.RenderUtils;

public class HeartColorEditBox
extends class_342 {
    private static final Pattern HEX_FORMAT = Pattern.compile("^#[0-9a-fA-F]{0,6}$");
    private static final Pattern HEX_MATCH = Pattern.compile("^#[0-9a-fA-F]{6}$");
    private boolean invalidHex = true;
    private final HeartType type;

    public HeartColorEditBox(class_327 font, int x, int y, int width, int height, HeartType type) {
        this(font, x, y, width, height, null, type);
    }

    public HeartColorEditBox(class_327 font, int x, int y, int width, int height, @Nullable class_342 editBox, HeartType type) {
        super(font, x, y, width, height, editBox, (class_2561)class_2561.method_43473());
        this.type = type;
        this.method_1863(str -> {});
        this.method_1890(str -> HEX_FORMAT.matcher((CharSequence)str).matches());
        this.method_1880(7);
        if (editBox != null) {
            this.method_1852(editBox.method_1882());
        }
    }

    public boolean isInvalidHex() {
        return this.invalidHex;
    }

    public int getColor() {
        return Integer.decode(this.method_1882()) & 0xFFFFFF;
    }

    public void method_1863(@NotNull Consumer<String> responder) {
        super.method_1863(str -> {
            this.invalidHex = !HEX_MATCH.matcher((CharSequence)str).matches();
            responder.accept((String)str);
        });
    }

    public void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        if (!this.method_1885()) {
            return;
        }
        if (this.isInvalidHex()) {
            boolean isBordered;
            boolean bl = isBordered = this.method_1859() < this.field_22758;
            if (isBordered) {
                int borderColor = this.method_25370() ? -2743526 : -10942713;
                guiGraphics.method_25294(this.method_46426() - 1, this.method_46427() - 1, this.method_46426() + this.field_22758 + 1, this.method_46427(), borderColor);
                guiGraphics.method_25294(this.method_46426() - 1, this.method_46427() + this.field_22759, this.method_46426() + this.field_22758 + 1, this.method_46427() + this.field_22759 + 1, borderColor);
                guiGraphics.method_25294(this.method_46426() - 1, this.method_46427(), this.method_46426(), this.method_46427() + this.field_22759, borderColor);
                guiGraphics.method_25294(this.method_46426() + this.field_22758, this.method_46427(), this.method_46426() + this.field_22758 + 1, this.method_46427() + this.field_22759, borderColor);
            }
        } else {
            int x = this.method_46426() + this.field_22758 - 11;
            int y = this.method_46427() + this.field_22759 / 2 - 4;
            RenderSystem.setShaderTexture((int)0, (class_2960)(this.type.isHealthType() ? CColorfulHearts.HEALTH_ICONS_LOCATION : CColorfulHearts.ABSORPTION_ICONS_LOCATION));
            int texX = 0;
            switch (this.type) {
                case HEALTH_POISONED: 
                case ABSORBING_POISONED: {
                    texX += 18;
                    break;
                }
                case HEALTH_WITHERED: 
                case ABSORBING_WITHERED: {
                    texX += 36;
                    break;
                }
                case HEALTH_FROZEN: 
                case ABSORBING_FROZEN: {
                    texX += 54;
                }
            }
            int texY = 0;
            RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, texY, this.getColor(), 255);
            RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, texY += 9, 255);
            RenderUtils.drawTexture(guiGraphics.method_51448(), x, y, texX, texY += 9, 255);
        }
    }
}

