/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.fabric;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ObjectShare;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.fabric.PlatformProxyImpl;
import terrails.colorfulhearts.fabric.config.FabConfig;

public class ColorfulHearts
implements ClientModInitializer {
    public static FabConfig CONFIG;
    private static final Map<String, String> COMPAT;

    public void onInitializeClient() {
        CColorfulHearts.setupCommon(new PlatformProxyImpl());
        CONFIG = new FabConfig();
        ColorfulHearts.setupObjectShare();
        ColorfulHearts.setupCompat();
    }

    private static void setupObjectShare() {
        ObjectShare objectShare = FabricLoader.getInstance().getObjectShare();
        objectShare.putIfAbsent("colorfulhearts:absorption_over_health", (Object)false);
        objectShare.putIfAbsent("colorfulhearts:force_hardcore_hearts", (Object)false);
    }

    private static void setupCompat() {
        String basePackage = "terrails.colorfulhearts.fabric.compat";
        for (Map.Entry<String, String> entry : COMPAT.entrySet()) {
            String id = entry.getKey();
            if (FabricLoader.getInstance().isModLoaded(id)) {
                String className = "terrails.colorfulhearts.fabric.compat." + entry.getValue();
                CColorfulHearts.LOGGER.info("Loading compat for mod {}", (Object)id);
                try {
                    Class<?> compatClass = Class.forName(className);
                    compatClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException e) {
                    CColorfulHearts.LOGGER.error("Failed to load compat as {} does not exist", (Object)className, (Object)e);
                }
                catch (NoSuchMethodException e) {
                    CColorfulHearts.LOGGER.error("Failed to load compat as {} does not have a valid constructor", (Object)className, (Object)e);
                }
                catch (IllegalAccessException e) {
                    CColorfulHearts.LOGGER.error("Failed to load compat as {} does not have a valid public constructor", (Object)className, (Object)e);
                }
                catch (InstantiationException e) {
                    CColorfulHearts.LOGGER.error("Failed to load compat as {} is an abstract class", (Object)className, (Object)e);
                }
                catch (InvocationTargetException e) {
                    CColorfulHearts.LOGGER.error("Failed to load compat {} as an unknown error was thrown", (Object)className, (Object)e);
                }
                continue;
            }
            CColorfulHearts.LOGGER.debug("Skipped loading compat for missing mod {}", (Object)id);
        }
    }

    static {
        COMPAT = Map.of("overflowingbars", "OverflowingBarsCompat");
    }
}

