/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.fabric;

import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class FabMixinPlugin
implements IMixinConfigPlugin {
    private static final Pattern MOD_ID_PATTERN = Pattern.compile("^terrails\\.colorfulhearts\\.fabric\\.mixin\\.compat\\.([a-z0-9_-]+)\\.([a-zA-Z]+)$");

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        Matcher matcher = MOD_ID_PATTERN.matcher(mixinClassName);
        if (matcher.matches()) {
            String modid = matcher.group(1);
            String className = matcher.group(2);
            if (FabricLoader.getInstance().isModLoaded(modid)) {
                LogManager.getLogger((String)"Colorful Hearts").info("Applying mixin {} as mod {} is present.", (Object)className, (Object)modid);
                return true;
            }
            LogManager.getLogger((String)"Colorful Hearts").info("Skipped applying mixin {} as mod {} is not present.", (Object)className, (Object)modid);
            return false;
        }
        return true;
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

