/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.fabric;

import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_332;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.PlatformProxy;
import terrails.colorfulhearts.api.event.HeartRegistry;
import terrails.colorfulhearts.api.event.HeartRenderEvent;
import terrails.colorfulhearts.api.fabric.ColorfulHeartsApi;
import terrails.colorfulhearts.api.fabric.event.FabHeartEvents;
import terrails.colorfulhearts.api.heart.drawing.OverlayHeart;
import terrails.colorfulhearts.fabric.ColorfulHearts;

public class PlatformProxyImpl
implements PlatformProxy {
    @Override
    public String getLoader() {
        return "fabric";
    }

    @Override
    public void applyConfig() {
        ColorfulHearts.CONFIG.save();
    }

    @Override
    public boolean forcedHardcoreHearts() {
        Object object = FabricLoader.getInstance().getObjectShare().get("colorfulhearts:force_hardcore_hearts");
        if (object instanceof Boolean) {
            Boolean forced = (Boolean)object;
            return forced;
        }
        return false;
    }

    @Override
    public HeartRenderEvent.Pre preRenderEvent(class_332 guiGraphics, int x, int y, boolean blinking, boolean hardcore, OverlayHeart overlayHeart) {
        HeartRenderEvent.Pre event = new HeartRenderEvent.Pre(guiGraphics, x, y, blinking, hardcore, overlayHeart);
        ((Consumer)FabHeartEvents.PRE_RENDER.invoker()).accept(event);
        return event;
    }

    @Override
    public void postRenderEvent(class_332 guiGraphics, int x, int y, boolean blinking, boolean hardcore, OverlayHeart overlayHeart) {
        HeartRenderEvent.Post event = new HeartRenderEvent.Post(guiGraphics, x, y, blinking, hardcore, overlayHeart);
        ((Consumer)FabHeartEvents.POST_RENDER.invoker()).accept(event);
    }

    @Override
    public void heartRegistryEvent(HeartRegistry registry) {
        FabricLoader.getInstance().getEntrypointContainers("colorfulhearts", ColorfulHeartsApi.class).forEach(entryPoint -> {
            String modId = entryPoint.getProvider().getMetadata().getId();
            try {
                CColorfulHearts.LOGGER.info("Loading ColorfulHeartsApi implementation of mod {}", (Object)modId);
                ColorfulHeartsApi api = (ColorfulHeartsApi)entryPoint.getEntrypoint();
                api.registerHearts(registry);
                CColorfulHearts.LOGGER.debug("Loaded ColorfulHeartsApi implementation of mod {}", (Object)modId);
            }
            catch (Throwable e) {
                CColorfulHearts.LOGGER.error("Could not load ColorfulHeartsApi implementation of mod {}", (Object)modId, (Object)e);
            }
        });
        ((Consumer)FabHeartEvents.HEART_REGISTRY.invoker()).accept(registry);
    }

    @Override
    public void heartUpdateEvent() {
        ((Runnable)FabHeartEvents.UPDATE.invoker()).run();
    }
}

