/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.render;

import java.util.List;
import net.minecraft.class_3532;
import terrails.colorfulhearts.api.heart.Hearts;
import terrails.colorfulhearts.api.heart.drawing.Heart;
import terrails.colorfulhearts.api.heart.drawing.HeartDrawing;
import terrails.colorfulhearts.api.heart.drawing.OverlayHeart;

public class HeartUtils {
    public static Heart[] calculateHearts(OverlayHeart overlayHeart, int health, int maxHealth, int absorbing) {
        boolean half;
        boolean halfBackground;
        boolean half2;
        int value;
        int i;
        List<HeartDrawing> absorptionDrawings;
        List<HeartDrawing> healthDrawings;
        if (overlayHeart != null && overlayHeart.isOpaque()) {
            healthDrawings = overlayHeart.getHealthDrawings();
            absorptionDrawings = overlayHeart.getAbsorptionDrawings();
        } else {
            healthDrawings = Hearts.COLORED_HEALTH_HEARTS;
            absorptionDrawings = Hearts.COLORED_ABSORPTION_HEARTS;
        }
        int topHealth = health > 20 ? health % 20 : 0;
        int bottomHealthRow = Math.max(0, class_3532.method_15375((float)((float)health / 20.0f)) - 1);
        int healthColorIndex = bottomHealthRow % healthDrawings.size();
        healthDrawings = List.of(healthDrawings.get((healthColorIndex + 1) % healthDrawings.size()), healthDrawings.get(healthColorIndex));
        int maxAbsorbing = maxHealth >= 19 ? 20 : 40 - maxHealth - maxHealth % 2;
        int topAbsorbing = absorbing > maxAbsorbing ? absorbing % maxAbsorbing : 0;
        int bottomAbsorptionRow = Math.max(0, class_3532.method_15375((float)((float)absorbing / (float)maxAbsorbing)) - 1);
        int absorptionColorIndex = bottomAbsorptionRow % absorptionDrawings.size();
        absorptionDrawings = List.of(absorptionDrawings.get((absorptionColorIndex + 1) % absorptionDrawings.size()), absorptionDrawings.get(absorptionColorIndex));
        maxHealth = Math.min(20, maxHealth);
        absorbing = Math.min(maxAbsorbing, absorbing);
        int absorbingOffset = Math.min(10, class_3532.method_15384((double)((double)maxHealth / 2.0)));
        int maxHealthHearts = class_3532.method_15384((double)((double)maxHealth / 2.0));
        int maxAbsorbingHearts = class_3532.method_15384((double)((double)maxAbsorbing / 2.0));
        Heart[] hearts = new Heart[20];
        for (i = 0; i < Math.max(maxHealthHearts, maxAbsorbingHearts); ++i) {
            value = i * 2;
            if (value < topHealth) {
                boolean bl = half2 = value + 1 == topHealth;
                hearts[i] = half2 ? Heart.full(healthDrawings.get(0), Heart.full(healthDrawings.get(1))) : Heart.full(healthDrawings.get(0));
            } else if (value < health) {
                halfBackground = value + 1 == maxHealth;
                boolean bl = half = value + 1 == health;
                hearts[i] = halfBackground ? Heart.half(healthDrawings.get(1)) : (half ? Heart.full(healthDrawings.get(1), Heart.CONTAINER_FULL) : Heart.full(healthDrawings.get(1)));
            } else if (value < maxHealth) {
                halfBackground = value + 1 == maxHealth;
                Heart heart = hearts[i] = halfBackground ? Heart.CONTAINER_HALF : Heart.CONTAINER_FULL;
            }
            if (value < topAbsorbing) {
                boolean bl = half2 = value + 1 == topAbsorbing;
                if (half2) {
                    hearts[i + absorbingOffset] = Heart.full(absorptionDrawings.get(0), Heart.full(absorptionDrawings.get(1)));
                    continue;
                }
                hearts[i + absorbingOffset] = Heart.full(absorptionDrawings.get(0));
                continue;
            }
            if (value >= absorbing) continue;
            half2 = value + 1 == absorbing;
            hearts[i + absorbingOffset] = half2 ? Heart.half(absorptionDrawings.get(1)) : Heart.full(absorptionDrawings.get(1));
        }
        if (overlayHeart != null && !overlayHeart.isOpaque()) {
            healthDrawings = overlayHeart.getHealthDrawings();
            if (!healthDrawings.isEmpty()) {
                healthColorIndex = bottomHealthRow % healthDrawings.size();
                healthDrawings = List.of(healthDrawings.get((healthColorIndex + 1) % healthDrawings.size()), healthDrawings.get(healthColorIndex));
            }
            if (!(absorptionDrawings = overlayHeart.getAbsorptionDrawings()).isEmpty()) {
                absorptionColorIndex = bottomAbsorptionRow % absorptionDrawings.size();
                absorptionDrawings = List.of(absorptionDrawings.get((absorptionColorIndex + 1) % absorptionDrawings.size()), absorptionDrawings.get(absorptionColorIndex));
            }
            for (i = 0; i < Math.max(maxHealthHearts, maxAbsorbingHearts); ++i) {
                value = i * 2;
                if (!healthDrawings.isEmpty()) {
                    if (value < topHealth) {
                        boolean bl = half2 = value + 1 == topHealth;
                        hearts[i] = half2 ? Heart.full(healthDrawings.get(0), Heart.full(healthDrawings.get(1), false, hearts[i])) : Heart.full(healthDrawings.get(0), false, hearts[i]);
                    } else if (value < health) {
                        halfBackground = value + 1 == maxHealth;
                        boolean bl = half = value + 1 == health;
                        hearts[i] = halfBackground ? Heart.full(healthDrawings.get(1), hearts[i]) : (half ? Heart.full(healthDrawings.get(1), hearts[i]) : Heart.full(healthDrawings.get(1), false, hearts[i]));
                    }
                }
                if (absorptionDrawings.isEmpty()) continue;
                if (value < topAbsorbing) {
                    boolean bl = half2 = value + 1 == topAbsorbing;
                    if (half2) {
                        hearts[i + absorbingOffset] = Heart.full(absorptionDrawings.get(0), Heart.full(absorptionDrawings.get(1), false, hearts[i + absorbingOffset]));
                        continue;
                    }
                    hearts[i + absorbingOffset] = Heart.full(absorptionDrawings.get(0), false, hearts[i + absorbingOffset]);
                    continue;
                }
                if (value >= absorbing) continue;
                half2 = value + 1 == absorbing;
                hearts[i + absorbingOffset] = half2 ? Heart.full(absorptionDrawings.get(1), hearts[i + absorbingOffset]) : Heart.full(absorptionDrawings.get(1), false, hearts[i + absorbingOffset]);
            }
        }
        return hearts;
    }
}

