/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.staaaaaaaaaaaack;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import me.frankv.staaaaaaaaaaaack.Staaaaaaaaaaaack;
import me.frankv.staaaaaaaaaaaack.config.StxckClientConfig;
import me.frankv.staaaaaaaaaaaack.mixin.ItemEntityAccessor;
import me.frankv.staaaaaaaaaaaack.mixin.ItemStackAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2940;

public class StxckUtil {
    public static final String EXTRA_ITEM_COUNT_TAG = "StxckExtraItemCount";
    private static class_2940<Integer> DATA_EXTRA_ITEM_COUNT;
    public static BiPredicate<class_1799, class_1799> areMergableReplacementPredicate;

    public static void setDataExtraItemCount(class_2940<Integer> entityDataAccessor) {
        if (DATA_EXTRA_ITEM_COUNT != null) {
            return;
        }
        DATA_EXTRA_ITEM_COUNT = entityDataAccessor;
    }

    public static void refillItemStack(class_1542 entity) {
        int extraItemCount = StxckUtil.getExtraItemCount(entity);
        if (extraItemCount <= 0) {
            return;
        }
        class_1799 stack = entity.method_6983();
        Optional.ofNullable(((ItemStackAccessor)stack).accessItem()).map(class_1792::method_7882).ifPresent(maxSize -> {
            if (stack.method_7947() == maxSize.intValue()) {
                return;
            }
            int x = maxSize - stack.method_7947();
            int refillCount = Math.min(x, extraItemCount);
            stack.method_7933(refillCount);
            StxckUtil.setExtraItemCount(entity, extraItemCount - refillCount);
            entity.method_6979(stack.method_7972());
        });
    }

    public static boolean areMergable(class_1542 itemEntity, class_1542 itemEntity1) {
        int maxExtraSize = Staaaaaaaaaaaack.commonConfig.getMaxSize();
        if (maxExtraSize - StxckUtil.getExtraItemCount(itemEntity) < StxckUtil.getTotalCount(itemEntity1) && maxExtraSize - StxckUtil.getExtraItemCount(itemEntity1) < StxckUtil.getTotalCount(itemEntity)) {
            return false;
        }
        class_1799 itemStack = itemEntity.method_6983();
        class_1799 itemStack1 = itemEntity1.method_6983();
        if (areMergableReplacementPredicate != null) {
            return areMergableReplacementPredicate.test(itemStack, itemStack1);
        }
        if (!itemStack1.method_31574(itemStack.method_7909())) {
            return false;
        }
        if (itemStack1.method_7985() ^ itemStack.method_7985()) {
            return false;
        }
        return !itemStack1.method_7985() || Objects.equals(itemStack1.method_7969(), itemStack.method_7969());
    }

    public static void grow(class_1542 entity, int count) {
        StxckUtil.setExtraItemCount(entity, StxckUtil.getExtraItemCount(entity) + count);
        StxckUtil.refillItemStack(entity);
    }

    public static boolean isMergable(class_1542 entity) {
        ItemEntityAccessor accessor = (ItemEntityAccessor)entity;
        int pickupDelay = accessor.getPickupDelay();
        int age = accessor.getAge();
        return entity.method_5805() && pickupDelay != Short.MAX_VALUE && age != Short.MIN_VALUE && age < 6000;
    }

    public static Supplier<Optional<String>> getOverlayTextSupplier(class_1542 entity) {
        boolean alwaysShowItemCount = Staaaaaaaaaaaack.clientConfig.isAlwaysShowItemCount();
        return switch (Staaaaaaaaaaaack.clientConfig.getOverlayDisplayMode()) {
            default -> throw new IncompatibleClassChangeError();
            case StxckClientConfig.OverlayDisplayMode.ITEM_COUNT -> () -> StxckUtil.getTotalCountOverlayText(entity, alwaysShowItemCount);
            case StxckClientConfig.OverlayDisplayMode.STACK_COUNT -> () -> {
                int maxStackSize = entity.method_6983().method_7914();
                int stackCount = (int)Math.ceil((double)StxckUtil.getTotalCount(entity) / (double)maxStackSize);
                boolean show = stackCount > 1 || alwaysShowItemCount;
                return show ? Optional.of(String.format("%dx", stackCount)) : Optional.empty();
            };
        };
    }

    private static Optional<String> getTotalCountOverlayText(class_1542 entity, boolean alwaysShowItemCount) {
        int total = StxckUtil.getTotalCount(entity);
        if (total >= 1000000000) {
            return Optional.of(String.format("%.3fB", Float.valueOf((float)total / 1.0E9f)));
        }
        if (total >= 1000000) {
            return Optional.of(String.format("%.2fM", Float.valueOf((float)total / 1000000.0f)));
        }
        if (total >= 10000) {
            return Optional.of(String.format("%.1fK", Float.valueOf((float)total / 1000.0f)));
        }
        if (alwaysShowItemCount || total > entity.method_6983().method_7914()) {
            return Optional.of(String.valueOf(total));
        }
        return Optional.empty();
    }

    public static int getTotalCount(class_1542 entity) {
        return entity.method_6983().method_7947() + StxckUtil.getExtraItemCount(entity);
    }

    public static int getExtraItemCount(class_1542 entity) {
        return (Integer)entity.method_5841().method_12789(DATA_EXTRA_ITEM_COUNT);
    }

    public static void setExtraItemCount(class_1542 entity, int count) {
        entity.method_5841().method_12778(DATA_EXTRA_ITEM_COUNT, (Object)count);
    }

    public static boolean tryRefillItemStackOnEntityRemove(class_1297 entity, class_1297.class_5529 reason) {
        if (!entity.method_5864().equals(class_1299.field_6052) || !reason.equals((Object)class_1297.class_5529.field_26999)) {
            return false;
        }
        class_1542 itemEntity = (class_1542)entity;
        if (StxckUtil.getExtraItemCount(itemEntity) <= 0) {
            return false;
        }
        class_1799 copied = itemEntity.method_6983().method_7972();
        itemEntity.method_6979(copied);
        copied.method_7939(0);
        StxckUtil.refillItemStack(itemEntity);
        return true;
    }

    public static void tryToMerge(class_1542 itemEntity, class_1542 itemEntity1) {
        StxckUtil.tryToMerge(itemEntity, itemEntity1, false);
    }

    public static void tryToMerge(class_1542 itemEntity, class_1542 itemEntity1, boolean mergeToExisted) {
        if (Objects.equals(itemEntity.method_24921(), itemEntity1.method_24921()) && StxckUtil.areMergable(itemEntity, itemEntity1)) {
            if (mergeToExisted || StxckUtil.getTotalCount(itemEntity1) < StxckUtil.getTotalCount(itemEntity)) {
                StxckUtil.merge(itemEntity, itemEntity1);
            } else {
                StxckUtil.merge(itemEntity1, itemEntity);
            }
        }
    }

    public static void merge(class_1542 consumer, class_1542 supplier) {
        ItemEntityAccessor consumerAccessor = (ItemEntityAccessor)consumer;
        ItemEntityAccessor supplierAccessor = (ItemEntityAccessor)supplier;
        consumerAccessor.setPickupDelay(Math.max(consumerAccessor.getPickupDelay(), supplierAccessor.getPickupDelay()));
        consumerAccessor.setAge(Math.min(consumerAccessor.getAge(), supplierAccessor.getAge()));
        StxckUtil.grow(consumer, StxckUtil.getTotalCount(supplier));
        StxckUtil.setExtraItemCount(supplier, 0);
        supplier.method_6979(class_1799.field_8037);
        supplier.method_31472();
    }

    public static boolean isBlackListItem(class_1799 itemStack) {
        if (!Staaaaaaaaaaaack.commonConfig.isEnableForUnstackableItem() && itemStack.method_7914() == 1) {
            return true;
        }
        return itemStack.method_31573(Staaaaaaaaaaaack.BLACK_LIST_TAG) || Staaaaaaaaaaaack.getItemBlackList().contains(itemStack.method_7909());
    }
}

