/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.staaaaaaaaaaaack.config;

import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiberUtils {
    private static final Logger log = LoggerFactory.getLogger(FiberUtils.class);

    private static void writeDefaultConfig(ConfigTree config, Path path, JanksonValueSerializer serializer) {
        try (BufferedOutputStream outputStream2 = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));){
            FiberSerialization.serialize((ConfigTree)config, (OutputStream)outputStream2, (ValueSerializer)serializer);
        }
        catch (FileAlreadyExistsException outputStream2) {
        }
        catch (IOException e) {
            log.error("Error writing default config", (Throwable)e);
        }
    }

    private static void loadConfig(ConfigTree config, Path path, JanksonValueSerializer serializer) {
        FiberUtils.writeDefaultConfig(config, path, serializer);
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(path, StandardOpenOption.READ, StandardOpenOption.CREATE));){
            FiberSerialization.deserialize((ConfigTree)config, (InputStream)inputStream, (ValueSerializer)serializer);
        }
        catch (ValueDeserializationException | IOException e) {
            log.error("Error loading config from {}", (Object)path, (Object)e);
        }
    }

    public static void setup(ConfigTree config, String fileName) {
        try {
            Files.createDirectory(Paths.get("config", new String[0]), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            log.warn("Failed to make config dir", (Throwable)e);
        }
        JanksonValueSerializer serializer = new JanksonValueSerializer(false);
        FiberUtils.loadConfig(config, Path.of("config", fileName), serializer);
    }
}

