/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.staaaaaaaaaaaack.config;

import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigTreeBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ListConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.util.List;
import me.frankv.staaaaaaaaaaaack.config.StxckCommonConfig;

public class StxckFiberCommonConfig
implements StxckCommonConfig {
    public static final String fileName = "staaaaaaaaaaaack-common.json5";
    private static final ListConfigType<List<String>, String> stringListConfigType = ConfigTypes.makeList((ConfigType)ConfigTypes.STRING);
    private final ConfigTree configTree;
    private final PropertyMirror<Double> maxMergeDistanceHorizontal = PropertyMirror.create((ConfigType)ConfigTypes.DOUBLE);
    private final PropertyMirror<Double> maxMergeDistanceVertical = PropertyMirror.create((ConfigType)ConfigTypes.DOUBLE);
    private final PropertyMirror<Integer> maxSize = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    private final PropertyMirror<Boolean> enableForUnstackableItem = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    private final PropertyMirror<List<String>> itemBlackList = PropertyMirror.create(stringListConfigType);

    public StxckFiberCommonConfig() {
        ConfigTreeBuilder builder = ConfigTree.builder();
        builder.beginValue("maxMergeDistanceHorizontal", (ConfigType)ConfigTypes.DOUBLE.withMaximum((Object)10.0).withMinimum((Object)0.5), (Object)1.25).withComment("\nThe maximum horizontal block distance over which dropped items attempt to merge with each other.\nRange: 0.5 ~ 10.0, Default: 1.25, Minecraft default: 0.5\n").finishValue(arg_0 -> this.maxMergeDistanceHorizontal.mirror(arg_0));
        builder.beginValue("maxMergeDistanceVertical", (ConfigType)ConfigTypes.DOUBLE.withMaximum((Object)10.0).withMinimum((Object)0.0), (Object)0.0).withComment("\nThe minimum vertical block distance over which dropped items attempt to merge with each other.\nRange: 0.0 ~ 10.0, Default: 0.0, Minecraft default: 0.0\n").finishValue(arg_0 -> this.maxMergeDistanceVertical.mirror(arg_0));
        builder.beginValue("maxSize", (ConfigType)ConfigTypes.INTEGER.withMaximum((Object)Integer.MAX_VALUE).withMinimum((Object)1), (Object)Integer.MAX_VALUE).withComment(String.format("\nThe maximum number of extra items that an item entity can hold.\nRange: 0 ~ %d, Default: %d\n", Integer.MAX_VALUE, Integer.MAX_VALUE)).finishValue(arg_0 -> this.maxSize.mirror(arg_0));
        builder.beginValue("enableForUnstackableItem", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("\nEnable for merging non-stackable item.\nShould be used with caution while playing with other mods.\nDefault: false\n").finishValue(arg_0 -> this.enableForUnstackableItem.mirror(arg_0));
        builder.beginValue("itemBlackList", stringListConfigType, List.of()).withComment("\nThe list of items that should not exceed their original max stack size.\nYou can achieve the same feature by using the item tag \"#staaaaaaaaaaaack:blacklist\" as well.\ne.g., [\"minecraft:diamond_block\", \"minecraft:coal\"]\n").finishValue(arg_0 -> this.itemBlackList.mirror(arg_0));
        this.configTree = builder.build();
    }

    @Override
    public double getMaxMergeDistanceHorizontal() {
        return (Double)this.maxMergeDistanceHorizontal.getValue();
    }

    @Override
    public double getMaxMergeDistanceVertical() {
        return (Double)this.maxMergeDistanceVertical.getValue();
    }

    @Override
    public int getMaxSize() {
        return (Integer)this.maxSize.getValue();
    }

    @Override
    public boolean isEnableForUnstackableItem() {
        return (Boolean)this.enableForUnstackableItem.getValue();
    }

    @Override
    public List<? extends String> getItemBlackList() {
        return (List)this.itemBlackList.getValue();
    }

    public ConfigTree getConfigTree() {
        return this.configTree;
    }
}

