/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.block.entity;

import ad_astra_giselle_addon.common.block.entity.VirtualInputOnlyContainer;
import ad_astra_giselle_addon.common.config.MachinesConfig;
import ad_astra_giselle_addon.common.item.SidedItemContainerBlock;
import ad_astra_giselle_addon.common.menu.AutomationNasaWorkbenchMenu;
import earth.terrarium.adastra.common.blockentities.base.ContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.RecipeMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.recipes.machines.NasaWorkbenchRecipe;
import earth.terrarium.adastra.common.registry.ModRecipeTypes;
import earth.terrarium.adastra.common.utils.ItemUtils;
import earth.terrarium.adastra.common.utils.ModUtils;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutomationNasaWorkbenchBlockEntity
extends RecipeMachineBlockEntity<NasaWorkbenchRecipe>
implements SidedItemContainerBlock {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_INPUT_SLOTS), new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_OUTPUT_SLOTS), new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.NONE, ConstantComponents.SIDE_CONFIG_ENERGY));
    public static final int[] INPUT_SLOTS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14};
    public static final int[] OUTPUT_SLOTS = new int[]{15};
    public static final int[] SLOTS_FOR_FACE = ArrayUtils.addAll((int[])INPUT_SLOTS, (int[])OUTPUT_SLOTS);
    public static final int CONTAINER_SIZE = 1 + INPUT_SLOTS.length + OUTPUT_SLOTS.length;
    private VirtualInputOnlyContainer recipeContainer = new VirtualInputOnlyContainer((ContainerMachineBlockEntity)this, INPUT_SLOTS[0], INPUT_SLOTS.length);
    private boolean firstTick = true;
    private List<RecipeCache> recipeCaches = new ArrayList<RecipeCache>();

    public AutomationNasaWorkbenchBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state, CONTAINER_SIZE, (Supplier)ModRecipeTypes.NASA_WORKBENCH);
    }

    public class_1703 createMenu(int syncId, @NotNull class_1661 inv, @NotNull class_1657 player) {
        return new AutomationNasaWorkbenchMenu(syncId, inv, this);
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        if (this.energyContainer == null) {
            this.energyContainer = new WrappedBlockEnergyContainer((class_2586)this, (EnergyContainer)new InsertOnlyEnergyContainer(MachinesConfig.AUTOMATION_NASA_WORKBENCH_ENERGY_CAPACITY, MachinesConfig.AUTOMATION_NASA_WORKBENCH_ENERGY_CAPACITY));
        }
        return this.energyContainer;
    }

    public void tickSideInteractions(class_2338 pos, Predicate<class_2350> filter, List<ConfigurationEntry> sideConfig) {
        super.tickSideInteractions(pos, filter, sideConfig);
        TransferUtils.pullItemsNearby((ContainerMachineBlockEntity)this, (class_2338)pos, (int[])INPUT_SLOTS, (ConfigurationEntry)sideConfig.get(0), filter);
        TransferUtils.pushItemsNearby((ContainerMachineBlockEntity)this, (class_2338)pos, (int[])OUTPUT_SLOTS, (ConfigurationEntry)sideConfig.get(1), filter);
        TransferUtils.pushEnergyNearby((ContainerMachineBlockEntity)this, (class_2338)pos, (long)this.getEnergyStorage().maxExtract(), (ConfigurationEntry)sideConfig.get(2), filter);
        TransferUtils.pullEnergyNearby((ContainerMachineBlockEntity)this, (class_2338)pos, (long)this.getEnergyStorage().maxInsert(), (ConfigurationEntry)sideConfig.get(2), filter);
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        if (ArrayUtils.contains((int[])OUTPUT_SLOTS, (int)slot)) {
            return false;
        }
        return this.recipeCaches.stream().filter(cache -> cache.testRemain(this.recipeContainer.toRecipeSlot(slot), stack)).findAny().isPresent();
    }

    public boolean method_5493(int slot, @NotNull class_1799 stack, @NotNull class_2350 dir) {
        return ArrayUtils.contains((int[])OUTPUT_SLOTS, (int)slot);
    }

    public void recipeTick(class_3218 level, WrappedBlockEnergyContainer energyStroage) {
        if (this.recipe == null) {
            return;
        }
        if (!this.canCraft()) {
            this.clearRecipe();
            return;
        }
        energyStroage.internalExtract(MachinesConfig.AUTOMATION_NASA_WORKBENCH_ENERGY_USAGE, false);
        ++this.cookTime;
        if (this.cookTime < this.cookTimeTotal) {
            return;
        }
        this.craft();
    }

    public boolean canCraft() {
        return this.recipe != null && ((NasaWorkbenchRecipe)this.recipe).method_8115((class_1263)this.recipeContainer, this.method_10997()) && ItemUtils.canAddItem((class_1263)this, (class_1799)((NasaWorkbenchRecipe)this.recipe).result(), (int[])OUTPUT_SLOTS);
    }

    public void craft() {
        if (this.recipe == null) {
            return;
        }
        this.spawnResultParticles();
        for (int element : INPUT_SLOTS) {
            this.method_5438(element).method_7934(1);
        }
        ItemUtils.addItem((class_1263)this, (class_1799)((NasaWorkbenchRecipe)this.recipe).result(), (int[])OUTPUT_SLOTS);
        this.clearRecipe();
    }

    public void update() {
        super.update();
        if (!this.method_10997().method_8608()) {
            this.cacheRecipes();
        }
    }

    public void serverTick(class_3218 level, long time, class_2680 state, class_2338 pos) {
        super.serverTick(level, time, state, pos);
        if (this.firstTick) {
            this.firstTick = false;
            this.cacheRecipes();
        }
        if (this.recipeCaches.stream().anyMatch(RecipeCache::anyAdded)) {
            this.spawnWorkingParticles();
        }
    }

    public void spawnWorkingParticles() {
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            class_2338 pos = this.method_11016();
            ModUtils.sendParticles((class_3218)level, (class_2394)class_2398.field_11205, (double)((double)pos.method_10263() + 0.5), (double)((double)pos.method_10264() + 1.5), (double)((double)pos.method_10260() + 0.5), (int)10, (double)0.1, (double)0.1, (double)0.1, (double)0.1);
        }
    }

    public void spawnResultParticles() {
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            class_2338 pos = this.method_11016();
            ModUtils.sendParticles((class_3218)level, (class_2394)class_2398.field_11220, (double)((double)pos.method_10263() + 0.5), (double)((double)pos.method_10264() + 1.5), (double)((double)pos.method_10260() + 0.5), (int)100, (double)0.1, (double)0.1, (double)0.1, (double)0.7);
            level.method_8396(null, pos, class_3417.field_14931, class_3419.field_15254, 1.0f, 1.0f);
        }
    }

    private void cacheRecipes() {
        VirtualInputOnlyContainer container = this.recipeContainer;
        List recipes = this.method_10997().method_8433().method_30027((class_3956)ModRecipeTypes.NASA_WORKBENCH.get());
        this.recipeCaches.clear();
        this.recipeCaches.addAll(recipes.stream().map(recipe -> this.cache((NasaWorkbenchRecipe)recipe, container)).filter(cache -> cache != null).toList());
        this.recipe = this.recipeCaches.stream().filter(cache -> cache.isComplete()).map(RecipeCache::recipe).findFirst().orElse(null);
        this.cookTimeTotal = this.recipe == null ? 0 : MachinesConfig.AUTOMATION_NASA_WORKBENCH_COOK_TIME;
    }

    private RecipeCache cache(NasaWorkbenchRecipe recipe, VirtualInputOnlyContainer container) {
        List ingredients = recipe.ingredients();
        ArrayList<SlotWithIngredient> remainIngredients = new ArrayList<SlotWithIngredient>();
        boolean mismatched = false;
        boolean anyAdded = false;
        for (int i = 0; i < ingredients.size(); ++i) {
            class_1799 item = container.method_5438(i);
            class_1856 ingredient = (class_1856)ingredients.get(i);
            boolean needAdd = false;
            if (item.method_7960()) {
                needAdd = true;
            } else if (!ingredient.method_8093(item)) {
                needAdd = true;
                mismatched = true;
            } else {
                anyAdded = true;
            }
            if (!needAdd) continue;
            remainIngredients.add(new SlotWithIngredient(i, ingredient));
        }
        if (!mismatched) {
            return new RecipeCache(recipe, remainIngredients, anyAdded);
        }
        return null;
    }

    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int[] method_5494(class_2350 pSide) {
        return SLOTS_FOR_FACE;
    }

    @Override
    public int getSideSlotLimit(int slot, @Nullable class_2350 directon) {
        return directon == null ? this.method_5444() : 1;
    }

    @Override
    public class_1278 getContainer() {
        return this;
    }

    private record SlotWithIngredient(int slot, class_1856 ingredient) {
        public boolean test(int putSlot, class_1799 item) {
            return putSlot == this.slot() && this.ingredient().method_8093(item);
        }
    }

    private record RecipeCache(NasaWorkbenchRecipe recipe, List<SlotWithIngredient> remainIngredients, boolean anyAdded) {
        public boolean testRemain(int putSlot, class_1799 item) {
            List<SlotWithIngredient> remainIngredients = this.remainIngredients();
            return remainIngredients.stream().filter(i -> i.test(putSlot, item)).findAny().isPresent();
        }

        public boolean isComplete() {
            return this.remainIngredients().size() == 0;
        }
    }
}

