/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.proof;

import ad_astra_giselle_addon.common.config.EnchantmentsConfig;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenCharger;
import ad_astra_giselle_addon.common.content.oxygen.OxygenChargerUtils;
import ad_astra_giselle_addon.common.content.proof.ProofAbstractUtils;
import ad_astra_giselle_addon.common.content.proof.ProofEnchantmentFunction;
import ad_astra_giselle_addon.common.entity.LivingHelper;
import ad_astra_giselle_addon.common.fluid.FluidPredicates;
import ad_astra_giselle_addon.common.fluid.FluidUtils2;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import ad_astra_giselle_addon.common.item.ItemUsableResource;
import ad_astra_giselle_addon.common.registry.AddonEnchantments;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import net.minecraft.class_1309;
import net.minecraft.class_1887;

public class OxygenProofEnchantmentFunction
extends ProofEnchantmentFunction {
    @Override
    public class_1887 getEnchantment() {
        return AddonEnchantments.OXYGEN_PROOF.get();
    }

    @Override
    public boolean consume(class_1309 living, ItemStackReference enchantedItem, ItemUsableResource resource, boolean simulate) {
        if (!super.consume(living, enchantedItem, resource, simulate)) {
            return false;
        }
        if (LivingHelper.isPlayingMode(living)) {
            long oxygenUsing = this.getOxygenUsing(resource);
            IOxygenCharger oxygenCharger = OxygenChargerUtils.firstExtractable(living, oxygenUsing);
            if (oxygenCharger == null) {
                return false;
            }
            FluidContainer fluidContainer = oxygenCharger.getFluidContainer();
            FluidHolder extracted = FluidUtils2.extractFluid(fluidContainer, FluidPredicates::isOxygen, oxygenUsing, simulate);
            return extracted.getFluidAmount() >= oxygenUsing;
        }
        return true;
    }

    @Override
    public long getResourceUsingAmount(ItemUsableResource resource) {
        if (resource == ItemUsableResource.Energy) {
            return EnchantmentsConfig.OXYGEN_PROOF_ENERGY_USING;
        }
        if (resource == ItemUsableResource.Durability) {
            return EnchantmentsConfig.OXYGEN_PROOF_DURABILITY_USING;
        }
        return 0L;
    }

    @Override
    public int getProofDuration(ItemUsableResource resource) {
        if (resource == ItemUsableResource.Energy) {
            return 30;
        }
        if (resource == ItemUsableResource.Durability) {
            return EnchantmentsConfig.OXYGEN_PROOF_DURABILITY_DURATION;
        }
        return 0;
    }

    public long getOxygenUsing(ItemUsableResource resource) {
        if (resource == ItemUsableResource.Energy) {
            return ProofAbstractUtils.OXYGEN_PROOF_USING;
        }
        if (resource == ItemUsableResource.Durability) {
            return FluidConstants.fromMillibuckets((long)EnchantmentsConfig.OXYGEN_PROOF_DURABILITY_OXYGEN);
        }
        return 0L;
    }
}

