/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.upgrades;

import appeng.api.inventories.InternalInventory;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.Upgrades;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

abstract class UpgradeInventory
extends AppEngInternalInventory
implements InternalInventoryHost,
IUpgradeInventory {
    private final class_1792 item;
    @Nullable
    private Reference2IntMap<class_1792> installed = null;

    public UpgradeInventory(class_1792 item, int slots) {
        super(null, slots, 1);
        this.item = item;
        this.setHost(this);
        this.setFilter(new UpgradeInvFilter());
    }

    @Override
    public boolean isClientSide() {
        return false;
    }

    @Override
    protected boolean eventsEnabled() {
        return true;
    }

    @Override
    public int getMaxInstalled(class_1935 upgradeCard) {
        return Upgrades.getMaxInstallable(upgradeCard, (class_1935)this.item);
    }

    @Override
    public class_1935 getUpgradableItem() {
        return this.item;
    }

    @Override
    public int getInstalledUpgrades(class_1935 upgradeCard) {
        if (this.installed == null) {
            this.updateUpgradeInfo();
        }
        return this.installed.getOrDefault((Object)upgradeCard.method_8389(), 0);
    }

    private void updateUpgradeInfo() {
        this.installed = new Reference2IntArrayMap(this.size());
        for (class_1799 is : this) {
            int maxInstalled = this.getMaxInstalled((class_1935)is.method_7909());
            if (maxInstalled <= 0) continue;
            this.installed.merge((Object)is.method_7909(), 1, (a, b) -> Math.min(maxInstalled, a + b));
        }
    }

    @Override
    public void readFromNBT(class_2487 data, String name) {
        super.readFromNBT(data, name);
        this.updateUpgradeInfo();
    }

    @Override
    public void saveChanges() {
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        this.installed = null;
    }

    @Override
    public void sendChangeNotification(int slot) {
        this.installed = null;
        super.sendChangeNotification(slot);
    }

    private class UpgradeInvFilter
    implements IAEItemFilter {
        private UpgradeInvFilter() {
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, class_1799 itemstack) {
            class_1792 cardItem = itemstack.method_7909();
            return UpgradeInventory.this.getInstalledUpgrades((class_1935)cardItem) < UpgradeInventory.this.getMaxInstalled((class_1935)cardItem);
        }
    }
}

