/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.blockentities.ICrankable;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.stacks.AEItemKey;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.blockentity.misc.ChargerRecipes;
import appeng.core.AEConfig;
import appeng.core.settings.TickRates;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class ChargerBlockEntity
extends AENetworkPowerBlockEntity
implements IGridTickable {
    public static final int POWER_MAXIMUM_AMOUNT = 1600;
    private static final int POWER_THRESHOLD = 1599;
    private boolean working;
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 1, 1, new ChargerInvFilter(this));

    public ChargerBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setFlags(new GridFlags[0]).setIdlePowerUsage(0.0).addService(IGridTickable.class, this);
        this.setInternalMaxPower(1600.0);
        this.setPowerSides(this.getGridConnectableSides(this.getOrientation()));
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.COVERED;
    }

    @Override
    public Set<class_2350> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.complementOf(EnumSet.of(orientation.getSide(RelativeSide.FRONT)));
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        boolean changed = super.readFromStream(data);
        this.working = data.readBoolean();
        if (data.readBoolean()) {
            AEItemKey item = AEItemKey.fromPacket(data);
            this.inv.setItemDirect(0, item.toStack());
        } else {
            this.inv.setItemDirect(0, class_1799.field_8037);
        }
        return changed;
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.working);
        AEItemKey is = AEItemKey.of(this.inv.getStackInSlot(0));
        data.writeBoolean(is != null);
        if (is != null) {
            is.writeToPacket(data);
        }
    }

    @Override
    protected void onOrientationChanged(BlockOrientation orientation) {
        super.onOrientationChanged(orientation);
        this.setPowerSides(this.getGridConnectableSides(orientation));
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice((IGridNode)node));
        this.markForUpdate();
    }

    public void activate(class_1657 player) {
        if (!Platform.hasPermissions(new DimensionalBlockPos(this), player)) {
            return;
        }
        class_1799 myItem = this.inv.getStackInSlot(0);
        if (myItem.method_7960()) {
            class_1799 held = player.method_31548().method_7391();
            if (ChargerRecipes.findRecipe(this.field_11863, held) != null || Platform.isChargeable(held)) {
                held = player.method_31548().method_5434(player.method_31548().field_7545, 1);
                this.inv.setItemDirect(0, held);
            }
        } else {
            List<class_1799> drops = List.of(myItem);
            this.inv.setItemDirect(0, class_1799.field_8037);
            Platform.spawnDrops(player.method_37908(), this.field_11867.method_10093(this.getFront()), drops);
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Charger, false, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.doWork(ticksSinceLastCall);
        return TickRateModulation.FASTER;
    }

    private void doWork(int ticksSinceLastCall) {
        boolean wasWorking = this.working;
        this.working = false;
        boolean changed = false;
        class_1799 myItem = this.inv.getStackInSlot(0);
        if (!myItem.method_7960()) {
            if (Platform.isChargeable(myItem)) {
                double maxPower;
                IAEItemPowerStorage ps = (IAEItemPowerStorage)myItem.method_7909();
                double currentPower = ps.getAECurrentPower(myItem);
                if (currentPower < (maxPower = ps.getAEMaxPower(myItem))) {
                    double chargeRate = ps.getChargeRate(myItem) * (double)ticksSinceLastCall * AEConfig.instance().getChargerChargeRate();
                    double extractedAmount = this.extractAEPower(chargeRate, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    double missingChargeRate = chargeRate - extractedAmount;
                    double missingAEPower = maxPower - currentPower;
                    double toExtract = Math.min(missingChargeRate, missingAEPower);
                    IGrid grid2 = this.getMainNode().getGrid();
                    if (grid2 != null) {
                        extractedAmount += grid2.getEnergyService().extractAEPower(toExtract, Actionable.MODULATE, PowerMultiplier.ONE);
                    }
                    if (extractedAmount > 0.0) {
                        double adjustment = ps.injectAEPower(myItem, extractedAmount, Actionable.MODULATE);
                        this.setInternalCurrentPower(this.getInternalCurrentPower() + adjustment);
                        this.working = true;
                        changed = true;
                    }
                }
            } else if (this.getInternalCurrentPower() > 1599.0 && ChargerRecipes.findRecipe(this.field_11863, myItem) != null) {
                this.working = true;
                if (this.field_11863 != null && this.field_11863.method_8409().method_43057() > 0.8f) {
                    this.extractAEPower(this.getInternalMaxPower(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                    class_1792 charged = Objects.requireNonNull(ChargerRecipes.findRecipe((class_1937)this.field_11863, (class_1799)myItem)).result;
                    this.inv.setItemDirect(0, new class_1799((class_1935)charged));
                    changed = true;
                }
            }
        }
        if (this.getInternalCurrentPower() < 1599.0) {
            this.getMainNode().ifPresent(grid -> {
                double toExtract = Math.min(800.0, this.getInternalMaxPower() - this.getInternalCurrentPower());
                double extracted = grid.getEnergyService().extractAEPower(toExtract, Actionable.MODULATE, PowerMultiplier.ONE);
                this.injectExternalPower(PowerUnits.AE, extracted, Actionable.MODULATE);
            });
            changed = true;
        }
        if (changed || this.working != wasWorking) {
            this.markForUpdate();
        }
    }

    public boolean isWorking() {
        return this.working;
    }

    @Nullable
    public ICrankable getCrankable(class_2350 direction) {
        if (direction != this.getFront()) {
            return new Crankable();
        }
        return null;
    }

    private record ChargerInvFilter(ChargerBlockEntity chargerBlockEntity) implements IAEItemFilter
    {
        @Override
        public boolean allowInsert(InternalInventory inv, int i, class_1799 itemstack) {
            return Platform.isChargeable(itemstack) || ChargerRecipes.allowInsert(this.chargerBlockEntity.field_11863, itemstack);
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slotIndex, int amount) {
            IAEItemPowerStorage ips;
            class_1799 extractedItem = inv.getStackInSlot(slotIndex);
            if (Platform.isChargeable(extractedItem) && (ips = (IAEItemPowerStorage)extractedItem.method_7909()).getAECurrentPower(extractedItem) >= ips.getAEMaxPower(extractedItem)) {
                return true;
            }
            return ChargerRecipes.allowExtract(this.chargerBlockEntity.field_11863, extractedItem);
        }
    }

    class Crankable
    implements ICrankable {
        Crankable() {
        }

        @Override
        public boolean canTurn() {
            return ChargerBlockEntity.this.getInternalCurrentPower() < ChargerBlockEntity.this.getInternalMaxPower();
        }

        @Override
        public void applyTurn() {
            ChargerBlockEntity.this.injectExternalPower(PowerUnits.AE, 160.0, Actionable.MODULATE);
        }
    }
}

