/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.crafting;

import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.CalculationStrategy;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.ISubMenuHost;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfirmAutoCraftPacket;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.SlotSemantics;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.locator.MenuLocator;
import appeng.menu.me.crafting.CraftConfirmMenu;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.InaccessibleSlot;
import appeng.util.inv.AppEngInternalInventory;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public class CraftAmountMenu
extends AEBaseMenu
implements ISubMenu {
    public static final class_3917<CraftAmountMenu> TYPE = MenuTypeBuilder.create(CraftAmountMenu::new, ISubMenuHost.class).build("craftamount");
    private final AppEngSlot craftingItem;
    private AEKey whatToCraft;
    private final ISubMenuHost host;

    public CraftAmountMenu(int id, class_1661 ip, ISubMenuHost host) {
        super(TYPE, id, ip, host);
        this.host = host;
        this.craftingItem = new InaccessibleSlot(new AppEngInternalInventory(1), 0);
        this.craftingItem.setHideAmount(true);
        this.addSlot(this.craftingItem, SlotSemantics.MACHINE_OUTPUT);
    }

    @Override
    public ISubMenuHost getHost() {
        return this.host;
    }

    public static void open(class_3222 player, MenuLocator locator, AEKey whatToCraft, int initialAmount) {
        MenuOpener.open(TYPE, (class_1657)player, locator);
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof CraftAmountMenu) {
            CraftAmountMenu cca = (CraftAmountMenu)class_17032;
            cca.setWhatToCraft(whatToCraft, initialAmount);
            cca.method_7623();
        }
    }

    public class_1937 getLevel() {
        return this.getPlayerInventory().field_7546.method_37908();
    }

    private void setWhatToCraft(AEKey whatToCraft, int initialAmount) {
        this.whatToCraft = Objects.requireNonNull(whatToCraft, "whatToCraft");
        this.craftingItem.method_7673(GenericStack.wrapInItemStack(whatToCraft, initialAmount));
    }

    public void confirm(int amount, boolean craftMissingAmount, boolean autoStart) {
        MenuLocator locator;
        IGridNode node;
        IActionHost host;
        if (!this.isServerSide()) {
            NetworkHandler.instance().sendToServer(new ConfirmAutoCraftPacket(amount, craftMissingAmount, autoStart));
            return;
        }
        if (this.whatToCraft == null) {
            return;
        }
        if (craftMissingAmount && (host = this.getActionHost()) != null && (node = host.getActionableNode()) != null) {
            IStorageService storage = node.getGrid().getStorageService();
            int existingAmount = (int)Math.min(storage.getCachedInventory().get(this.whatToCraft), Integer.MAX_VALUE);
            amount = existingAmount > amount ? 0 : (amount -= existingAmount);
        }
        if ((locator = this.getLocator()) != null) {
            class_1657 player = this.getPlayer();
            if (amount > 0) {
                MenuOpener.open(CraftConfirmMenu.TYPE, player, locator);
                class_1703 class_17032 = player.field_7512;
                if (class_17032 instanceof CraftConfirmMenu) {
                    CraftConfirmMenu ccc = (CraftConfirmMenu)class_17032;
                    ccc.setAutoStart(autoStart);
                    ccc.planJob(this.whatToCraft, amount, CalculationStrategy.REPORT_MISSING_ITEMS);
                    this.method_7623();
                }
            } else {
                this.host.returnToMainMenu(player, this);
            }
        }
    }

    @Nullable
    public GenericStack getWhatToCraft() {
        return GenericStack.unwrapItemStack(this.craftingItem.method_7677());
    }
}

