/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class LustrousMoxieItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown = effect.getRadiantTeleportCooldown();
    int stepMod = 0;

    public LustrousMoxieItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (!attacker.method_37908().method_8608()) {
            class_1293 radiantMarkEffect = target.method_6112(ModEffectsRegistry.RADIANT_MARK);
            if (target.method_6059(ModEffectsRegistry.RADIANT_MARK) && radiantMarkEffect != null) {
                target.method_5643(attacker.method_48923().method_48831(), (float)(radiantMarkEffect.method_5578() + 1));
            }
            if (attacker.method_6051().method_39332(1, 100) <= effect.getRadiantMarkChance()) {
                if (target.method_6059(ModEffectsRegistry.RADIANT_MARK) && radiantMarkEffect != null) {
                    int amplifier = radiantMarkEffect.method_5578() + 1;
                    int duration = 240 - amplifier * 40;
                    target.method_37222(new class_1293(ModEffectsRegistry.RADIANT_MARK, duration, amplifier), (class_1297)attacker);
                } else {
                    target.method_37222(new class_1293(ModEffectsRegistry.RADIANT_MARK, 200, 0), (class_1297)attacker);
                }
            }
        }
        return super.method_7873(stack, target, attacker);
    }

    public void attack(class_1657 user) {
        if (user.method_37908().method_8608()) {
            return;
        }
        class_1309 target = this.locateRadiantMarkedTarget(user);
        if (target != null) {
            this.damageAndKnockbackAndTeleportToRadiantMarkedTarget(target, user);
            this.damageAndKnockbackNearbyNonRadiantMarkedEntities(target, user);
            user.method_6092(new class_1293(ModEffectsRegistry.STUNNED_MOXIE, effect.getRadiantTeleportStunTime(), 0));
            user.method_37908().method_45447(null, user.method_24515(), (class_3414)SoundRegistry.ELEMENTAL_SWORD_ICE_ATTACK_01.get(), class_3419.field_15248);
            user.method_7357().method_7906(this.method_7854().method_7909(), this.skillCooldown);
        }
    }

    private class_1309 locateRadiantMarkedTarget(class_1657 user) {
        int boxRange = effect.getRadiantTeleportRange();
        class_238 box = new class_238(user.method_23317() - (double)boxRange, user.method_23318() - (double)boxRange, user.method_23321() - (double)boxRange, user.method_23317() + (double)boxRange, user.method_23318() + (double)boxRange, user.method_23321() + (double)boxRange);
        List potentiallyMarkedLivingEntities = user.method_37908().method_18467(class_1309.class, box);
        class_1309 markedEntity = potentiallyMarkedLivingEntities.stream().filter(livingEntity -> livingEntity.method_6059(ModEffectsRegistry.RADIANT_MARK)).findAny().orElse(null);
        if (markedEntity == null || markedEntity == user || markedEntity.method_5722((class_1297)user)) {
            return null;
        }
        return markedEntity;
    }

    private void damageAndKnockbackAndTeleportToRadiantMarkedTarget(class_1309 targetEntity, class_1657 user) {
        if (targetEntity == user.method_6052()) {
            user.method_6082(targetEntity.method_23317(), targetEntity.method_23318(), targetEntity.method_23321(), false);
            ((class_3218)user.method_37908()).method_14199((class_2394)class_2398.field_29643, user.method_23317(), user.method_23318() + 2.0, user.method_23321(), 500, 3.0, 3.0, 3.0, 0.0);
            targetEntity.method_6016(ModEffectsRegistry.RADIANT_MARK);
            this.knockbackAndDamageEntity(targetEntity, user, effect.getRadiantTeleportTargetDamage());
        }
    }

    private void damageAndKnockbackNearbyNonRadiantMarkedEntities(class_1309 targetEntity, class_1657 user) {
        int boxRange = effect.getRadiantTeleportAOERange();
        class_238 box = new class_238(user.method_23317() - (double)boxRange, user.method_23318() - (double)boxRange, user.method_23321() - (double)boxRange, user.method_23317() + (double)boxRange, user.method_23318() + (double)boxRange, user.method_23321() + (double)boxRange);
        List nearbyLivingEntities = user.method_37908().method_18467(class_1309.class, box);
        nearbyLivingEntities.remove(targetEntity);
        for (class_1309 livingEntity : nearbyLivingEntities) {
            this.knockbackAndDamageEntity(livingEntity, user, effect.getRadiantTeleportAOEDamage());
        }
    }

    private void knockbackAndDamageEntity(class_1309 targetEntity, class_1657 user, float damage) {
        if (targetEntity == user || targetEntity.method_5722((class_1297)user)) {
            return;
        }
        targetEntity.method_5643(user.method_48923().method_48802(user), damage);
        class_243 userPosition = user.method_19538();
        class_243 entityPosition = targetEntity.method_19538();
        double deltaX = entityPosition.method_10216() - userPosition.method_10216();
        double deltaZ = entityPosition.method_10215() - userPosition.method_10215();
        double distance = Math.hypot(deltaX, deltaZ);
        if (distance == 0.0) {
            return;
        }
        double normalizedDeltaX = deltaX / distance;
        double normalizedDeltaZ = deltaZ / distance;
        targetEntity.method_18800(normalizedDeltaX * (double)effect.getRadiantTeleportAOEKnockback(), 0.2, normalizedDeltaZ * (double)effect.getRadiantTeleportAOEKnockback());
        targetEntity.field_6037 = true;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        user.method_6019(hand);
        return itemStack.method_7919() >= itemStack.method_7936() - 1 ? class_1271.method_22431((Object)itemStack) : class_1271.method_22428((Object)itemStack);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (!user.method_37908().field_9236 && user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            if (remainingUseTicks == 1) {
                this.attack(player);
            }
        }
        super.method_7852(world, user, stack, remainingUseTicks);
    }

    public int method_7881(class_1799 stack) {
        return 15;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8951;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, class_2398.field_29643);
        super.method_7888(stack, world, entity, slot, selected);
    }

    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        class_2583 rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        class_2583 abilityStyle = HelperMethods.getStyle((String)"ability");
        class_2583 textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip1").method_10862(abilityStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip2").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip3").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip4").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip5").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip6").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.onrightclickheld").method_10862(rightClickStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip7").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip8").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip9").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip10").method_10862(textStyle));
        super.method_7851(itemStack, world, tooltip, tooltipContext);
    }
}

