/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.npc;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.serialization.codec.CommentedCodec;
import corgitaco.corgilib.serialization.jankson.JanksonJsonOps;
import corgitaco.corgilib.shadow.blue.endless.jankson.Jankson;
import corgitaco.corgilib.shadow.blue.endless.jankson.JsonElement;
import corgitaco.corgilib.shadow.blue.endless.jankson.JsonGrammar;
import corgitaco.corgilib.shadow.blue.endless.jankson.JsonObject;
import corgitaco.corgilib.shadow.blue.endless.jankson.api.SyntaxError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import net.potionstudios.biomeswevegone.PlatformHandler;
import org.jetbrains.annotations.NotNull;

public record BWGTradesConfig(boolean enableTrades, boolean enableVanillaTradeAdditions) {
    private static final Path PATH = PlatformHandler.PLATFORM_HANDLER.configPath().resolve("trades.json5");
    @NotNull
    public static Supplier<BWGTradesConfig> INSTANCE = Suppliers.memoize(BWGTradesConfig::getOrCreateConfigFromDisk);
    private static final Codec<BWGTradesConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CommentedCodec.of((Codec)Codec.BOOL, (String)"enable_trades", (String)"Whether to enable BWG Villager Trades").orElse((Object)true).forGetter(config -> true), (App)CommentedCodec.of((Codec)Codec.BOOL, (String)"enable_vanilla_trade_additions", (String)"Whether to add BWG Villager Trades to Vanilla Villagers").orElse((Object)true).forGetter(config -> true)).apply((Applicative)instance, BWGTradesConfig::new));

    private static BWGTradesConfig createDefault() {
        return new BWGTradesConfig(true, true);
    }

    private static BWGTradesConfig getOrCreateConfigFromDisk() {
        BWGTradesConfig defaultConfig = BWGTradesConfig.createDefault();
        if (!PATH.toFile().exists()) {
            BWGTradesConfig.createDefaultFile(defaultConfig);
            return defaultConfig;
        }
        Jankson build = new Jankson.Builder().build();
        try {
            String configFile = Files.readString(PATH).stripTrailing().trim().strip().stripLeading();
            JsonObject load = build.load(configFile);
            Pair configResult = (Pair)CODEC.decode((DynamicOps)JanksonJsonOps.INSTANCE, (Object)load).result().orElseThrow();
            BWGTradesConfig config = (BWGTradesConfig)configResult.getFirst();
            BWGTradesConfig toCreate = new BWGTradesConfig(config.enableTrades, config.enableVanillaTradeAdditions);
            BWGTradesConfig.createDefaultFile(toCreate);
            return toCreate;
        }
        catch (SyntaxError | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void createDefaultFile(BWGTradesConfig tradesConfig) {
        JsonElement jsonElement = (JsonElement)CODEC.encodeStart((DynamicOps)JanksonJsonOps.INSTANCE, (Object)tradesConfig).result().orElseThrow();
        String json = jsonElement.toJson(JsonGrammar.JSON5);
        try {
            Files.createDirectories(PATH.getParent(), new FileAttribute[0]);
            Files.writeString(PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

