/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.plateau;

import corgitaco.corgilib.math.blendingfunction.BlendingFunction;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3532;
import net.minecraft.class_3541;
import net.minecraft.class_3756;
import net.minecraft.class_4651;
import net.minecraft.class_5138;
import net.minecraft.class_5216;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6581;
import net.minecraft.class_6625;
import net.minecraft.class_6677;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructurePieceTypes;
import org.jetbrains.annotations.NotNull;

public class GourPlateauPiece
extends class_3443 {
    private final class_2338 origin;
    private final int radius;
    private final int topY;

    protected GourPlateauPiece(class_2338 origin, int radius, int topY, class_3341 boundingBox) {
        super(BWGStructurePieceTypes.GOUR_PLATEAU_PIECE.get(), 0, boundingBox);
        this.origin = origin;
        this.radius = radius;
        this.topY = topY;
    }

    public GourPlateauPiece(class_6625 context, class_2487 tag) {
        super(BWGStructurePieceTypes.GOUR_PLATEAU_PIECE.get(), tag);
        this.origin = class_2512.method_10691((class_2487)tag.method_10562("origin"));
        this.radius = tag.method_10550("radius");
        this.topY = tag.method_10550("topY");
    }

    protected void method_14943(@NotNull class_6625 context, class_2487 tag) {
        tag.method_10566("origin", (class_2520)class_2512.method_10692((class_2338)this.origin));
        tag.method_10569("radius", this.radius);
        tag.method_10569("topY", this.topY);
    }

    public void method_14931(class_5281 worldGenLevel, @NotNull class_5138 structureManager, @NotNull class_2794 generator, @NotNull class_5819 random, @NotNull class_3341 box, @NotNull class_1923 chunkPos, @NotNull class_2338 pos) {
        int blockZ;
        int blockX;
        int z;
        int x;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_6677 randomSource = new class_6677(worldGenLevel.method_8412() + this.origin.method_10063());
        class_3756 noiseSampler = new class_3756((class_5819)randomSource);
        class_3541 simplexNoise = new class_3541((class_5819)randomSource);
        double minRadius = (double)this.radius * 0.175;
        int plateauThickness = randomSource.method_39332(0, 2);
        int plateauSurfacePull = randomSource.method_39332(1, 3);
        int[] topYs = new int[256];
        int[] bottomYs = new int[256];
        Arrays.fill(topYs, Integer.MIN_VALUE);
        Arrays.fill(bottomYs, Integer.MAX_VALUE);
        class_6581 noiseBasedStateProvider = new class_6581(worldGenLevel.method_8412() + this.origin.method_10063(), new class_5216.class_5487(0, 1.0, new double[0]), 0.05f, -0.1f, 0.5f, class_2246.field_10474.method_9564(), List.of(class_2246.field_37556.method_9564()), List.of(class_2246.field_10253.method_9564()));
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                blockX = chunkPos.method_33939(x);
                blockZ = chunkPos.method_33941(z);
                int range = this.topY - this.origin.method_10264();
                mutable.method_10103(blockX, 0, blockZ);
                double noise = noiseSampler.method_33658((double)blockX * 0.05, 0.0, (double)blockZ * 0.05) + 1.0;
                int minY = Math.min(worldGenLevel.method_8624(class_2902.class_2903.field_13195, blockX, blockZ) - 1, this.origin.method_10264());
                int idx = x + z * 16;
                this.buildColumn(worldGenLevel, minRadius, minY, this.topY - minY, mutable, blockX, blockZ, noise, topYs, bottomYs, idx, (class_5819)randomSource, (class_4651)noiseBasedStateProvider);
                this.thickenPlateau(worldGenLevel, minRadius, mutable, blockX, range, blockZ, noise, plateauThickness, topYs, bottomYs, idx, (class_5819)randomSource, (class_4651)noiseBasedStateProvider);
                this.pullUpPlateau(worldGenLevel, minRadius, range, mutable, blockX, blockZ, noise, plateauThickness, plateauSurfacePull, topYs, bottomYs, idx, (class_5819)randomSource, (class_4651)noiseBasedStateProvider);
                this.buildPlateauTerrain(worldGenLevel, minRadius, range, mutable, blockX, blockZ, noise, simplexNoise, plateauThickness, plateauSurfacePull, topYs, bottomYs, idx, (class_5819)randomSource, (class_4651)noiseBasedStateProvider);
            }
        }
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                blockX = chunkPos.method_33939(x);
                blockZ = chunkPos.method_33941(z);
                int idx = x + z * 16;
                int topY = topYs[idx];
                if (topY == Integer.MIN_VALUE) continue;
                mutable.method_10103(blockX, topY, blockZ);
                if (!worldGenLevel.method_8320((class_2338)mutable.method_10098(class_2350.field_11033)).method_26215()) {
                    mutable.method_10098(class_2350.field_11036);
                    worldGenLevel.method_8652((class_2338)mutable, class_2246.field_10219.method_9564(), 2);
                }
                mutable.method_10098(class_2350.field_11033);
                if (worldGenLevel.method_8320((class_2338)mutable.method_10098(class_2350.field_11033)).method_26215()) continue;
                mutable.method_10098(class_2350.field_11036);
                worldGenLevel.method_8652((class_2338)mutable, class_2246.field_10566.method_9564(), 2);
            }
        }
    }

    private void buildPlateauTerrain(class_5281 worldGenLevel, double minRadius, int range, class_2338.class_2339 mutable, int blockX, int blockZ, double noise, class_3541 simplexNoise, int plateauThickness, int plateauSurfacePull, int[] topYs, int[] bottomYs, int idx, class_5819 randomSource, class_4651 stateProvider) {
        double factor = class_3532.method_15350((double)((double)(range - 1 - plateauThickness - plateauSurfacePull) / (double)range), (double)0.0, (double)1.0);
        double radiusFactor = class_3532.method_15390((double)-0.5, (double)1.0, (double)factor);
        mutable.method_10103(blockX, this.origin.method_10264() + plateauThickness + range + plateauSurfacePull - 1, blockZ);
        double delta = noise * 0.5;
        double amplifiedDelta = class_3532.method_15390((double)0.2, (double)1.0, (double)BlendingFunction.EaseOutQuint.INSTANCE.apply(delta));
        int localRadius = (int)(BlendingFunction.EaseInCirc.INSTANCE.apply(radiusFactor, minRadius, (double)this.radius) * amplifiedDelta);
        class_2338 offsetOrigin = this.origin.method_10069(0, plateauThickness + range + plateauSurfacePull, 0);
        if (offsetOrigin.method_19771((class_2382)mutable, (double)localRadius)) {
            double simplexNoiseValue = simplexNoise.method_15433((double)blockX * 0.007, (double)blockZ * 0.007) + 1.0;
            double maxNoiseY = simplexNoiseValue * 2.0;
            double noiseFactor = class_3532.method_15350((double)(mutable.method_10262((class_2382)offsetOrigin) / (double)class_3532.method_34954((int)localRadius)), (double)0.0, (double)1.0);
            double apply = BlendingFunction.EaseOutCubic.INSTANCE.apply(1.0 - noiseFactor, 0.0, maxNoiseY);
            int noiseY = 0;
            while ((double)noiseY <= apply) {
                mutable.method_10098(class_2350.field_11036);
                worldGenLevel.method_8652((class_2338)mutable, stateProvider.method_23455(randomSource, (class_2338)mutable), 2);
                topYs[idx] = Math.max(mutable.method_10264(), topYs[idx]);
                bottomYs[idx] = Math.max(mutable.method_10264(), bottomYs[idx]);
                ++noiseY;
            }
        }
    }

    private void pullUpPlateau(class_5281 worldGenLevel, double minRadius, int range, class_2338.class_2339 mutable, int blockX, int blockZ, double noise, int plateauThickness, int plateauSurfacePull, int[] topYs, int[] bottomYs, int idx, class_5819 randomSource, class_4651 stateProvider) {
        for (int y = 0; y < plateauSurfacePull; ++y) {
            double factor = class_3532.method_15350((double)((double)(range - 2 - y) / (double)range), (double)0.0, (double)1.0);
            double radiusFactor = class_3532.method_15390((double)-0.5, (double)1.0, (double)factor);
            mutable.method_10103(blockX, this.origin.method_10264() + y + range + plateauThickness, blockZ);
            double delta = noise * 0.5;
            double amplifiedDelta = class_3532.method_15390((double)0.2, (double)1.0, (double)BlendingFunction.EaseOutQuint.INSTANCE.apply(delta));
            int localRadius = (int)(BlendingFunction.EaseInCirc.INSTANCE.apply(radiusFactor, minRadius, (double)this.radius) * amplifiedDelta);
            if (!this.origin.method_10069(0, y + range + plateauThickness, 0).method_19771((class_2382)mutable, (double)localRadius)) continue;
            worldGenLevel.method_8652((class_2338)mutable, stateProvider.method_23455(randomSource, (class_2338)mutable), 2);
            topYs[idx] = Math.max(mutable.method_10264(), topYs[idx]);
            bottomYs[idx] = Math.max(mutable.method_10264(), bottomYs[idx]);
            mutable.method_33098(this.origin.method_10264());
        }
    }

    private void thickenPlateau(class_5281 worldGenLevel, double minRadius, class_2338.class_2339 mutable, int blockX, int range, int blockZ, double noise, int plateauThickness, int[] topYs, int[] bottomYs, int idx, class_5819 randomSource, class_4651 stateProvider) {
        double factor = class_3532.method_15350((double)((double)(range - 1) / (double)range), (double)0.0, (double)1.0);
        double radiusFactor = class_3532.method_15390((double)-0.5, (double)1.0, (double)factor);
        double delta = noise * 0.5;
        double amplifiedDelta = class_3532.method_15390((double)0.2, (double)1.0, (double)BlendingFunction.EaseOutQuint.INSTANCE.apply(delta));
        int localRadius = (int)(BlendingFunction.EaseInCirc.INSTANCE.apply(radiusFactor, minRadius, (double)this.radius) * amplifiedDelta);
        for (int y = 0; y < plateauThickness; ++y) {
            mutable.method_10103(blockX, this.origin.method_10264() + y + range, blockZ);
            if (!this.origin.method_10069(0, y + range, 0).method_19771((class_2382)mutable, (double)localRadius)) continue;
            worldGenLevel.method_8652((class_2338)mutable, stateProvider.method_23455(randomSource, (class_2338)mutable), 2);
            topYs[idx] = Math.max(mutable.method_10264(), topYs[idx]);
            bottomYs[idx] = Math.max(mutable.method_10264(), bottomYs[idx]);
            mutable.method_33098(this.origin.method_10264());
        }
    }

    private void buildColumn(class_5281 worldGenLevel, double minRadius, int minY, int range, class_2338.class_2339 mutable, int blockX, int blockZ, double noise, int[] topYs, int[] bottomYs, int idx, class_5819 randomSource, class_4651 stateProvider) {
        for (int y = 0; y < range; ++y) {
            double factor = class_3532.method_15350((double)((double)y / (double)range), (double)0.0, (double)1.0);
            double radiusFactor = class_3532.method_15390((double)-0.5, (double)1.0, (double)factor);
            mutable.method_10103(blockX, minY + y, blockZ);
            double delta = noise * 0.5;
            double amplifiedDelta = class_3532.method_15390((double)0.2, (double)1.0, (double)BlendingFunction.EaseOutQuint.INSTANCE.apply(delta));
            int localRadius = (int)(BlendingFunction.EaseInCirc.INSTANCE.apply(radiusFactor, minRadius, (double)this.radius) * amplifiedDelta);
            if (!this.origin.method_33096(minY).method_10069(0, y, 0).method_19771((class_2382)mutable, (double)localRadius)) continue;
            worldGenLevel.method_8652((class_2338)mutable, stateProvider.method_23455(randomSource, (class_2338)mutable), 2);
            topYs[idx] = Math.max(mutable.method_10264(), topYs[idx]);
            bottomYs[idx] = Math.max(mutable.method_10264(), bottomYs[idx]);
            mutable.method_33098(minY);
        }
    }
}

