/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.plateau;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3756;
import net.minecraft.class_4076;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_6677;
import net.minecraft.class_7138;
import net.minecraft.class_7151;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructureTypes;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.plateau.GourPlateauPiece;
import org.jetbrains.annotations.NotNull;

public class GourPlateauStructure
extends class_3195 {
    public static final Codec<GourPlateauStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)GourPlateauStructure.method_42697((RecordCodecBuilder.Instance)builder)).apply((Applicative)builder, GourPlateauStructure::new)).codec();

    public GourPlateauStructure(class_3195.class_7302 settings) {
        super(settings);
    }

    @NotNull
    protected Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_1923 chunkPos = context.comp_568();
        class_2919 random = context.comp_566();
        int blockX = chunkPos.method_33939(random.method_43048(16));
        int blockZ = chunkPos.method_33941(random.method_43048(16));
        float twoPi = (float)Math.PI * 2;
        int slices = 20;
        double sliceSize = twoPi / (float)slices;
        int plateauRadius = random.method_39332(48, 96);
        int sampleY = class_5742.method_33100((int)context.comp_562().method_16398());
        int minPlateauRadius = 16;
        boolean shouldCancel = true;
        for (int modifiedPlateauRadius = plateauRadius; modifiedPlateauRadius >= minPlateauRadius; modifiedPlateauRadius -= 4) {
            boolean success = true;
            for (int i = 0; i <= slices; ++i) {
                double angle = (double)i * sliceSize;
                int offsetX = (int)Math.round(Math.sin(angle) * (double)modifiedPlateauRadius);
                int offsetZ = (int)Math.round(Math.cos(angle) * (double)modifiedPlateauRadius);
                if (context.comp_570().test(context.comp_563().method_38109(class_5742.method_33100((int)(blockX + offsetX)), sampleY, class_5742.method_33100((int)(blockZ + offsetZ)), context.comp_564().method_42371()))) continue;
                success = false;
                break;
            }
            if (!success) continue;
            plateauRadius = modifiedPlateauRadius - 4;
            shouldCancel = false;
            break;
        }
        if (shouldCancel) {
            return Optional.empty();
        }
        int finalPlateauRadius = plateauRadius;
        return GourPlateauStructure.method_41612((class_3195.class_7149)context, (class_2902.class_2903)class_2902.class_2903.field_13195, piecesBuilder -> {
            class_7138 randomState = context.comp_564();
            class_2794 chunkGenerator = context.comp_562();
            class_2919 worldgenRandom = new class_2919((class_5819)new class_6677(context.comp_567()));
            class_3756 noiseSampler = new class_3756((class_5819)worldgenRandom);
            class_5539 levelHeightAccessor = context.comp_569();
            class_2338 plateauOrigin = new class_2338(blockX, chunkGenerator.method_16397(blockX, blockZ, class_2902.class_2903.field_13195, levelHeightAccessor, randomState) - 10, blockZ);
            double noise = noiseSampler.method_33658((double)plateauOrigin.method_10263() * 5.0E-4, 0.0, (double)plateauOrigin.method_10260() * 5.0E-4) + 1.0;
            double height = (int)((noise *= 0.5) * 100.0);
            GourPlateauStructure.createArenaFloor(context, piecesBuilder, finalPlateauRadius, plateauOrigin, (int)height + chunkGenerator.method_16398(), levelHeightAccessor);
        });
    }

    private static void createArenaFloor(class_3195.class_7149 context, class_6626 piecesBuilder, int arenaFloorRadius, class_2338 arenaOrigin, int topY, class_5539 levelHeightAccessor) {
        for (int chunkX = -(class_4076.method_18675((int)arenaFloorRadius) + 1); chunkX <= class_4076.method_18675((int)arenaFloorRadius) + 1; ++chunkX) {
            for (int chunkZ = -(class_4076.method_18675((int)arenaFloorRadius) + 1); chunkZ <= class_4076.method_18675((int)arenaFloorRadius) + 1; ++chunkZ) {
                class_2338 chunkWorldPos = new class_2338(class_4076.method_18688((int)(context.comp_568().field_9181 + chunkX)), arenaOrigin.method_10264(), class_4076.method_18688((int)(context.comp_568().field_9180 + chunkZ)));
                class_3341 boundingBox = new class_3341(chunkWorldPos.method_10263(), levelHeightAccessor.method_31607(), chunkWorldPos.method_10260(), chunkWorldPos.method_10263() + 15, levelHeightAccessor.method_31600(), chunkWorldPos.method_10260() + 15);
                piecesBuilder.method_35462((class_3443)new GourPlateauPiece(arenaOrigin, arenaFloorRadius, topY, boundingBox));
            }
        }
    }

    @NotNull
    public class_7151<?> method_41618() {
        return BWGStructureTypes.OVERHANG_PLATEAU.get();
    }
}

