/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import dev.corgitaco.ohthetreesyoullgrow.world.level.chunk.RandomTickScheduler;
import dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.TreeFromStructureNBTConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3746;
import net.minecraft.class_4651;
import net.minecraft.class_4662;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6646;
import org.jetbrains.annotations.NotNull;

public class TreeFromStructureNBTFeature
extends class_3031<TreeFromStructureNBTConfig> {
    private static final boolean DEBUG = false;

    public TreeFromStructureNBTFeature(Codec<TreeFromStructureNBTConfig> $$0) {
        super($$0);
    }

    public boolean method_13151(class_5821<TreeFromStructureNBTConfig> featurePlaceContext) {
        TreeFromStructureNBTConfig config = (TreeFromStructureNBTConfig)featurePlaceContext.method_33656();
        class_4651 logProvider = config.logProvider();
        class_4651 leavesProvider = config.leavesProvider();
        class_5281 level = featurePlaceContext.method_33652();
        class_3485 templateManager = level.method_8410().method_14183();
        class_2960 baseLocation = config.baseLocation();
        Optional baseTemplateOptional = templateManager.method_15094(baseLocation);
        class_2960 canopyLocation = config.canopyLocation();
        Optional canopyTemplateOptional = templateManager.method_15094(canopyLocation);
        if (baseTemplateOptional.isEmpty()) {
            throw TreeFromStructureNBTFeature.noTreePartPresent(baseLocation);
        }
        if (canopyTemplateOptional.isEmpty()) {
            throw TreeFromStructureNBTFeature.noTreePartPresent(canopyLocation);
        }
        class_3499 baseTemplate = (class_3499)baseTemplateOptional.get();
        class_3499 canopyTemplate = (class_3499)canopyTemplateOptional.get();
        List basePalettes = baseTemplate.field_15586;
        List canopyPalettes = canopyTemplate.field_15586;
        class_2338 origin = featurePlaceContext.method_33655();
        class_5819 random = featurePlaceContext.method_33654();
        class_3492 placeSettings = new class_3492().method_15123(class_2470.method_16548((class_5819)random));
        class_3499.class_5162 trunkBasePalette = placeSettings.method_15121(basePalettes, origin);
        class_3499.class_5162 randomCanopyPalette = placeSettings.method_15121(canopyPalettes, origin);
        List center = trunkBasePalette.method_27126(class_2246.field_10446);
        if (center.isEmpty()) {
            throw new IllegalArgumentException("No trunk central position was specified for structure NBT palette %s. Trunk central position is specified with white wool.".formatted(config.baseLocation()));
        }
        if (center.size() > 1) {
            throw new IllegalArgumentException("There cannot be more than one trunk central position for structure NBT palette %s. Trunk central position is specified with white wool.".formatted(config.baseLocation()));
        }
        class_2338 centerOffset = ((class_3499.class_3501)center.get(0)).comp_1341();
        centerOffset = new class_2338(-centerOffset.method_10263(), 0, -centerOffset.method_10260());
        List<class_3499.class_3501> logs = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.logTarget(), trunkBasePalette);
        List logBuilders = trunkBasePalette.method_27126(class_2246.field_10314);
        if (logBuilders.isEmpty()) {
            throw new UnsupportedOperationException(String.format("\"%s\" is missing log builders.", baseLocation));
        }
        HashSet<class_2338> leavePositions = new HashSet<class_2338>();
        HashSet<class_2338> trunkPositions = new HashSet<class_2338>();
        int trunkLength = config.height().method_35008(random);
        int maxTrunkBuildingDepth = config.maxLogDepth();
        for (class_3499.class_3501 logBuilder : logBuilders) {
            class_2338 pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            if (TreeFromStructureNBTFeature.isOnGround(config.maxLogDepth(), level, pos, config.growableOn())) continue;
            return false;
        }
        TreeFromStructureNBTFeature.placeTrunk(config, logProvider, leavesProvider, level, origin, random, placeSettings, trunkBasePalette, centerOffset, logs, logBuilders, leavePositions, trunkPositions, maxTrunkBuildingDepth);
        List canopyAnchor = trunkBasePalette.method_27126(class_2246.field_10490);
        if (!canopyAnchor.isEmpty()) {
            if (canopyAnchor.size() > 1) {
                throw new IllegalArgumentException("There cannot be more than one central canopy position. Canopy central position is specified with yellow wool on the trunk palette.");
            }
            TreeFromStructureNBTFeature.placeCanopy(config, logProvider, leavesProvider, level, TreeFromStructureNBTFeature.getModifiedPos(placeSettings, (class_3499.class_3501)canopyAnchor.get(0), centerOffset, origin), random, placeSettings, randomCanopyPalette, leavePositions, trunkPositions, trunkLength, config.growableOn());
        } else {
            TreeFromStructureNBTFeature.placeCanopy(config, logProvider, leavesProvider, level, origin, random, placeSettings, randomCanopyPalette, leavePositions, trunkPositions, trunkLength, config.growableOn());
        }
        TreeFromStructureNBTFeature.placeTreeDecorations(config.treeDecorators(), level, random, leavePositions, trunkPositions);
        return true;
    }

    public static void placeAdditional(TreeFromStructureNBTConfig config, class_5281 level, class_2338 origin, class_3492 placeSettings, class_3499.class_5162 palette, class_2338 centerOffset) {
        List<class_3499.class_3501> additionalBlocks = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.placeFromNBT(), palette);
        for (class_3499.class_3501 additionalBlock : additionalBlocks) {
            class_2338 pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, additionalBlock, centerOffset, origin);
            level.method_8652(pos, additionalBlock.comp_1342(), 2);
        }
    }

    public static void placeTrunk(TreeFromStructureNBTConfig config, class_4651 logProvider, class_4651 leavesProvider, class_5281 level, class_2338 origin, class_5819 random, class_3492 placeSettings, class_3499.class_5162 trunkBasePalette, class_2338 centerOffset, List<class_3499.class_3501> logs, List<class_3499.class_3501> logBuilders, Set<class_2338> leavePositions, Set<class_2338> trunkPositions, int maxTrunkBuildingDepth) {
        TreeFromStructureNBTFeature.fillLogsUnder(random, logProvider, level, origin, placeSettings, centerOffset, logBuilders, maxTrunkBuildingDepth, config.growableOn());
        TreeFromStructureNBTFeature.placeLogsWithRotation(logProvider, level, origin, random, placeSettings, centerOffset, logs, trunkPositions);
        TreeFromStructureNBTFeature.placeLeavesWithCalculatedDistanceAndRotation(leavesProvider, level, origin, random, placeSettings, TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.leavesTarget(), trunkBasePalette), leavePositions, centerOffset, config.leavesPlacementFilter());
        TreeFromStructureNBTFeature.placeAdditional(config, level, origin, placeSettings, trunkBasePalette, centerOffset);
    }

    public static void placeCanopy(TreeFromStructureNBTConfig config, class_4651 logProvider, class_4651 leavesProvider, class_5281 level, class_2338 origin, class_5819 random, class_3492 placeSettings, class_3499.class_5162 randomCanopyPalette, Set<class_2338> leavePositions, Set<class_2338> trunkPositions, int trunkLength, class_6646 groundFilter) {
        List<class_3499.class_3501> leaves = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.leavesTarget(), randomCanopyPalette);
        List<class_3499.class_3501> canopyLogs = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.logTarget(), randomCanopyPalette);
        List canopyAnchor = randomCanopyPalette.method_27126(class_2246.field_10446);
        if (canopyAnchor.isEmpty()) {
            throw new IllegalArgumentException("No canopy anchor was specified for structure NBT palette %s. Canopy anchor is specified with white wool.".formatted(config.canopyLocation()));
        }
        if (canopyAnchor.size() > 1) {
            throw new IllegalArgumentException("There cannot be more than one canopy anchor for structure NBT palette %s. Canopy anchor is specified with white wool.".formatted(config.canopyLocation()));
        }
        class_3499.class_3501 structureBlockInfo = (class_3499.class_3501)canopyAnchor.get(0);
        class_2338 canopyCenterOffset = structureBlockInfo.comp_1341();
        canopyCenterOffset = new class_2338(-canopyCenterOffset.method_10263(), trunkLength, -canopyCenterOffset.method_10260());
        ArrayList<class_3499.class_3501> trunkFillers = new ArrayList<class_3499.class_3501>(randomCanopyPalette.method_27126(class_2246.field_10314));
        TreeFromStructureNBTFeature.fillLogsUnder(random, logProvider, level, origin, placeSettings, canopyCenterOffset, trunkFillers, level.method_31605(), groundFilter);
        TreeFromStructureNBTFeature.placeLogsWithRotation(logProvider, level, origin, random, placeSettings, canopyCenterOffset, canopyLogs, trunkPositions);
        TreeFromStructureNBTFeature.placeLeavesWithCalculatedDistanceAndRotation(leavesProvider, level, origin, random, placeSettings, leaves, leavePositions, canopyCenterOffset, config.leavesPlacementFilter());
        TreeFromStructureNBTFeature.placeAdditional(config, level, origin, placeSettings, randomCanopyPalette, canopyCenterOffset);
    }

    public static void placeLogsWithRotation(class_4651 logProvider, class_5281 level, class_2338 origin, class_5819 random, class_3492 placeSettings, class_2338 centerOffset, List<class_3499.class_3501> logs, Set<class_2338> trunkPositions) {
        for (class_3499.class_3501 trunk : logs) {
            class_2338 pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, trunk, centerOffset, origin);
            level.method_8652(pos, TreeFromStructureNBTFeature.getTransformedState(pos, logProvider.method_23455(random, pos), trunk.comp_1342(), placeSettings.method_15113(), level), 2);
            trunkPositions.add(pos);
        }
    }

    public static void placeTreeDecorations(Iterable<class_4662> treeDecorators, class_5281 level, class_5819 random, Set<class_2338> leavePositions, Set<class_2338> trunkPositions) {
        for (class_4662 treeDecorator : treeDecorators) {
            treeDecorator.method_23469(new class_4662.class_7402((class_3746)level, (pos, state) -> level.method_8652(pos, state, 2), random, trunkPositions, leavePositions, new HashSet()));
        }
    }

    public static void placeLeavesWithCalculatedDistanceAndRotation(class_4651 leavesProvider, class_5281 level, class_2338 origin, class_5819 random, class_3492 placeSettings, List<class_3499.class_3501> leaves, Set<class_2338> leavePositions, class_2338 canopyCenterOffset, class_6646 leavesPlacementFilter) {
        ArrayList<Runnable> leavesPostApply = new ArrayList<Runnable>(leaves.size());
        for (class_3499.class_3501 leaf : leaves) {
            class_2338 modifiedPos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, leaf, canopyCenterOffset, origin);
            if (!leavesPlacementFilter.test((Object)level, (Object)modifiedPos)) continue;
            class_2680 state = TreeFromStructureNBTFeature.getTransformedState(modifiedPos, leavesProvider.method_23455(random, modifiedPos), leaf.comp_1342(), placeSettings.method_15113(), level);
            level.method_8652(modifiedPos, state, 2);
            class_2680 finalState = state;
            if (state.method_28498((class_2769)class_2397.field_11199)) {
                Runnable postProcess = () -> {
                    class_2680 blockState = class_2397.method_10300((class_2680)finalState, (class_1936)level, (class_2338)modifiedPos);
                    if ((Integer)blockState.method_11654((class_2769)class_2397.field_11199) < 7) {
                        leavePositions.add(modifiedPos);
                        if (blockState.method_28498((class_2769)class_2397.field_11200)) {
                            blockState = (class_2680)blockState.method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.valueOf(false));
                        }
                        level.method_8652(modifiedPos, blockState, 2);
                        level.method_39279(modifiedPos, blockState.method_26204(), 0);
                    } else {
                        level.method_8650(modifiedPos, false);
                    }
                };
                leavesPostApply.add(postProcess);
                continue;
            }
            leavePositions.add(modifiedPos);
        }
        leavesPostApply.forEach(Runnable::run);
    }

    public static void fillLogsUnder(class_5819 randomSource, class_4651 logProvider, class_5281 level, class_2338 origin, class_3492 placeSettings, class_2338 centerOffset, List<class_3499.class_3501> logBuilders, int maxTrunkBuildingDepth, class_6646 groundFilter) {
        block0: for (class_3499.class_3501 logBuilder : logBuilders) {
            class_2338 pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339().method_10101((class_2382)pos);
            for (int i = 0; i < maxTrunkBuildingDepth; ++i) {
                if (!groundFilter.test((Object)level, (Object)mutableBlockPos)) {
                    if (level instanceof class_1937) {
                        level.method_8650((class_2338)mutableBlockPos, true);
                    }
                } else {
                    ((RandomTickScheduler)level.method_22350((class_2338)mutableBlockPos)).scheduleRandomTick(mutableBlockPos.method_10062());
                    continue block0;
                }
                class_2680 state = logProvider.method_23455(randomSource, (class_2338)mutableBlockPos);
                state = class_2248.method_9510((class_2680)state, (class_1936)level, (class_2338)mutableBlockPos);
                level.method_8652((class_2338)mutableBlockPos, state, 2);
                mutableBlockPos.method_10098(class_2350.field_11033);
            }
        }
    }

    @NotNull
    public static class_2680 getTransformedState(class_2338 modifiedPos, class_2680 state, class_2680 nbtState, class_2470 rotation, class_5281 level) {
        for (class_2769 property : state.method_28501()) {
            if (!nbtState.method_28498(property)) continue;
            Comparable value = nbtState.method_11654(property);
            state = (class_2680)state.method_11657(property, value);
        }
        if (state.method_28498((class_2769)class_2397.field_38227)) {
            class_3610 fluidState = level.method_8316(modifiedPos);
            state = fluidState.method_39360((class_3611)class_3612.field_15910) && fluidState.method_15761() >= 7 ? (class_2680)state.method_11657((class_2769)class_2397.field_38227, (Comparable)Boolean.valueOf(true)) : (class_2680)state.method_11657((class_2769)class_2397.field_38227, (Comparable)Boolean.valueOf(false));
        }
        state = state.method_26186(rotation);
        return state;
    }

    public static boolean isOnGround(int maxLogDepth, class_5281 level, class_2338 pos, class_6646 growableOn) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339().method_10101((class_2382)pos);
        for (int logDepth = 0; logDepth < maxLogDepth; ++logDepth) {
            mutableBlockPos.method_10098(class_2350.field_11033);
            if (!growableOn.test((Object)level, (Object)mutableBlockPos)) continue;
            return true;
        }
        return false;
    }

    public static class_2338 getModifiedPos(class_3492 settings, class_3499.class_3501 placing, class_2338 partCenter, class_2338 featureOrigin) {
        return class_3499.method_15171((class_3492)settings, (class_2338)placing.comp_1341()).method_10081((class_2382)featureOrigin).method_10081((class_2382)class_3499.method_15171((class_3492)settings, (class_2338)partCenter));
    }

    public static IllegalArgumentException noTreePartPresent(class_2960 location) {
        return new IllegalArgumentException(String.format("\"%s\" is not a valid tree part.", location));
    }

    public static List<class_3499.class_3501> getStructureInfosInStructurePalletteFromBlockList(Iterable<class_2248> blocks, class_3499.class_5162 palette) {
        ArrayList<class_3499.class_3501> result = new ArrayList<class_3499.class_3501>();
        for (class_2248 block : blocks) {
            result.addAll(palette.method_27126(block));
        }
        return result;
    }
}

