/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes;

import java.util.List;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1309;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.more_rpg_classes.client.particle.MoreParticles;
import net.more_rpg_classes.compat.CompatDatapackLoader;
import net.more_rpg_classes.config.EffectsConfig;
import net.more_rpg_classes.config.EnchantingConfig;
import net.more_rpg_classes.config.TweaksConfig;
import net.more_rpg_classes.custom.CustomSchoolEnchanting;
import net.more_rpg_classes.custom.Enchantment_CustomSpellSchool;
import net.more_rpg_classes.custom.MoreSpellSchools;
import net.more_rpg_classes.effect.MRPGCEffects;
import net.more_rpg_classes.item.MRPGCGroup;
import net.more_rpg_classes.item.MRPGCItems;
import net.more_rpg_classes.sounds.ModSounds;
import net.more_rpg_classes.util.loot.MRPGCLootTableEntityModifiers;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.spell_power.api.enchantment.SpellPowerEnchanting;
import net.tinyconfig.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MRPGCMod
implements ModInitializer {
    public static final String MOD_ID = "more_rpg_classes";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"more_rpg_classes");
    public static ConfigManager<EffectsConfig> effectsConfig = new ConfigManager("effects", (Object)new EffectsConfig()).builder().setDirectory("more_rpg_classes").sanitize(true).build();
    public static final ConfigManager<EnchantingConfig> enchantmentConfig = new ConfigManager("enchantments", (Object)new EnchantingConfig()).builder().setDirectory("more_rpg_classes").sanitize(true).schemaVersion(4).build();
    public static ConfigManager<TweaksConfig> tweaksConfig = new ConfigManager("tweaks_v1", (Object)new TweaksConfig()).builder().setDirectory("more_rpg_classes").sanitize(true).build();

    public void onInitialize() {
        effectsConfig.refresh();
        enchantmentConfig.refresh();
        tweaksConfig.refresh();
        MRPGCItems.registerModItems();
        MRPGCGroup.registerItemGroups();
        MRPGCLootTableEntityModifiers.modifyLootEntityTables();
        MRPGCEffects.register();
        CompatDatapackLoader.register();
        MoreParticles.register();
        ModSounds.register();
        MoreSpellSchools.initialize();
        for (Map.Entry<class_2960, CustomSchoolEnchanting> entry : Enchantment_CustomSpellSchool.all.entrySet()) {
            class_2378.method_10230((class_2378)class_7923.field_41176, (class_2960)entry.getKey(), (Object)((Object)entry.getValue()));
        }
        this.attachEnchantmentsToSchools();
    }

    private void attachEnchantmentsToSchools() {
        for (SpellSchool school : SpellSchools.all()) {
            List<CustomSchoolEnchanting> poweringEnchantments = Enchantment_CustomSpellSchool.all.entrySet().stream().filter(entry -> ((CustomSchoolEnchanting)((Object)((Object)entry.getValue()))).poweredSchools().contains(school)).map(Map.Entry::getValue).toList();
            school.addSource(SpellSchool.Trait.POWER, new SpellSchool.Source(SpellSchool.Apply.MULTIPLY, query -> {
                double value = 0.0;
                for (CustomSchoolEnchanting enchantment : poweringEnchantments) {
                    int level = SpellPowerEnchanting.getEnchantmentLevel((class_1887)enchantment, (class_1309)query.entity(), null);
                    value = enchantment.amplified(value, level);
                }
                return value;
            }));
        }
    }
}

