/*
 * Decompiled with CFR 0.152.
 */
package net.wiredtomato.waygl;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_3262;
import net.minecraft.class_7367;
import net.minecraft.class_8518;
import net.wiredtomato.waygl.WayGL;
import net.wiredtomato.waygl.XDG;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u001d\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0017\u001a\n \u0016*\u0004\u0018\u00010\r0\r2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\n \u0016*\u0004\u0018\u00010\r0\rH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0003R\u0014\u0010\u001d\u001a\u00020\u001c8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001c8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001eR\u0014\u0010 \u001a\u00020\u001c8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b \u0010\u001eR\u0014\u0010!\u001a\u00020\u001c8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b!\u0010\u001eR\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lnet/wiredtomato/waygl/IconInjector;", "", "<init>", "()V", "", "inject", "uninject", "Lnet/minecraft/class_3262;", "resourcePack", "Lnet/minecraft/class_8518;", "icons", "setIcon", "(Lnet/minecraft/class_3262;Lnet/minecraft/class_8518;)V", "Ljava/nio/file/Path;", "target", "", "data", "injectFile", "(Ljava/nio/file/Path;[B)V", "", "width", "height", "kotlin.jvm.PlatformType", "getIconFileLoc", "(II)Ljava/nio/file/Path;", "getDesktopFileLoc", "()Ljava/nio/file/Path;", "updateIconSys", "", "APP_ID", "Ljava/lang/String;", "ICON_NAME", "FILE_NAME", "LOCATION", "", "injects", "Ljava/util/List;", "waygl"})
@SourceDebugExtension(value={"SMAP\nIconInjector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IconInjector.kt\nnet/wiredtomato/waygl/IconInjector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1863#2,2:104\n1863#2,2:106\n*S KotlinDebug\n*F\n+ 1 IconInjector.kt\nnet/wiredtomato/waygl/IconInjector\n*L\n40#1:104,2\n53#1:106,2\n*E\n"})
public final class IconInjector {
    @NotNull
    public static final IconInjector INSTANCE = new IconInjector();
    @NotNull
    public static final String APP_ID = "com.mojang.minecraft";
    @NotNull
    private static final String ICON_NAME = "minecraft.png";
    @NotNull
    private static final String FILE_NAME = "com.mojang.minecraft.desktop";
    @NotNull
    private static final String LOCATION = "/assets/waygl/com.mojang.minecraft.desktop";
    @NotNull
    private static final List<Path> injects = new ArrayList();

    private IconInjector() {
    }

    public final void inject() {
        Object object;
        Runtime.getRuntime().addShutdownHook(new Thread(INSTANCE::uninject));
        InputStream stream = IconInjector.class.getResourceAsStream(LOCATION);
        Path location = this.getDesktopFileLoc();
        String version = ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").orElseThrow()).getMetadata().getVersion().getFriendlyString();
        Intrinsics.checkNotNull((Object)location);
        object = stream != null && (object = (Object)stream.readAllBytes()) != null ? new String((byte[])object, Charsets.UTF_8) : "null";
        Object[] objectArray = new Object[2];
        objectArray[0] = version;
        Intrinsics.checkNotNullExpressionValue((Object)ICON_NAME.substring(0, StringsKt.lastIndexOf$default((CharSequence)ICON_NAME, (String)".", (int)0, (boolean)false, (int)6, null)), (String)"substring(...)");
        String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        String string2 = string;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.injectFile(location, byArray);
    }

    private final void uninject() {
        Iterable $this$forEach$iv = injects;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Path it = (Path)element$iv;
            boolean bl = false;
            Function0 function0 = () -> IconInjector.uninject$lambda$2$lambda$0(it);
            try {
                Function0 $this$uninject_u24lambda_u242_u24lambda_u241 = function0;
                boolean bl2 = false;
                object = Result.constructor-impl((Object)((Boolean)$this$uninject_u24lambda_u242_u24lambda_u241.invoke()));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
        this.updateIconSys();
    }

    public final void setIcon(@NotNull class_3262 resourcePack, @NotNull class_8518 icons) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)resourcePack, (String)"resourcePack");
        Intrinsics.checkNotNullParameter((Object)icons, (String)"icons");
        Function0 function0 = () -> IconInjector.setIcon$lambda$4(icons, resourcePack);
        try {
            Function0 $this$setIcon_u24lambda_u245 = function0;
            boolean bl = false;
            $this$setIcon_u24lambda_u245.invoke();
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object result = object;
        if (Result.isFailure-impl((Object)result)) {
            Throwable throwable = Result.exceptionOrNull-impl((Object)result);
            Intrinsics.checkNotNull((Object)throwable);
            throw throwable;
        }
    }

    private final void injectFile(Path target, byte[] data) {
        Object object;
        Function0 function0 = () -> IconInjector.injectFile$lambda$6(target, data);
        try {
            Function0 $this$injectFile_u24lambda_u247 = function0;
            boolean bl = false;
            object = Result.constructor-impl((Object)((Boolean)$this$injectFile_u24lambda_u247.invoke()));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object result = object;
        if (Result.isFailure-impl((Object)result)) {
            WayGL.LOGGER.error("Failed to inject file: " + target);
            WayGL.LOGGER.error(String.valueOf(Result.exceptionOrNull-impl((Object)result)));
        }
    }

    private final Path getIconFileLoc(int width, int height) {
        return XDG.INSTANCE.getUserDataLocation().resolve("icons/hicolor").resolve(width + "x" + height).resolve("apps").resolve(ICON_NAME);
    }

    private final Path getDesktopFileLoc() {
        return XDG.INSTANCE.getUserDataLocation().resolve("applications").resolve(FILE_NAME);
    }

    private final void updateIconSys() {
        Object object = new String[]{"xdg-icon-resource", "forceupdate"};
        object = new ProcessBuilder((String[])object);
        try {
            Object $this$updateIconSys_u24lambda_u248 = object;
            boolean bl = false;
            Object object2 = Result.constructor-impl((Object)((ProcessBuilder)$this$updateIconSys_u24lambda_u248).start());
        }
        catch (Throwable throwable) {
            Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private static final boolean uninject$lambda$2$lambda$0(Path $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return Files.deleteIfExists($it);
    }

    private static final Unit setIcon$lambda$4(class_8518 $icons, class_3262 $resourcePack) {
        Intrinsics.checkNotNullParameter((Object)$icons, (String)"$icons");
        Intrinsics.checkNotNullParameter((Object)$resourcePack, (String)"$resourcePack");
        List suppliers = $icons.method_51418($resourcePack);
        Intrinsics.checkNotNull((Object)suppliers);
        Iterable $this$forEach$iv = suppliers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path target;
            BufferedImage image;
            class_7367 it = (class_7367)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)ImageIO.read((InputStream)it.get()), (String)"read(...)");
            Intrinsics.checkNotNullExpressionValue((Object)INSTANCE.getIconFileLoc(image.getWidth(), image.getHeight()), (String)"getIconFileLoc(...)");
            byte[] byArray = ((InputStream)it.get()).readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            INSTANCE.injectFile(target, byArray);
        }
        return Unit.INSTANCE;
    }

    private static final boolean injectFile$lambda$6(Path $target, byte[] $data) {
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        Files.createDirectories($target.getParent(), new FileAttribute[0]);
        Files.write($target, $data, new OpenOption[0]);
        return injects.add($target);
    }
}

