/*
 * Decompiled with CFR 0.152.
 */
package net.wiredtomato.waygl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u000eJ\r\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lnet/wiredtomato/waygl/XDG;", "", "<init>", "()V", "Ljava/nio/file/Path;", "getHome", "()Ljava/nio/file/Path;", "getUserDataLocation", "", "getIconThemeLocations", "()Ljava/util/List;", "", "icon", "getIconTheme", "(Ljava/lang/String;)Ljava/nio/file/Path;", "themeName", "findInThemes", "(Ljava/lang/String;Ljava/lang/String;)Ljava/nio/file/Path;", "name", "getThemePath", "", "getCursorSize", "()I", "waygl"})
@SourceDebugExtension(value={"SMAP\nXDG.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XDG.kt\nnet/wiredtomato/waygl/XDG\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,114:1\n1#2:115\n37#3,2:116\n*S KotlinDebug\n*F\n+ 1 XDG.kt\nnet/wiredtomato/waygl/XDG\n*L\n73#1:116,2\n*E\n"})
public final class XDG {
    @NotNull
    public static final XDG INSTANCE = new XDG();

    private XDG() {
    }

    private final Path getHome() {
        String home = System.getenv().getOrDefault("HOME", System.getProperty("user.home"));
        if (!(home != null && !(((CharSequence)home).length() == 0))) {
            boolean bl = false;
            String string = "could not resolve user home";
            throw new IllegalStateException(string.toString());
        }
        Path path = Paths.get(home, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final Path getUserDataLocation() {
        String xdgDataHome = System.getenv("XDG_DATA_HOME");
        if (xdgDataHome == null || ((CharSequence)xdgDataHome).length() == 0) {
            Path path = this.getHome().resolve(".local/share/");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }
        Path path = Paths.get(xdgDataHome, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final List<Path> getIconThemeLocations() {
        Path userShare = this.getUserDataLocation().resolve("icons");
        Path homeIcons = this.getHome().resolve(".icons");
        Path systemIcons = Paths.get("/usr/share/icons", new String[0]);
        Object[] objectArray = new Path[]{userShare, homeIcons, systemIcons};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public final Path getIconTheme(@NotNull String icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        String themeName = null;
        String[] stringArray = new String[]{"gsettings", "get", "org.gnome.desktop.interface", "cursor-theme"};
        ProcessBuilder builder = new ProcessBuilder(stringArray);
        try {
            Process p = builder.start();
            String string = IOUtils.toString((InputStream)p.getInputStream(), (Charset)StandardCharsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String[] stringArray2 = new String[]{"'"};
            themeName = (String)StringsKt.split$default((CharSequence)string, (String[])stringArray2, (boolean)false, (int)0, (int)6, null).get(1);
            p.waitFor();
        }
        catch (IOException e) {
            themeName = "default";
        }
        catch (InterruptedException e) {
            themeName = "default";
        }
        return this.findInThemes(themeName, icon);
    }

    /*
     * WARNING - void declaration
     */
    private final Path findInThemes(String themeName, String icon) {
        Path themePath = this.getThemePath(themeName);
        Path iconPath = themePath.resolve(icon);
        if (Files.exists(iconPath, new LinkOption[0])) {
            return iconPath;
        }
        Path themeIndex = themePath.resolve("index.theme");
        if (Files.exists(themeIndex, new LinkOption[0])) {
            try {
                List<String> list = Files.readAllLines(themeIndex, StandardCharsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
                List<String> lines = list;
                boolean iconThemeFound = false;
                for (String s : lines) {
                    void $this$toTypedArray$iv;
                    if (Intrinsics.areEqual((Object)"[Icon Theme]", (Object)s)) {
                        iconThemeFound = true;
                    }
                    if (!iconThemeFound || StringsKt.startsWith$default((String)s, (String)"#", (boolean)false, (int)2, null)) continue;
                    Object object = s;
                    Regex regex = new Regex("=");
                    int n = 2;
                    object = regex.split((CharSequence)object, n);
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] parts = thisCollection$iv.toArray(new String[0]);
                    if (!Intrinsics.areEqual((Object)"Inherits", (Object)parts[0])) continue;
                    return this.findInThemes(parts[1], icon);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private final Path getThemePath(String name) {
        for (Path p : this.getIconThemeLocations()) {
            Path theme = p.resolve(name);
            if (!Files.exists(theme, new LinkOption[0])) continue;
            Intrinsics.checkNotNull((Object)theme);
            return theme;
        }
        if (Intrinsics.areEqual((Object)"default", (Object)name)) {
            String[] stringArray = new String[]{"share", "icons", "default"};
            Path path = Paths.get("usr", stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }
        return this.getThemePath("default");
    }

    public final int getCursorSize() {
        int size = 0;
        String[] stringArray = new String[]{"gsettings", "get", "org.gnome.desktop.interface", "cursor-size"};
        ProcessBuilder builder = new ProcessBuilder(stringArray);
        try {
            Process p = builder.start();
            String string = IOUtils.toString((InputStream)p.getInputStream(), (Charset)StandardCharsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String[] stringArray2 = new String[]{"\n"};
            size = Integer.parseInt((String)StringsKt.split$default((CharSequence)string, (String[])stringArray2, (boolean)false, (int)0, (int)6, null).get(0));
            p.waitFor();
        }
        catch (IOException e) {
            size = 24;
        }
        catch (InterruptedException e) {
            size = 24;
        }
        return size;
    }
}

