/*
 * Decompiled with CFR 0.152.
 */
package net.wiredtomato.waygl.workaround;

import kotlin.Metadata;
import net.wiredtomato.waygl.os.Libc;
import net.wiredtomato.waygl.os.OS;
import net.wiredtomato.waygl.os.OSUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003R\u001c\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lnet/wiredtomato/waygl/workaround/NvidiaWorkaround;", "", "<init>", "()V", "", "apply", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/slf4j/Logger;", "waygl"})
public final class NvidiaWorkaround {
    @NotNull
    public static final NvidiaWorkaround INSTANCE = new NvidiaWorkaround();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"WayGL::NvidiaWorkaround");

    private NvidiaWorkaround() {
    }

    public final void apply() {
        LOGGER.warn("Applying workaround: Prevent NVIDIA OpenGL driver from using broken optimization (NVIDIA_THREADED_OPTIMIZATIONS)");
        try {
            if (OSUtils.INSTANCE.os() == OS.LINUX) {
                Libc.INSTANCE.setEnvironmentVariable("__GL_THREADED_OPTIMIZATIONS", "0");
            }
        }
        catch (Throwable t) {
            LOGGER.error("Failed to apply NVIDIA workaround", t);
            LOGGER.error("READ ME! The workaround for the NVIDIA Graphics Driver did not apply correctly!");
            LOGGER.error("READ ME! Your game is highly likely to crash at startup");
            LOGGER.error("READ ME! For more information see: https://github.com/wired-tomato/WayGL/issues/1");
        }
    }
}

