/*
 * Decompiled with CFR 0.152.
 */
package net.wiredtomato.waygl.workaround.env;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.wiredtomato.waygl.workaround.env.GraphicsAdapterVendor;
import net.wiredtomato.waygl.workaround.env.LinuxAdapterInfo;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.util.ExecutingCommand;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001c\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lnet/wiredtomato/waygl/workaround/env/GraphicsAdapterProbe;", "", "<init>", "()V", "", "Lnet/wiredtomato/waygl/workaround/env/LinuxAdapterInfo;", "findLinuxAdapters", "()Ljava/util/List;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/slf4j/Logger;", "CACHE", "Ljava/util/List;", "waygl"})
public final class GraphicsAdapterProbe {
    @NotNull
    public static final GraphicsAdapterProbe INSTANCE = new GraphicsAdapterProbe();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"WayGL::GraphicsAdapterProbe");
    private static List<LinuxAdapterInfo> CACHE;

    private GraphicsAdapterProbe() {
    }

    @NotNull
    public final List<LinuxAdapterInfo> findLinuxAdapters() {
        Object object;
        if (CACHE != null) {
            List<LinuxAdapterInfo> list = CACHE;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"CACHE");
                list = null;
            }
            return list;
        }
        List results = new ArrayList();
        Object object2 = this;
        try {
            GraphicsAdapterProbe $this$findLinuxAdapters_u24lambda_u244 = object2;
            boolean bl = false;
            Path path = Paths.get("/sys/bus/pci/devices/", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Iterator devices = Files.list(path).iterator();
            while (devices.hasNext()) {
                Path devicePath = (Path)devices.next();
                String string = Files.readString(devicePath.resolve("class"));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
                String deviceClass = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (!Intrinsics.areEqual((Object)deviceClass, (Object)"0x030000") && !Intrinsics.areEqual((Object)deviceClass, (Object)"0x030200")) continue;
                String string2 = Files.readString(devicePath.resolve("vendor"));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
                String pciVendorId = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                String string3 = Files.readString(devicePath.resolve("device"));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"readString(...)");
                String pciDeviceId = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                String string4 = pciVendorId.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                String string5 = pciDeviceId.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                String name = ExecutingCommand.runNative((String)("lspci -vmm -d " + string4 + ":" + string5)).stream().filter(arg_0 -> GraphicsAdapterProbe.findLinuxAdapters$lambda$4$lambda$1(GraphicsAdapterProbe::findLinuxAdapters$lambda$4$lambda$0, arg_0)).map(arg_0 -> GraphicsAdapterProbe.findLinuxAdapters$lambda$4$lambda$3(GraphicsAdapterProbe::findLinuxAdapters$lambda$4$lambda$2, arg_0)).findFirst().orElse("unknown");
                GraphicsAdapterVendor vender = GraphicsAdapterVendor.Companion.fromPciVendorId(pciVendorId);
                Intrinsics.checkNotNull((Object)name);
                LinuxAdapterInfo info = new LinuxAdapterInfo(vender, name, pciVendorId, pciDeviceId);
                results.add(info);
            }
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            LOGGER.error("Failed to probe system for graphics adapters.");
            LOGGER.error("Is \"/sys/bus/pci/devices/*\" accessible?");
        }
        CACHE = results;
        List<LinuxAdapterInfo> list = CACHE;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"CACHE");
            list = null;
        }
        return list;
    }

    private static final boolean findLinuxAdapters$lambda$4$lambda$0(String it) {
        Intrinsics.checkNotNull((Object)it);
        return StringsKt.startsWith$default((String)it, (String)"Device:", (boolean)false, (int)2, null);
    }

    private static final boolean findLinuxAdapters$lambda$4$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String findLinuxAdapters$lambda$4$lambda$2(String it) {
        Intrinsics.checkNotNull((Object)it);
        String string = it.substring(7);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    private static final String findLinuxAdapters$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }
}

