/*
 * Decompiled with CFR 0.152.
 */
package net.wiredtomato.waygl.workaround.env;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u0000 \u00042\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lnet/wiredtomato/waygl/workaround/env/GraphicsAdapterVendor;", "", "<init>", "(Ljava/lang/String;I)V", "Companion", "NVIDIA", "AMD", "INTEL", "UNKNOWN", "waygl"})
public final class GraphicsAdapterVendor
extends Enum<GraphicsAdapterVendor> {
    @NotNull
    public static final Companion Companion;
    public static final /* enum */ GraphicsAdapterVendor NVIDIA;
    public static final /* enum */ GraphicsAdapterVendor AMD;
    public static final /* enum */ GraphicsAdapterVendor INTEL;
    public static final /* enum */ GraphicsAdapterVendor UNKNOWN;
    private static final /* synthetic */ GraphicsAdapterVendor[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    public static GraphicsAdapterVendor[] values() {
        return (GraphicsAdapterVendor[])$VALUES.clone();
    }

    public static GraphicsAdapterVendor valueOf(String value) {
        return Enum.valueOf(GraphicsAdapterVendor.class, value);
    }

    @NotNull
    public static EnumEntries<GraphicsAdapterVendor> getEntries() {
        return $ENTRIES;
    }

    static {
        NVIDIA = new GraphicsAdapterVendor();
        AMD = new GraphicsAdapterVendor();
        INTEL = new GraphicsAdapterVendor();
        UNKNOWN = new GraphicsAdapterVendor();
        $VALUES = graphicsAdapterVendorArray = new GraphicsAdapterVendor[]{GraphicsAdapterVendor.NVIDIA, GraphicsAdapterVendor.AMD, GraphicsAdapterVendor.INTEL, GraphicsAdapterVendor.UNKNOWN};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lnet/wiredtomato/waygl/workaround/env/GraphicsAdapterVendor$Companion;", "", "<init>", "()V", "", "vendor", "Lnet/wiredtomato/waygl/workaround/env/GraphicsAdapterVendor;", "fromPciVendorId", "(Ljava/lang/String;)Lnet/wiredtomato/waygl/workaround/env/GraphicsAdapterVendor;", "name", "fromIcdName", "waygl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GraphicsAdapterVendor fromPciVendorId(@NotNull String vendor) {
            Intrinsics.checkNotNullParameter((Object)vendor, (String)"vendor");
            if (StringsKt.contains$default((CharSequence)vendor, (CharSequence)"0x1002", (boolean)false, (int)2, null)) {
                return AMD;
            }
            if (StringsKt.contains$default((CharSequence)vendor, (CharSequence)"0x10de", (boolean)false, (int)2, null)) {
                return NVIDIA;
            }
            if (StringsKt.contains$default((CharSequence)vendor, (CharSequence)"0x8086", (boolean)false, (int)2, null)) {
                return INTEL;
            }
            return UNKNOWN;
        }

        @NotNull
        public final GraphicsAdapterVendor fromIcdName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            CharSequence charSequence = name;
            if (new Regex("ig(4|7|75|8|9|11|xelp|xehp)icd(32|64)").matches(charSequence)) {
                return INTEL;
            }
            charSequence = name;
            if (new Regex("nvoglv(32|64)").matches(charSequence)) {
                return NVIDIA;
            }
            charSequence = name;
            if (new Regex("atiglpxx|atig6pxx").matches(charSequence)) {
                return AMD;
            }
            return UNKNOWN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

