/*
 * Decompiled with CFR 0.152.
 */
package io.github.fourmisain.taxfreelevels.fabric;

import io.github.fourmisain.taxfreelevels.TaxFreeLevels;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinConfig
implements IMixinConfigPlugin {
    private final Set<String> disabledMixins = new HashSet<String>();
    private String mixinPackage;

    public static boolean isLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    public static boolean testVersion(String modId, String versionRange) {
        try {
            Optional container = FabricLoader.getInstance().getModContainer(modId);
            if (!container.isPresent()) {
                return false;
            }
            VersionPredicate pred = VersionPredicate.parse((String)versionRange);
            Version version = ((ModContainer)container.get()).getMetadata().getVersion();
            return pred.test((Object)version);
        }
        catch (VersionParsingException e) {
            TaxFreeLevels.LOGGER.error("version matching failed!", (Throwable)e);
            return false;
        }
    }

    public void onLoad(String mixinPackage) {
        this.mixinPackage = mixinPackage;
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            ModMetadata metadata = container.getMetadata();
            if (!metadata.containsCustomValue(TaxFreeLevels.CUSTOM_OPTIONS_FIELD)) continue;
            for (Map.Entry entry : metadata.getCustomValue(TaxFreeLevels.CUSTOM_OPTIONS_FIELD).getAsObject()) {
                String key = (String)entry.getKey();
                CustomValue value = (CustomValue)entry.getValue();
                if (!key.startsWith("mixin.")) continue;
                String mixinName = key.substring("mixin.".length());
                if (value.getAsBoolean()) continue;
                TaxFreeLevels.LOGGER.debug("{} disabled {}", (Object)metadata.getId(), (Object)mixinName);
                this.disabledMixins.add(mixinName);
            }
        }
        if (!MixinConfig.isLoaded("reroll")) {
            this.disabledMixins.add("RerollMixin");
        }
        if (!MixinConfig.isLoaded("charm")) {
            this.disabledMixins.add("Charm1_17Mixin");
            this.disabledMixins.add("CharmMixin");
        } else {
            this.disabledMixins.add(MixinConfig.testVersion("minecraft", ">=1.18") ? "Charm1_17Mixin" : "CharmMixin");
        }
        if (!MixinConfig.isLoaded("spectrum")) {
            this.disabledMixins.add("SpectrumLegacyMixin");
            this.disabledMixins.add("SpectrumMixin");
        } else {
            this.disabledMixins.add(MixinConfig.testVersion("spectrum", ">=1.7.9") ? "SpectrumLegacyMixin" : "SpectrumMixin");
        }
        if (!MixinConfig.isLoaded("enchantinginfuser")) {
            this.disabledMixins.add("EnchantingInfuserMixin");
        }
        if (MixinConfig.isLoaded("zenith") && MixinConfig.testVersion("fakerlib", ">=0.1.0")) {
            this.disabledMixins.add("FlattenAnvilCostMixin");
        } else {
            this.disabledMixins.add("EnchantmentUtilsMixin");
        }
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String mixinName = mixinClassName.substring(this.mixinPackage.length() + 1);
        return !this.disabledMixins.contains(mixinName);
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

