/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.command;

import com.majruszlibrary.command.Command;
import com.majruszlibrary.command.CommandData;
import com.majruszlibrary.command.IParameter;
import com.majruszlibrary.events.OnCommandsInitialized;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class CommandBuilder {
    final List<List<Command.IModification>> modifications = new ArrayList<List<Command.IModification>>();
    final List<ArgumentBuilder<class_2168, ?>> arguments = new ArrayList();

    public CommandBuilder copy() {
        CommandBuilder copy = new CommandBuilder();
        this.modifications.forEach(modification -> copy.modifications.add(new ArrayList(modification)));
        copy.arguments.addAll(this.arguments);
        return copy;
    }

    public CommandBuilder add(Predicate<class_2168> predicate) {
        return this.add((CommandBuilder builder) -> builder.getLastArgument().requires(predicate));
    }

    public CommandBuilder addArgument(Supplier<ArgumentBuilder<class_2168, ?>> argument) {
        return this.add((CommandBuilder builder) -> builder.addArgument((ArgumentBuilder)argument.get()));
    }

    public CommandBuilder literal(String ... names) {
        ArrayList<Command.IModification> modifications = new ArrayList<Command.IModification>();
        for (String name : names) {
            modifications.add(builder -> builder.addArgument((ArgumentBuilder<class_2168, ?>)class_2170.method_9247((String)name)));
        }
        return this.add(modifications);
    }

    public CommandBuilder parameter(IParameter<?> parameter) {
        return parameter.apply(this);
    }

    public CommandBuilder hasPermission(int requiredLevel) {
        return this.add((class_2168 stack) -> stack.method_9259(requiredLevel));
    }

    public CommandBuilder isPlayer() {
        return this.add(class_2168::method_43737);
    }

    public CommandBuilder execute(Command.IExecutable executable) {
        return this.add((CommandBuilder builder) -> builder.getLastArgument().executes(context -> executable.execute(new CommandData((CommandContext<class_2168>)context))));
    }

    public void register() {
        OnCommandsInitialized.listen(this::register);
    }

    CommandBuilder() {
    }

    void register(OnCommandsInitialized data) {
        List<List<Integer>> permutations = this.generatePermutations();
        for (List<Integer> permutation : permutations) {
            this.clearArguments();
            for (int idx = 0; idx < permutation.size(); ++idx) {
                this.modifications.get(idx).get(permutation.get(idx)).apply(this);
            }
            this.mergeArguments();
            try {
                data.dispatcher.register((LiteralArgumentBuilder)this.getFirstArgument());
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("First argument of any command must be a literal");
            }
        }
    }

    void addArgument(ArgumentBuilder<class_2168, ?> argument) {
        this.arguments.add(argument);
    }

    void clearArguments() {
        this.arguments.clear();
    }

    boolean emptyArguments() {
        return this.arguments.size() <= 0;
    }

    ArgumentBuilder<class_2168, ?> getFirstArgument() {
        if (this.emptyArguments()) {
            throw new IllegalArgumentException();
        }
        return this.arguments.get(0);
    }

    ArgumentBuilder<class_2168, ?> getLastArgument() {
        if (this.emptyArguments()) {
            throw new IllegalArgumentException();
        }
        return this.arguments.get(this.arguments.size() - 1);
    }

    void mergeArguments() {
        for (int idx = this.arguments.size(); idx >= 2; --idx) {
            ArgumentBuilder<class_2168, ?> previousArgument = this.arguments.get(idx - 2);
            ArgumentBuilder<class_2168, ?> nextArgument = this.arguments.get(idx - 1);
            previousArgument.then(nextArgument);
        }
    }

    List<List<Integer>> generatePermutations() {
        ArrayList<List<Integer>> permutations = new ArrayList<List<Integer>>();
        permutations.add(new ArrayList());
        for (List<Command.IModification> modification : this.modifications) {
            ArrayList newPermutations = new ArrayList();
            for (int idx = 0; idx < modification.size(); ++idx) {
                ArrayList copy = new ArrayList();
                for (List list : permutations) {
                    copy.add(new ArrayList(list));
                }
                for (List list : copy) {
                    list.add(idx);
                }
                newPermutations.addAll(copy);
            }
            permutations = newPermutations;
        }
        return permutations;
    }

    CommandBuilder add(Command.IModification modification) {
        ArrayList<Command.IModification> modifications = new ArrayList<Command.IModification>();
        modifications.add(modification);
        return this.add(modifications);
    }

    CommandBuilder add(List<Command.IModification> modifications) {
        this.modifications.add(modifications);
        return this;
    }
}

