/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.events;

import com.majruszlibrary.events.base.Event;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.events.type.ICancellableEvent;
import com.majruszlibrary.events.type.ILevelEvent;
import com.majruszlibrary.events.type.IPositionEvent;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;

public class OnExploded
implements ICancellableEvent,
ILevelEvent,
IPositionEvent {
    public final class_1927 explosion;
    public final class_1937 level;
    public final class_243 position;
    @Nullable
    public final class_1309 entity;
    public final float originalRadius;
    public float radius;
    public boolean spawnsFire;
    private Predicate<class_2338> positionFilter = blockPos -> false;
    private Predicate<class_1297> entityFilter = entity -> false;
    private boolean isExplosionCancelled = false;

    public static Event<OnExploded> listen(Consumer<OnExploded> consumer) {
        return Events.get(OnExploded.class).add(consumer);
    }

    public OnExploded(class_1927 explosion, class_1937 level, class_243 position, float radius, boolean spawnsFire) {
        this.explosion = explosion;
        this.level = level;
        this.position = position;
        this.entity = explosion.method_8347();
        this.originalRadius = radius;
        this.radius = radius;
        this.spawnsFire = spawnsFire;
    }

    @Override
    public boolean isExecutionStopped() {
        return this.isExplosionCancelled();
    }

    @Override
    public class_1937 getLevel() {
        return this.level;
    }

    @Override
    public class_243 getPosition() {
        return this.position;
    }

    public void filter(List<class_2338> positions, List<class_1297> entities) {
        positions.removeIf(this.positionFilter);
        entities.removeIf(this.entityFilter);
    }

    public void skipBlockIf(Predicate<class_2338> filter) {
        this.positionFilter = this.positionFilter.or(filter);
    }

    public void skipEntityIf(Predicate<class_1297> filter) {
        this.entityFilter = this.entityFilter.or(filter);
    }

    public void cancelExplosion() {
        this.isExplosionCancelled = true;
    }

    public boolean isExplosionCancelled() {
        return this.isExplosionCancelled;
    }
}

