/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.item;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.registry.Registries;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class EnchantmentHelper {
    public static int getLevel(Supplier<? extends class_1887> enchantment, class_1799 itemStack) {
        class_2960 enchantmentId = Registries.ENCHANTMENTS.getId(enchantment.get());
        for (EnchantmentDef enchantmentDef : EnchantmentHelper.read((class_1799)itemStack).enchantments) {
            if (!enchantmentId.equals((Object)enchantmentDef.id)) continue;
            return enchantmentDef.level;
        }
        return 0;
    }

    public static int getLevel(Supplier<? extends class_1887> enchantment, class_1309 entity) {
        return class_1890.method_8203((class_1887)enchantment.get(), (class_1309)entity);
    }

    public static int getLevelSum(Supplier<? extends class_1887> enchantment, Iterable<class_1799> itemStacks) {
        int sum = 0;
        for (class_1799 itemStack : itemStacks) {
            sum += EnchantmentHelper.getLevel(enchantment, itemStack);
        }
        return sum;
    }

    public static int getLevelSum(Supplier<? extends class_1887> enchantment, class_1309 entity) {
        int sum = 0;
        for (class_1799 itemStack : enchantment.get().method_8185(entity).values()) {
            sum += EnchantmentHelper.getLevel(enchantment, itemStack);
        }
        return sum;
    }

    public static int getLevelSum(Supplier<? extends class_1887> enchantment, class_1309 entity, Iterable<class_1304> slots) {
        int sum = 0;
        for (class_1304 slot : slots) {
            sum += EnchantmentHelper.getLevel(enchantment, entity.method_6118(slot));
        }
        return sum;
    }

    public static boolean has(Supplier<? extends class_1887> enchantment, class_1799 itemStack) {
        return EnchantmentHelper.getLevel(enchantment, itemStack) > 0;
    }

    public static boolean has(Supplier<? extends class_1887> enchantment, class_1309 entity) {
        return EnchantmentHelper.getLevel(enchantment, entity) > 0;
    }

    public static boolean increaseLevel(Supplier<? extends class_1887> enchantment, class_1799 itemStack) {
        class_2960 id = Registries.ENCHANTMENTS.getId(enchantment.get());
        EnchantmentsDef enchantmentsDef = EnchantmentHelper.read(itemStack);
        for (EnchantmentDef enchantmentDef : enchantmentsDef.enchantments) {
            if (!id.equals((Object)enchantmentDef.id)) continue;
            if (enchantmentDef.level >= enchantment.get().method_8183()) {
                return false;
            }
            ++enchantmentDef.level;
            Serializables.write(enchantmentsDef, itemStack.method_7948());
            return true;
        }
        enchantmentsDef.enchantments.add(new EnchantmentDef(id, 1));
        Serializables.write(enchantmentsDef, itemStack.method_7948());
        return true;
    }

    public static boolean remove(Supplier<? extends class_1887> enchantment, class_1799 itemStack) {
        class_2960 id = Registries.ENCHANTMENTS.getId(enchantment.get());
        EnchantmentsDef enchantmentsDef = EnchantmentHelper.read(itemStack);
        for (int idx = 0; idx < enchantmentsDef.enchantments.size(); ++idx) {
            if (!id.equals((Object)enchantmentsDef.enchantments.get((int)idx).id)) continue;
            enchantmentsDef.enchantments.remove(idx);
            Serializables.write(enchantmentsDef, itemStack.method_7969());
            return true;
        }
        return false;
    }

    public static EnchantmentsDef read(class_1799 itemStack) {
        EnchantmentsDef enchantmentsDef = new EnchantmentsDef();
        class_2487 tag = itemStack.method_7969();
        return tag != null ? Serializables.read(enchantmentsDef, (class_2520)tag) : enchantmentsDef;
    }

    public static class EnchantmentsDef {
        public List<EnchantmentDef> enchantments = new ArrayList<EnchantmentDef>();

        static {
            Serializables.get(EnchantmentsDef.class).define("Enchantments", Reader.list(Reader.custom(EnchantmentDef::new)), s -> s.enchantments, (s, v) -> {
                s.enchantments = v;
            });
        }
    }

    public static class EnchantmentDef {
        public class_2960 id;
        public int level;

        public EnchantmentDef(class_2960 id, int level) {
            this.id = id;
            this.level = level;
        }

        public EnchantmentDef() {
        }

        static {
            Serializables.get(EnchantmentDef.class).define("id", Reader.location(), s -> s.id, (s, v) -> {
                s.id = v;
            }).define("lvl", Reader.integer(), s -> s.level, (s, v) -> {
                s.level = v;
            });
        }
    }
}

