/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.modules.commands.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.hurts.octostudios.octolib.modules.config.ConfigManager;
import it.hurts.octostudios.octolib.modules.config.impl.OctoConfig;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class ConfigPathArgumentType
implements ArgumentType<OctoConfigArgument> {
    private static final Collection<String> EXAMPLES = Arrays.asList("mod/config1", "mod/dir/config2");
    private static final DynamicCommandExceptionType INVALID_PATH_EXCEPTION = new DynamicCommandExceptionType(path -> class_2561.method_43469((String)"argument.config.path.invalid", (Object[])new Object[]{path}));

    public static OctoConfigArgument getConfigArgument(CommandContext<class_2168> context, String name) {
        return (OctoConfigArgument)context.getArgument(name, OctoConfigArgument.class);
    }

    public OctoConfigArgument parse(StringReader stringReader) throws CommandSyntaxException {
        int i = stringReader.getCursor();
        String string = stringReader.readUnquotedString();
        OctoConfig octoConfig = ConfigManager.getConfig(string);
        if (octoConfig == null) {
            stringReader.setCursor(i);
            throw INVALID_PATH_EXCEPTION.createWithContext((ImmutableStringReader)stringReader, (Object)string);
        }
        return new OctoConfigArgument(string, octoConfig);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(ConfigManager.getAllPaths(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static class OctoConfigArgument {
        String path;
        OctoConfig config;

        public OctoConfigArgument(String path, OctoConfig config) {
            this.path = path;
            this.config = config;
        }

        public String getPath() {
            return this.path;
        }

        public OctoConfig getConfig() {
            return this.config;
        }
    }
}

