/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.registry;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.fzzyhmstrs.fzzy_config.FC;
import me.fzzyhmstrs.fzzy_config.annotations.Action;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.config.ConfigContext;
import me.fzzyhmstrs.fzzy_config.event.impl.EventApiImpl;
import me.fzzyhmstrs.fzzy_config.impl.ConfigApiImpl;
import me.fzzyhmstrs.fzzy_config.networking.ConfigPermissionsS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigSyncS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigUpdateS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.DynamicIdsS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.FzzyPayload;
import me.fzzyhmstrs.fzzy_config.networking.NetworkEvents;
import me.fzzyhmstrs.fzzy_config.networking.SettingForwardCustomPayload;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import me.fzzyhmstrs.fzzy_config.util.PortingUtils;
import me.fzzyhmstrs.fzzy_config.util.ValidationResult;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedIdentifier;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002OPB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ+\u0010\u0013\u001a\u00020\u00102\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012JG\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b0\u00182\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000e0\u0019H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJE\u0010!\u001a\u00020\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u001d2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b0\u00182\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000e0\u0019H\u0000\u00a2\u0006\u0004\b\u001f\u0010 Ji\u0010'\u001a\u00020\u00102\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00142\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b0\u00182\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000e0\u0019H\u0000\u00a2\u0006\u0004\b%\u0010&J_\u0010/\u001a\u00020\u00102\u0006\u0010)\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b0\u00182\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000e0\u0019H\u0000\u00a2\u0006\u0004\b-\u0010.J\u0015\u00103\u001a\b\u0012\u0004\u0012\u00020\u000500H\u0000\u00a2\u0006\u0004\b1\u00102J;\u0010;\u001a\u00020\u00102\u0006\u00104\u001a\u00020\u00052\u0014\u00107\u001a\u0010\u0012\u0004\u0012\u00020(\u0012\u0006\u0012\u0004\u0018\u000106052\f\u00108\u001a\b\u0012\u0004\u0012\u0002060\rH\u0000\u00a2\u0006\u0004\b9\u0010:J\u001f\u0010>\u001a\u00020\u00102\u0006\u00104\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0016H\u0000\u00a2\u0006\u0004\b<\u0010=J\u001f\u0010@\u001a\u00020\u00102\u0006\u00104\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0016H\u0000\u00a2\u0006\u0004\b?\u0010=J\u0017\u0010D\u001a\u00020A2\u0006\u00104\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\bB\u0010CJ\u0017\u0010H\u001a\u00020\u00102\u0006\u0010E\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\bF\u0010GR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060I8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010JR \u0010M\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020L0K8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bM\u0010N\u00a8\u0006Q"}, d2={"Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry;", "", "<init>", "()V", "", "", "Lme/fzzyhmstrs/fzzy_config/config/Config;", "syncedConfigs$fzzy_config", "()Ljava/util/Map;", "syncedConfigs", "Ljava/util/function/Predicate;", "Lnet/minecraft/class_2960;", "canSender", "Ljava/util/function/Consumer;", "Lme/fzzyhmstrs/fzzy_config/networking/FzzyPayload;", "sender", "", "onConfigure$fzzy_config", "(Ljava/util/function/Predicate;Ljava/util/function/Consumer;)V", "onConfigure", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/server/MinecraftServer;", "server", "Ljava/util/function/BiPredicate;", "Ljava/util/function/BiConsumer;", "onJoin$fzzy_config", "(Lnet/minecraft/class_3222;Lnet/minecraft/server/MinecraftServer;Ljava/util/function/BiPredicate;Ljava/util/function/BiConsumer;)V", "onJoin", "", "players", "onEndDataReload$fzzy_config", "(Ljava/util/List;Ljava/util/function/BiPredicate;Ljava/util/function/BiConsumer;)V", "onEndDataReload", "serializedConfigs", "serverPlayer", "changes", "receiveConfigUpdate$fzzy_config", "(Ljava/util/Map;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_3222;Ljava/util/List;Ljava/util/function/BiPredicate;Ljava/util/function/BiConsumer;)V", "receiveConfigUpdate", "Ljava/util/UUID;", "uuid", "scope", "update", "summary", "receiveSettingForward$fzzy_config", "(Ljava/util/UUID;Lnet/minecraft/class_3222;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/function/BiPredicate;Ljava/util/function/BiConsumer;)V", "receiveSettingForward", "", "quarantineList$fzzy_config", "()Ljava/util/Set;", "quarantineList", "id", "Ljava/util/function/Function;", "Lnet/minecraft/class_2561;", "nameFinder", "messageSender", "inspectQuarantine$fzzy_config", "(Ljava/lang/String;Ljava/util/function/Function;Ljava/util/function/Consumer;)V", "inspectQuarantine", "acceptQuarantine$fzzy_config", "(Ljava/lang/String;Lnet/minecraft/server/MinecraftServer;)V", "acceptQuarantine", "rejectQuarantine$fzzy_config", "rejectQuarantine", "", "hasConfig$fzzy_config", "(Ljava/lang/String;)Z", "hasConfig", "config", "registerConfig$fzzy_config", "(Lme/fzzyhmstrs/fzzy_config/config/Config;)V", "registerConfig", "", "Ljava/util/Map;", "Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry$LimitedHashMap;", "Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry$QuarantinedUpdate;", "quarantinedUpdates", "Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry$LimitedHashMap;", "LimitedHashMap", "QuarantinedUpdate", "fzzy_config"})
@SourceDebugExtension(value={"SMAP\nSyncedConfigRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncedConfigRegistry.kt\nme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,303:1\n1755#2,3:304\n1755#2,3:307\n*S KotlinDebug\n*F\n+ 1 SyncedConfigRegistry.kt\nme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry\n*L\n188#1:304,3\n267#1:307,3\n*E\n"})
public final class SyncedConfigRegistry {
    @NotNull
    public static final SyncedConfigRegistry INSTANCE = new SyncedConfigRegistry();
    @NotNull
    private static final Map<String, Config> syncedConfigs = new LinkedHashMap();
    @NotNull
    private static final LimitedHashMap<String, QuarantinedUpdate> quarantinedUpdates = new LimitedHashMap();

    private SyncedConfigRegistry() {
    }

    @NotNull
    public final Map<String, Config> syncedConfigs$fzzy_config() {
        return syncedConfigs;
    }

    public final void onConfigure$fzzy_config(@NotNull Predicate<class_2960> canSender, @NotNull Consumer<FzzyPayload> sender) {
        Intrinsics.checkNotNullParameter(canSender, (String)"canSender");
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        if (!canSender.test(ConfigSyncS2CCustomPayload.Companion.getId())) {
            return;
        }
        for (Map.Entry<String, Config> entry : syncedConfigs.entrySet()) {
            String id = entry.getKey();
            Config config = entry.getValue();
            List syncErrors = new ArrayList();
            ConfigSyncS2CCustomPayload payload = new ConfigSyncS2CCustomPayload(id, ConfigApi.serializeConfig(config, syncErrors, (byte)0));
            if (!((Collection)syncErrors).isEmpty()) {
                ValidationResult<Boolean> syncError = ValidationResult.Companion.error(true, "Error encountered while serializing config for S2C configuration stage sync.");
                syncError.writeError(syncErrors);
            }
            sender.accept(payload);
            try {
                config.onSyncServer();
            }
            catch (Throwable e) {
                FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered with login onSyncServer method of config " + id + "!");
                e.printStackTrace();
            }
            try {
                EventApiImpl.INSTANCE.fireOnSyncServer$fzzy_config(config.getId(), config);
            }
            catch (Throwable e) {
                FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered while running login onSyncServer event for config " + id + "!");
                e.printStackTrace();
            }
        }
    }

    public final void onJoin$fzzy_config(@NotNull class_3222 player, @NotNull MinecraftServer server, @NotNull BiPredicate<class_3222, class_2960> canSender, @NotNull BiConsumer<class_3222, FzzyPayload> sender) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter(canSender, (String)"canSender");
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        if (server.method_3724()) {
            ValidatedIdentifier.Companion.createSpSyncs$fzzy_config(PortingUtils.INSTANCE.getDynamicManager(player));
            return;
        }
        if (!canSender.test(player, ConfigPermissionsS2CCustomPayload.Companion.getId())) {
            return;
        }
        for (Map.Entry<String, Config> object : syncedConfigs.entrySet()) {
            String id = object.getKey();
            Config config = object.getValue();
            Map<String, Boolean> perms = ConfigApiImpl.INSTANCE.generatePermissionsReport$fzzy_config((class_1657)player, config, (byte)0);
            ConfigPermissionsS2CCustomPayload payload = new ConfigPermissionsS2CCustomPayload(id, perms);
            sender.accept(player, payload);
        }
        List<DynamicIdsS2CCustomPayload> dynamicIdSyncs = ValidatedIdentifier.Companion.createSyncs$fzzy_config(PortingUtils.INSTANCE.getDynamicManager(player));
        if (dynamicIdSyncs.isEmpty()) {
            return;
        }
        for (DynamicIdsS2CCustomPayload sync : dynamicIdSyncs) {
            sender.accept(player, sync);
        }
    }

    public final void onEndDataReload$fzzy_config(@NotNull List<? extends class_3222> players, @NotNull BiPredicate<class_3222, class_2960> canSender, @NotNull BiConsumer<class_3222, FzzyPayload> sender) {
        Intrinsics.checkNotNullParameter(players, (String)"players");
        Intrinsics.checkNotNullParameter(canSender, (String)"canSender");
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        for (class_3222 class_32222 : players) {
            if (!canSender.test(class_32222, ConfigSyncS2CCustomPayload.Companion.getId())) continue;
            for (Map.Entry<String, Config> entry : syncedConfigs.entrySet()) {
                String id = entry.getKey();
                Config config = entry.getValue();
                List syncErrors = new ArrayList();
                ConfigSyncS2CCustomPayload syncPayload = new ConfigSyncS2CCustomPayload(id, ConfigApi.serializeConfig(config, syncErrors, (byte)0));
                if (!((Collection)syncErrors).isEmpty()) {
                    ValidationResult<Boolean> syncError = ValidationResult.Companion.error(true, "Error encountered while serializing config for S2C datapack reload sync.");
                    syncError.writeError(syncErrors);
                }
                sender.accept(class_32222, syncPayload);
                if (!canSender.test(class_32222, ConfigPermissionsS2CCustomPayload.Companion.getId())) continue;
                Map<String, Boolean> perms = ConfigApiImpl.INSTANCE.generatePermissionsReport$fzzy_config((class_1657)class_32222, config, (byte)0);
                ConfigPermissionsS2CCustomPayload permsPayload = new ConfigPermissionsS2CCustomPayload(id, perms);
                sender.accept(class_32222, permsPayload);
                try {
                    config.onSyncServer();
                }
                catch (Throwable e) {
                    FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered with reload onSyncServer method of config " + id + ", for player " + class_32222 + "!");
                    e.printStackTrace();
                }
                try {
                    EventApiImpl.INSTANCE.fireOnSyncServer$fzzy_config(config.getId(), config);
                }
                catch (Throwable e) {
                    FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered while running reload onSyncServer event for config " + id + ", for player " + class_32222 + "!");
                    e.printStackTrace();
                }
            }
            if (class_32222.field_13995.method_3724()) {
                ValidatedIdentifier.Companion.createSpSyncs$fzzy_config(PortingUtils.INSTANCE.getDynamicManager(class_32222));
                continue;
            }
            List<DynamicIdsS2CCustomPayload> dynamicIdSyncs = ValidatedIdentifier.Companion.createSyncs$fzzy_config(PortingUtils.INSTANCE.getDynamicManager(class_32222));
            if (dynamicIdSyncs.isEmpty()) continue;
            for (DynamicIdsS2CCustomPayload sync : dynamicIdSyncs) {
                sender.accept(class_32222, sync);
            }
        }
    }

    public final void receiveConfigUpdate$fzzy_config(@NotNull Map<String, String> serializedConfigs, @NotNull MinecraftServer server, @NotNull class_3222 serverPlayer, @NotNull List<String> changes, @NotNull BiPredicate<class_3222, class_2960> canSender, @NotNull BiConsumer<class_3222, FzzyPayload> sender) {
        Intrinsics.checkNotNullParameter(serializedConfigs, (String)"serializedConfigs");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter(canSender, (String)"canSender");
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        Map successfulUpdates = new LinkedHashMap();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        for (Map.Entry<String, String> entry : serializedConfigs.entrySet()) {
            boolean bl;
            ValidationResult<ConfigContext<Config>> result;
            Config config;
            String configString;
            String id;
            block13: {
                ValidationResult<List<String>> validationResult;
                id = entry.getKey();
                configString = entry.getValue();
                config = syncedConfigs.get(id);
                if (config == null) {
                    FC.INSTANCE.getLOGGER$fzzy_config().error("Config " + id + " wasn't found!, Skipping update");
                    continue;
                }
                if (!server.method_3724() && (validationResult = ConfigApiImpl.INSTANCE.validatePermissions$fzzy_config(serverPlayer, id, config, configString)).isError()) {
                    FC.INSTANCE.getLOGGER$fzzy_config().error("Player [" + serverPlayer.method_5477() + "] may have tried to cheat changes onto the Server Config! Problem settings found: " + CollectionsKt.joinToString$default((Iterable)validationResult.get(), (CharSequence)" | ", null, null, (int)0, null, null, (int)62, null));
                    FC.INSTANCE.getLOGGER$fzzy_config().error("This update has not been applied, and has been moved to quarantine. Use the configure_update command to inspect and permit or deny the update.");
                    FC.INSTANCE.getLOGGER$fzzy_config().warn("If no action is taken, the quarantined update will be flushed on the next server restart, and its changes will not be applied");
                    ConfigApiImpl.INSTANCE.printChangeHistory$fzzy_config(changes, serializedConfigs.keySet().toString(), (class_1657)serverPlayer);
                    UUID uUID = serverPlayer.method_5667();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
                    QuarantinedUpdate quarantine = new QuarantinedUpdate(uUID, changes, id, configString);
                    String quarantineId = id + " @" + serverPlayer.method_5477().getString() + " @" + formatter.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(System.currentTimeMillis()), ZoneId.systemDefault()));
                    ((Map)quarantinedUpdates).put(quarantineId, quarantine);
                    for (class_3222 player : server.method_3760().method_14571()) {
                        Intrinsics.checkNotNull((Object)player);
                        if (ConfigApiImpl.INSTANCE.isConfigAdmin$fzzy_config((class_1657)player, config)) {
                            Object[] objectArray = new Object[]{serverPlayer.method_5477()};
                            player.method_43502((class_2561)FcText.INSTANCE.translate("fc.networking.permission.cheat", objectArray), false);
                        }
                        player.method_43502((class_2561)FcText.INSTANCE.translate("fc.command.accept", new Object[0]).method_27694(arg_0 -> SyncedConfigRegistry.receiveConfigUpdate$lambda$0(id, arg_0)), false);
                        player.method_43502((class_2561)FcText.INSTANCE.translate("fc.command.accept", new Object[0]).method_27694(arg_0 -> SyncedConfigRegistry.receiveConfigUpdate$lambda$1(id, arg_0)), false);
                        player.method_43502((class_2561)FcText.INSTANCE.translate("fc.command.accept", new Object[0]).method_27694(arg_0 -> SyncedConfigRegistry.receiveConfigUpdate$lambda$2(id, arg_0)), false);
                    }
                    continue;
                }
                List errors = new ArrayList();
                result = ConfigApiImpl.INSTANCE.deserializeUpdate$fzzy_config(config, configString, errors, (byte)10);
                Set actions = result.get().getOrDefault(ConfigContext.Keys.getACTIONS(), SetsKt.emptySet());
                result.writeError(errors);
                result.get().getConfig().save();
                Iterable $this$any$iv = actions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Action it = (Action)((Object)element$iv);
                        boolean bl2 = false;
                        if (!it.getRestartPrompt()) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl) {
                FC.INSTANCE.getLOGGER$fzzy_config().warn("The server has received a config update that may require a restart. Connected clients have been automatically updated and notified of the potential for restart.");
                Set<String> records = result.get().get(ConfigContext.Keys.getRESTART_RECORDS());
                Collection collection = records;
                if (!(collection == null || collection.isEmpty())) {
                    FC.INSTANCE.getLOGGER$fzzy_config().info("Server prompted for a restart due to received config changes");
                    FC.INSTANCE.getLOGGER$fzzy_config().info("Restart-prompting changes:");
                    for (String record : records) {
                        FC.INSTANCE.getLOGGER$fzzy_config().info(record);
                    }
                }
            }
            successfulUpdates.put(id, configString);
            server.execute(() -> SyncedConfigRegistry.receiveConfigUpdate$lambda$4(config, serverPlayer, id));
        }
        if (!server.method_3724()) {
            for (class_3222 player : serverPlayer.field_13995.method_3760().method_14571()) {
                if (Intrinsics.areEqual((Object)player, (Object)serverPlayer) || !canSender.test(player, ConfigUpdateS2CCustomPayload.Companion.getId())) continue;
                ConfigUpdateS2CCustomPayload newPayload = new ConfigUpdateS2CCustomPayload(successfulUpdates);
                sender.accept(player, newPayload);
            }
        }
        ConfigApiImpl.INSTANCE.printChangeHistory$fzzy_config(changes, serializedConfigs.keySet().toString(), (class_1657)serverPlayer);
    }

    public final void receiveSettingForward$fzzy_config(@NotNull UUID uuid, @NotNull class_3222 player, @NotNull String scope, @NotNull String update, @NotNull String summary, @NotNull BiPredicate<class_3222, class_2960> canSender, @NotNull BiConsumer<class_3222, FzzyPayload> sender) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
        Intrinsics.checkNotNullParameter(canSender, (String)"canSender");
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        class_3222 class_32222 = player.field_13995.method_3760().method_14602(uuid);
        if (class_32222 == null) {
            return;
        }
        class_3222 receivingPlayer = class_32222;
        if (!canSender.test(receivingPlayer, SettingForwardCustomPayload.Companion.getId())) {
            player.method_43496((class_2561)FcText.INSTANCE.translate("fc.config.forwarded_error.s2c", new Object[0]));
            return;
        }
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        sender.accept(receivingPlayer, new SettingForwardCustomPayload(update, uUID, scope, summary));
    }

    @NotNull
    public final Set<String> quarantineList$fzzy_config() {
        Set<String> set = quarantinedUpdates.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return set;
    }

    public final void inspectQuarantine$fzzy_config(@NotNull String id, @NotNull Function<UUID, class_2561> nameFinder, @NotNull Consumer<class_2561> messageSender) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(nameFinder, (String)"nameFinder");
        Intrinsics.checkNotNullParameter(messageSender, (String)"messageSender");
        QuarantinedUpdate quarantinedUpdate = (QuarantinedUpdate)quarantinedUpdates.get(id);
        if (quarantinedUpdate == null) {
            return;
        }
        QuarantinedUpdate quarantinedUpdate2 = quarantinedUpdate;
        messageSender.accept((class_2561)FcText.INSTANCE.translate("fc.command.config", new Object[0]));
        messageSender.accept((class_2561)FcText.INSTANCE.translate(quarantinedUpdate2.getConfigId(), new Object[0]));
        messageSender.accept((class_2561)FcText.INSTANCE.translate("fc.command.player", new Object[0]));
        String string = quarantinedUpdate2.getPlayerUuid().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        messageSender.accept((class_2561)FcText.INSTANCE.lit(string));
        class_2561 class_25612 = nameFinder.apply(quarantinedUpdate2.getPlayerUuid());
        if (class_25612 != null) {
            class_2561 it = class_25612;
            boolean bl = false;
            messageSender.accept(it);
        }
        messageSender.accept((class_2561)FcText.INSTANCE.translate("fc.command.history", new Object[0]));
        for (String str : quarantinedUpdate2.getChangeHistory()) {
            messageSender.accept((class_2561)FcText.INSTANCE.lit(str));
        }
        messageSender.accept((class_2561)FcText.INSTANCE.translate("fc.command.accept", new Object[0]).method_27694(arg_0 -> SyncedConfigRegistry.inspectQuarantine$lambda$6(id, arg_0)));
        messageSender.accept((class_2561)FcText.INSTANCE.translate("fc.command.reject", new Object[0]).method_27694(arg_0 -> SyncedConfigRegistry.inspectQuarantine$lambda$7(id, arg_0)));
    }

    public final void acceptQuarantine$fzzy_config(@NotNull String id, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        QuarantinedUpdate quarantinedUpdate = (QuarantinedUpdate)quarantinedUpdates.get(id);
        if (quarantinedUpdate == null) {
            return;
        }
        QuarantinedUpdate quarantinedUpdate2 = quarantinedUpdate;
        Config config = syncedConfigs.get(quarantinedUpdate2.getConfigId());
        class_3222 player = server.method_3760().method_14602(quarantinedUpdate2.getPlayerUuid());
        if (config != null) {
            boolean bl;
            block10: {
                List errors = new ArrayList();
                ValidationResult<ConfigContext<Config>> result = ConfigApiImpl.INSTANCE.deserializeUpdate$fzzy_config(config, quarantinedUpdate2.getConfigString(), errors, (byte)2);
                Set actions = result.get().getOrDefault(ConfigContext.Keys.getACTIONS(), SetsKt.emptySet());
                result.writeError(errors);
                result.get().getConfig().save();
                Iterable $this$any$iv = actions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Action it = (Action)((Object)element$iv);
                        boolean bl2 = false;
                        if (!it.getRestartPrompt()) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (bl) {
                FC.INSTANCE.getLOGGER$fzzy_config().warn("The server accepted a quarantined config update that may require a restart, please consult the change history below for details. Connected clients have been automatically updated and notified of the potential for restart.");
            }
            for (class_3222 p : server.method_3760().method_14571()) {
                if (Intrinsics.areEqual((Object)p, (Object)player)) continue;
                Intrinsics.checkNotNull((Object)p);
                if (!NetworkEvents.INSTANCE.canSend(p, ConfigUpdateS2CCustomPayload.Companion.getId())) continue;
                ConfigUpdateS2CCustomPayload newPayload = new ConfigUpdateS2CCustomPayload(MapsKt.mapOf((Pair)TuplesKt.to((Object)quarantinedUpdate2.getConfigId(), (Object)quarantinedUpdate2.getConfigString())));
                NetworkEvents.INSTANCE.send(p, newPayload);
            }
        }
        class_3222 class_32222 = player;
        if (class_32222 != null) {
            class_3222 it = class_32222;
            boolean bl = false;
            if (NetworkEvents.INSTANCE.canSend(player, ConfigPermissionsS2CCustomPayload.Companion.getId())) {
                for (Map.Entry<String, Config> entry : syncedConfigs.entrySet()) {
                    String id2 = entry.getKey();
                    Config config2 = entry.getValue();
                    Map<String, Boolean> perms = ConfigApiImpl.INSTANCE.generatePermissionsReport$fzzy_config((class_1657)player, config2, (byte)0);
                    class_2540 buf = PacketByteBufs.create();
                    ConfigPermissionsS2CCustomPayload payload = new ConfigPermissionsS2CCustomPayload(id2, perms);
                    NetworkEvents.INSTANCE.send(player, payload);
                }
            }
        }
        quarantinedUpdates.remove(id);
    }

    public final void rejectQuarantine$fzzy_config(@NotNull String id, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        quarantinedUpdates.remove(id);
    }

    public final boolean hasConfig$fzzy_config(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return syncedConfigs.containsKey(id);
    }

    public final void registerConfig$fzzy_config(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        syncedConfigs.put(config.getId().method_42094(), config);
    }

    private static final class_2583 receiveConfigUpdate$lambda$0(String $id, class_2583 s) {
        return s.method_10958(new class_2558(class_2558.class_2559.field_11750, "/configure_update \"" + $id + "\" inspect"));
    }

    private static final class_2583 receiveConfigUpdate$lambda$1(String $id, class_2583 s) {
        return s.method_10958(new class_2558(class_2558.class_2559.field_11750, "/configure_update \"" + $id + "\" accept"));
    }

    private static final class_2583 receiveConfigUpdate$lambda$2(String $id, class_2583 s) {
        return s.method_10958(new class_2558(class_2558.class_2559.field_11750, "/configure_update \"" + $id + "\" reject"));
    }

    private static final void receiveConfigUpdate$lambda$4(Config $config, class_3222 $serverPlayer, String $id) {
        try {
            $config.onUpdateServer($serverPlayer);
        }
        catch (Throwable e) {
            FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered with onUpdateServer method of config " + $id + "!");
            e.printStackTrace();
        }
        try {
            EventApiImpl.INSTANCE.fireOnUpdateServer$fzzy_config($config.getId(), $config, $serverPlayer);
        }
        catch (Throwable e) {
            FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered while running onUpdateServer event for config " + $id + "!");
            e.printStackTrace();
        }
    }

    private static final class_2583 inspectQuarantine$lambda$6(String $id, class_2583 s) {
        return s.method_10958(new class_2558(class_2558.class_2559.field_11750, "/configure_update \"" + $id + "\" accept"));
    }

    private static final class_2583 inspectQuarantine$lambda$7(String $id, class_2583 s) {
        return s.method_10958(new class_2558(class_2558.class_2559.field_11750, "/configure_update \"" + $id + "\" reject"));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010'\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\t\u001a\u00020\b2\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0006H\u0014\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry$LimitedHashMap;", "K", "V", "Ljava/util/LinkedHashMap;", "<init>", "()V", "", "eldest", "", "removeEldestEntry", "(Ljava/util/Map$Entry;)Z", "fzzy_config"})
    private static final class LimitedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        @Override
        protected boolean removeEldestEntry(@Nullable Map.Entry<K, V> eldest) {
            return this.size() > 128;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0007\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\b\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0011\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry$QuarantinedUpdate;", "", "Ljava/util/UUID;", "playerUuid", "", "", "changeHistory", "configId", "configString", "<init>", "(Ljava/util/UUID;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "Ljava/util/UUID;", "getPlayerUuid", "()Ljava/util/UUID;", "Ljava/util/List;", "getChangeHistory", "()Ljava/util/List;", "Ljava/lang/String;", "getConfigId", "()Ljava/lang/String;", "getConfigString", "fzzy_config"})
    public static final class QuarantinedUpdate {
        @NotNull
        private final UUID playerUuid;
        @NotNull
        private final List<String> changeHistory;
        @NotNull
        private final String configId;
        @NotNull
        private final String configString;

        public QuarantinedUpdate(@NotNull UUID playerUuid, @NotNull List<String> changeHistory, @NotNull String configId, @NotNull String configString) {
            Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
            Intrinsics.checkNotNullParameter(changeHistory, (String)"changeHistory");
            Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
            Intrinsics.checkNotNullParameter((Object)configString, (String)"configString");
            this.playerUuid = playerUuid;
            this.changeHistory = changeHistory;
            this.configId = configId;
            this.configString = configString;
        }

        @NotNull
        public final UUID getPlayerUuid() {
            return this.playerUuid;
        }

        @NotNull
        public final List<String> getChangeHistory() {
            return this.changeHistory;
        }

        @NotNull
        public final String getConfigId() {
            return this.configId;
        }

        @NotNull
        public final String getConfigString() {
            return this.configString;
        }
    }
}

